/*
 * Decompiled with CFR 0.152.
 */
package cloud.tianai.captcha.spring.aop;

import cloud.tianai.captcha.common.response.ApiResponse;
import cloud.tianai.captcha.spring.annotation.Captcha;
import cloud.tianai.captcha.spring.application.ImageCaptchaApplication;
import cloud.tianai.captcha.spring.exception.CaptchaValidException;
import cloud.tianai.captcha.spring.request.CaptchaRequest;
import cloud.tianai.captcha.validator.common.model.dto.ImageCaptchaTrack;
import java.lang.reflect.Method;
import org.aopalliance.intercept.MethodInterceptor;
import org.aopalliance.intercept.MethodInvocation;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.beans.factory.BeanFactoryAware;
import org.springframework.core.BridgeMethodResolver;
import org.springframework.core.annotation.AnnotationUtils;

public class CaptchaInterceptor
implements MethodInterceptor,
BeanFactoryAware {
    private static final Logger log = LoggerFactory.getLogger(CaptchaInterceptor.class);
    private ImageCaptchaApplication captchaApplication;
    private BeanFactory beanFactory;

    public Object invoke(MethodInvocation invocation) throws Throwable {
        Method bridgedMethod = BridgeMethodResolver.findBridgedMethod((Method)invocation.getMethod());
        Captcha annotation = (Captcha)AnnotationUtils.findAnnotation((Method)bridgedMethod, Captcha.class);
        String type = annotation.type();
        Object[] arguments = invocation.getArguments();
        CaptchaRequest captchaRequest = null;
        for (Object arg : arguments) {
            if (!(arg instanceof CaptchaRequest)) continue;
            captchaRequest = (CaptchaRequest)arg;
            break;
        }
        if (captchaRequest == null) {
            log.warn("\u9a8c\u8bc1\u7801\u9a8c\u8bc1 \u65b9\u6cd5\u540d\u79f0:{} \u6ca1\u6709\u627e\u5230CaptchaRequest<?> \u5bf9\u8c61", (Object)invocation.getMethod().getName());
            return invocation.proceed();
        }
        String id = captchaRequest.getId();
        ImageCaptchaTrack captchaTrack = captchaRequest.getCaptchaTrack();
        if (captchaTrack == null) {
            throw new CaptchaValidException(type, "ImageCaptchaTrack \u4e0d\u80fd\u4e3a\u7a7a");
        }
        ApiResponse<?> matching = this.getSliderCaptchaApplication().matching(id, captchaTrack);
        if (matching.isSuccess()) {
            return invocation.proceed();
        }
        throw new CaptchaValidException(type, matching.getCode(), matching.getMsg());
    }

    public ImageCaptchaApplication getSliderCaptchaApplication() {
        if (this.captchaApplication == null) {
            this.captchaApplication = (ImageCaptchaApplication)this.beanFactory.getBean(ImageCaptchaApplication.class);
        }
        return this.captchaApplication;
    }

    public void setBeanFactory(BeanFactory beanFactory) throws BeansException {
        this.beanFactory = beanFactory;
    }
}

