/*
 * Decompiled with CFR 0.152.
 */
package cloud.tianai.captcha.spring.application;

import cloud.tianai.captcha.common.exception.ImageCaptchaException;
import cloud.tianai.captcha.common.response.ApiResponse;
import cloud.tianai.captcha.common.response.ApiResponseStatusConstant;
import cloud.tianai.captcha.common.response.CodeDefinition;
import cloud.tianai.captcha.generator.ImageCaptchaGenerator;
import cloud.tianai.captcha.generator.common.model.dto.GenerateParam;
import cloud.tianai.captcha.generator.common.model.dto.ImageCaptchaInfo;
import cloud.tianai.captcha.resource.ImageCaptchaResourceManager;
import cloud.tianai.captcha.spring.application.CaptchaImageType;
import cloud.tianai.captcha.spring.application.ImageCaptchaApplication;
import cloud.tianai.captcha.spring.autoconfiguration.ImageCaptchaProperties;
import cloud.tianai.captcha.spring.exception.CaptchaValidException;
import cloud.tianai.captcha.spring.store.CacheStore;
import cloud.tianai.captcha.spring.vo.CaptchaResponse;
import cloud.tianai.captcha.spring.vo.ImageCaptchaVO;
import cloud.tianai.captcha.validator.ImageCaptchaValidator;
import cloud.tianai.captcha.validator.common.model.dto.ImageCaptchaTrack;
import cloud.tianai.captcha.validator.impl.SimpleImageCaptchaValidator;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultImageCaptchaApplication
implements ImageCaptchaApplication {
    private static final Logger log = LoggerFactory.getLogger(DefaultImageCaptchaApplication.class);
    private ImageCaptchaGenerator template;
    private ImageCaptchaValidator imageCaptchaValidator;
    private CacheStore cacheStore;
    private final ImageCaptchaProperties prop;
    private long defaultExpire = 20000L;

    public DefaultImageCaptchaApplication(ImageCaptchaGenerator template, ImageCaptchaValidator imageCaptchaValidator, CacheStore cacheStore, ImageCaptchaProperties prop) {
        this.prop = prop;
        this.setImageCaptchaTemplate(template);
        this.setImageCaptchaValidator(imageCaptchaValidator);
        this.setCacheStore(cacheStore);
        Long defaultExpire = prop.getExpire().get("default");
        if (defaultExpire != null && defaultExpire > 0L) {
            this.defaultExpire = defaultExpire;
        }
    }

    @Override
    public CaptchaResponse<ImageCaptchaVO> generateCaptcha() {
        return this.generateCaptcha("SLIDER");
    }

    @Override
    public CaptchaResponse<ImageCaptchaVO> generateCaptcha(String type) {
        ImageCaptchaInfo slideImageInfo = this.getImageCaptchaTemplate().generateCaptchaImage(type);
        return this.afterGenerateSliderCaptcha(slideImageInfo);
    }

    @Override
    public CaptchaResponse<ImageCaptchaVO> generateCaptcha(GenerateParam param) {
        ImageCaptchaInfo slideImageInfo = this.getImageCaptchaTemplate().generateCaptchaImage(param);
        return this.afterGenerateSliderCaptcha(slideImageInfo);
    }

    @Override
    public CaptchaResponse<ImageCaptchaVO> generateCaptcha(CaptchaImageType captchaImageType) {
        return this.generateCaptcha("SLIDER", captchaImageType);
    }

    @Override
    public CaptchaResponse<ImageCaptchaVO> generateCaptcha(String type, CaptchaImageType captchaImageType) {
        GenerateParam param = new GenerateParam();
        if (CaptchaImageType.WEBP.equals((Object)captchaImageType)) {
            param.setBackgroundFormatName("webp");
            param.setTemplateFormatName("webp");
        } else {
            param.setBackgroundFormatName("jpeg");
            param.setTemplateFormatName("png");
        }
        param.setType(type);
        return this.generateCaptcha(param);
    }

    public CaptchaResponse<ImageCaptchaVO> afterGenerateSliderCaptcha(ImageCaptchaInfo slideImageInfo) {
        if (slideImageInfo == null) {
            throw new ImageCaptchaException("\u751f\u6210\u6ed1\u5757\u9a8c\u8bc1\u7801\u5931\u8d25\uff0c\u9a8c\u8bc1\u7801\u751f\u6210\u4e3a\u7a7a");
        }
        String id = this.generatorId();
        Map validData = this.getImageCaptchaValidator().generateImageCaptchaValidData(slideImageInfo);
        this.cacheVerification(id, slideImageInfo.getType(), validData);
        ImageCaptchaVO verificationVO = new ImageCaptchaVO();
        verificationVO.setType(slideImageInfo.getType());
        verificationVO.setBackgroundImage(slideImageInfo.getBackgroundImage());
        verificationVO.setTemplateImage(slideImageInfo.getTemplateImage());
        verificationVO.setBackgroundImageTag(slideImageInfo.getBackgroundImageTag());
        verificationVO.setTemplateImageTag(slideImageInfo.getTemplateImageTag());
        verificationVO.setBackgroundImageWidth(slideImageInfo.getBackgroundImageWidth());
        verificationVO.setBackgroundImageHeight(slideImageInfo.getBackgroundImageHeight());
        verificationVO.setTemplateImageWidth(slideImageInfo.getTemplateImageWidth());
        verificationVO.setTemplateImageHeight(slideImageInfo.getTemplateImageHeight());
        verificationVO.setData(slideImageInfo.getData() == null ? null : slideImageInfo.getData().getViewData());
        return CaptchaResponse.of(id, verificationVO);
    }

    @Override
    public ApiResponse<?> matching(String id, ImageCaptchaTrack imageCaptchaTrack) {
        Map<String, Object> cachePercentage = this.getVerification(id);
        if (cachePercentage == null) {
            return ApiResponse.ofMessage((CodeDefinition)ApiResponseStatusConstant.EXPIRED);
        }
        return this.getImageCaptchaValidator().valid(imageCaptchaTrack, cachePercentage);
    }

    @Override
    public boolean matching(String id, Float percentage) {
        Map<String, Object> cachePercentage = this.getVerification(id);
        if (cachePercentage == null) {
            return false;
        }
        ImageCaptchaValidator imageCaptchaValidator = this.getImageCaptchaValidator();
        if (!(imageCaptchaValidator instanceof SimpleImageCaptchaValidator)) {
            return false;
        }
        SimpleImageCaptchaValidator simpleImageCaptchaValidator = (SimpleImageCaptchaValidator)imageCaptchaValidator;
        Float oriPercentage = simpleImageCaptchaValidator.getFloatParam("percentage", cachePercentage);
        Float tolerant = simpleImageCaptchaValidator.getFloatParam("tolerant", cachePercentage, Float.valueOf(simpleImageCaptchaValidator.getDefaultTolerant()));
        return simpleImageCaptchaValidator.checkPercentage(percentage, oriPercentage, tolerant.floatValue());
    }

    protected String generatorId() {
        return UUID.randomUUID().toString().replace("-", "");
    }

    protected Map<String, Object> getVerification(String id) {
        return this.getCacheStore().getAndRemoveCache(this.getKey(id));
    }

    protected void cacheVerification(String id, String type, Map<String, Object> validData) {
        Long expire = this.prop.getExpire().getOrDefault(type, this.defaultExpire);
        if (!this.getCacheStore().setCache(this.getKey(id), validData, expire, TimeUnit.MILLISECONDS)) {
            log.error("\u7f13\u5b58\u9a8c\u8bc1\u7801\u6570\u636e\u5931\u8d25\uff0c id={}, validData={}", (Object)id, validData);
            throw new CaptchaValidException(type, "\u7f13\u5b58\u9a8c\u8bc1\u7801\u6570\u636e\u5931\u8d25");
        }
    }

    protected String getKey(String id) {
        return this.prop.getPrefix().concat(":").concat(id);
    }

    @Override
    public ImageCaptchaResourceManager getImageCaptchaResourceManager() {
        return this.getImageCaptchaTemplate().getImageResourceManager();
    }

    @Override
    public void setImageCaptchaValidator(ImageCaptchaValidator imageCaptchaValidator) {
        this.imageCaptchaValidator = imageCaptchaValidator;
    }

    @Override
    public void setImageCaptchaTemplate(ImageCaptchaGenerator imageCaptchaGenerator) {
        this.template = imageCaptchaGenerator;
    }

    @Override
    public void setCacheStore(CacheStore cacheStore) {
        this.cacheStore = cacheStore;
    }

    @Override
    public ImageCaptchaValidator getImageCaptchaValidator() {
        return this.imageCaptchaValidator;
    }

    @Override
    public ImageCaptchaGenerator getImageCaptchaTemplate() {
        return this.template;
    }

    @Override
    public CacheStore getCacheStore() {
        return this.cacheStore;
    }
}

