/*
 * Decompiled with CFR 0.152.
 */
package cloud.tianai.captcha.spring.autoconfiguration;

import cloud.tianai.captcha.spring.store.CacheStore;
import cloud.tianai.captcha.spring.store.impl.LocalCacheStore;
import cloud.tianai.captcha.spring.store.impl.RedisCacheStore;
import org.springframework.boot.autoconfigure.AutoConfigureAfter;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.data.redis.RedisAutoConfiguration;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.core.annotation.Order;
import org.springframework.data.redis.core.StringRedisTemplate;

@AutoConfigureAfter(value={RedisAutoConfiguration.class})
@Configuration(proxyBeanMethods=false)
public class CacheStoreAutoConfiguration {

    @Order(value=2)
    @Configuration(proxyBeanMethods=false)
    public static class LocalCacheStoreConfiguration {
        @Bean
        @ConditionalOnMissingBean(value={CacheStore.class})
        public CacheStore local() {
            return new LocalCacheStore();
        }
    }

    @Order(value=1)
    @Configuration(proxyBeanMethods=false)
    @ConditionalOnClass(value={StringRedisTemplate.class})
    public static class RedisCacheStoreConfiguration {
        @Bean
        @ConditionalOnBean(value={StringRedisTemplate.class})
        @ConditionalOnMissingBean(value={CacheStore.class})
        public CacheStore redis(StringRedisTemplate redisTemplate) {
            return new RedisCacheStore(redisTemplate);
        }
    }
}

