/*
 * Decompiled with CFR 0.152.
 */
package cloud.tianai.captcha.generator.impl;

import cloud.tianai.captcha.common.util.NamedThreadFactory;
import cloud.tianai.captcha.generator.ImageCaptchaGenerator;
import cloud.tianai.captcha.generator.ImageTransform;
import cloud.tianai.captcha.generator.common.model.dto.GenerateParam;
import cloud.tianai.captcha.generator.common.model.dto.ImageCaptchaInfo;
import cloud.tianai.captcha.resource.ImageCaptchaResourceManager;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CacheImageCaptchaGenerator
implements ImageCaptchaGenerator {
    private static final Logger log = LoggerFactory.getLogger(CacheImageCaptchaGenerator.class);
    protected final ScheduledExecutorService scheduledExecutor = new ScheduledThreadPoolExecutor(1, new NamedThreadFactory("slider-captcha-queue"));
    protected Map<GenerateParam, ConcurrentLinkedQueue<ImageCaptchaInfo>> queueMap = new ConcurrentHashMap<GenerateParam, ConcurrentLinkedQueue<ImageCaptchaInfo>>(8);
    protected Map<GenerateParam, AtomicInteger> posMap = new ConcurrentHashMap<GenerateParam, AtomicInteger>(8);
    protected Map<GenerateParam, Long> lastUpdateMap = new ConcurrentHashMap<GenerateParam, Long>(8);
    protected ImageCaptchaGenerator target;
    protected int size;
    protected int waitTime = 1000;
    protected int period = 5000;
    protected long expireTime = TimeUnit.DAYS.toMillis(10L);
    protected boolean requiredGetCaptcha = true;
    private boolean init = false;

    public CacheImageCaptchaGenerator(ImageCaptchaGenerator target, int size) {
        this.target = target;
        this.size = size;
    }

    public CacheImageCaptchaGenerator(ImageCaptchaGenerator target, int size, int waitTime, int period) {
        this.target = target;
        this.size = size;
        this.waitTime = waitTime;
        this.period = period;
    }

    public CacheImageCaptchaGenerator(ImageCaptchaGenerator target, int size, int waitTime, int period, Long expireTime) {
        this.target = target;
        this.size = size;
        this.waitTime = waitTime;
        this.period = period;
        this.expireTime = expireTime;
    }

    public void initSchedule() {
        this.init(this.size);
    }

    private void init(int z) {
        if (this.init) {
            return;
        }
        this.size = z;
        this.scheduledExecutor.scheduleAtFixedRate(() -> this.queueMap.forEach((k, queue) -> {
            try {
                Long lastUpdate;
                AtomicInteger pos = this.posMap.computeIfAbsent((GenerateParam)k, k1 -> new AtomicInteger(0));
                int addCount = 0;
                while (pos.get() < this.size) {
                    if (pos.get() >= this.size) {
                        return;
                    }
                    ImageCaptchaInfo slideImageInfo = this.target.generateCaptchaImage((GenerateParam)k);
                    if (slideImageInfo != null) {
                        boolean addStatus = queue.offer(slideImageInfo);
                        ++addCount;
                        if (!addStatus) continue;
                        pos.incrementAndGet();
                        continue;
                    }
                    this.sleep();
                }
                if (addCount == 0 && (lastUpdate = this.lastUpdateMap.get(k)) != null && System.currentTimeMillis() - lastUpdate > this.expireTime) {
                    this.queueMap.remove(k);
                    this.posMap.remove(k);
                    this.lastUpdateMap.remove(k);
                }
            }
            catch (Exception e) {
                log.error("\u7f13\u5b58\u961f\u5217\u626b\u63cf\u65f6\u51fa\u9519\uff0c ex", (Throwable)e);
                this.queueMap.remove(k);
                this.posMap.remove(k);
                this.lastUpdateMap.remove(k);
                this.sleep();
            }
        }), 0L, this.period, TimeUnit.MILLISECONDS);
        this.init = true;
    }

    private void sleep() {
        try {
            TimeUnit.MILLISECONDS.sleep(this.waitTime);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    @Override
    public ImageCaptchaGenerator init(boolean initDefaultResource) {
        ImageCaptchaGenerator captchaGenerator = this.target.init(initDefaultResource);
        this.init(this.size);
        return captchaGenerator;
    }

    @Override
    public ImageCaptchaInfo generateCaptchaImage(String type) {
        GenerateParam generateParam = new GenerateParam();
        generateParam.setType(type);
        return this.generateCaptchaImage(generateParam, this.requiredGetCaptcha);
    }

    public ImageCaptchaInfo generateCaptchaImage(GenerateParam generateParam, boolean requiredGetCaptcha) {
        ConcurrentLinkedQueue<ImageCaptchaInfo> queue = this.queueMap.get(generateParam);
        ImageCaptchaInfo captchaInfo = null;
        if (queue != null) {
            captchaInfo = queue.poll();
            if (captchaInfo == null) {
                log.warn("\u6ed1\u5757\u9a8c\u8bc1\u7801\u7f13\u5b58\u4e0d\u8db3, genParam:{}", (Object)generateParam);
            } else {
                AtomicInteger pos = this.posMap.get(generateParam);
                if (pos != null) {
                    pos.decrementAndGet();
                }
            }
        } else {
            this.queueMap.putIfAbsent(generateParam, new ConcurrentLinkedQueue());
            this.posMap.putIfAbsent(generateParam, new AtomicInteger(0));
        }
        if (captchaInfo == null && requiredGetCaptcha) {
            captchaInfo = this.target.generateCaptchaImage(generateParam);
        }
        if (captchaInfo != null) {
            this.lastUpdateMap.put(generateParam, System.currentTimeMillis());
        }
        return captchaInfo;
    }

    @Override
    public ImageCaptchaInfo generateCaptchaImage(String type, String targetFormatName, String matrixFormatName) {
        return this.generateCaptchaImage(GenerateParam.builder().type(type).backgroundFormatName(targetFormatName).templateFormatName(matrixFormatName).build(), true);
    }

    @Override
    public ImageCaptchaInfo generateCaptchaImage(GenerateParam param) {
        return this.generateCaptchaImage(param, true);
    }

    @Override
    public ImageCaptchaResourceManager getImageResourceManager() {
        return this.target.getImageResourceManager();
    }

    @Override
    public void setImageResourceManager(ImageCaptchaResourceManager imageCaptchaResourceManager) {
        this.target.setImageResourceManager(imageCaptchaResourceManager);
    }

    @Override
    public ImageTransform getImageTransform() {
        return this.target.getImageTransform();
    }

    @Override
    public void setImageTransform(ImageTransform imageTransform) {
        this.target.setImageTransform(imageTransform);
    }

    public boolean isRequiredGetCaptcha() {
        return this.requiredGetCaptcha;
    }

    public void setRequiredGetCaptcha(boolean requiredGetCaptcha) {
        this.requiredGetCaptcha = requiredGetCaptcha;
    }
}

