/*
 * Decompiled with CFR 0.152.
 */
package cloud.tianai.captcha.generator.impl;

import cloud.tianai.captcha.generator.AbstractImageCaptchaGenerator;
import cloud.tianai.captcha.generator.ImageTransform;
import cloud.tianai.captcha.generator.common.model.dto.CaptchaTransferData;
import cloud.tianai.captcha.generator.common.model.dto.CustomData;
import cloud.tianai.captcha.generator.common.model.dto.GenerateParam;
import cloud.tianai.captcha.generator.common.model.dto.ImageCaptchaInfo;
import cloud.tianai.captcha.generator.common.model.dto.ImageTransformData;
import cloud.tianai.captcha.generator.common.util.CaptchaImageUtils;
import cloud.tianai.captcha.resource.ImageCaptchaResourceManager;
import cloud.tianai.captcha.resource.ResourceStore;
import cloud.tianai.captcha.resource.common.model.dto.Resource;
import java.awt.image.BufferedImage;

public class StandardConcatImageCaptchaGenerator
extends AbstractImageCaptchaGenerator {
    public StandardConcatImageCaptchaGenerator(ImageCaptchaResourceManager imageCaptchaResourceManager) {
        super(imageCaptchaResourceManager);
    }

    public StandardConcatImageCaptchaGenerator(ImageCaptchaResourceManager imageCaptchaResourceManager, ImageTransform imageTransform) {
        super(imageCaptchaResourceManager);
        this.setImageTransform(imageTransform);
    }

    @Override
    protected void doInit(boolean initDefaultResource) {
        if (initDefaultResource) {
            this.initDefaultResource();
        }
    }

    public void initDefaultResource() {
        ResourceStore resourceStore = this.imageCaptchaResourceManager.getResourceStore();
        resourceStore.addResource("CONCAT", new Resource("classpath", "META-INF/cut-image/resource".concat("/1.jpg"), "default"));
    }

    @Override
    public void doGenerateCaptchaImage(CaptchaTransferData transferData) {
        GenerateParam param = transferData.getParam();
        Resource resourceImage = this.requiredRandomGetResource(param.getType(), param.getBackgroundImageTag());
        BufferedImage bgImage = this.getResourceImage(resourceImage);
        int spacingY = bgImage.getHeight() / 4;
        int randomY = this.randomInt(spacingY, bgImage.getHeight() - spacingY);
        BufferedImage[] bgImageSplit = CaptchaImageUtils.splitImage(randomY, true, bgImage);
        int spacingX = bgImage.getWidth() / 8;
        int randomX = this.randomInt(spacingX, bgImage.getWidth() - bgImage.getWidth() / 5);
        BufferedImage[] bgImageTopSplit = CaptchaImageUtils.splitImage(randomX, false, bgImageSplit[0]);
        BufferedImage sliderImage = CaptchaImageUtils.concatImage(true, bgImageTopSplit[0].getWidth() + bgImageTopSplit[1].getWidth(), bgImageTopSplit[0].getHeight(), bgImageTopSplit[1], bgImageTopSplit[0]);
        bgImage = CaptchaImageUtils.concatImage(false, bgImageSplit[1].getWidth(), sliderImage.getHeight() + bgImageSplit[1].getHeight(), sliderImage, bgImageSplit[1]);
        Data data = new Data();
        data.x = randomX;
        data.y = randomY;
        transferData.setTransferData(data);
        transferData.setBackgroundImage(bgImage);
        transferData.setResourceImage(resourceImage);
    }

    @Override
    public ImageCaptchaInfo doWrapImageCaptchaInfo(CaptchaTransferData transferData) {
        GenerateParam param = transferData.getParam();
        BufferedImage bgImage = transferData.getBackgroundImage();
        Resource resourceImage = transferData.getResourceImage();
        CustomData customData = transferData.getCustomData();
        ImageTransformData transform = this.getImageTransform().transform(param, bgImage, resourceImage, customData);
        Data data = (Data)transferData.getTransferData();
        ImageCaptchaInfo imageCaptchaInfo = ImageCaptchaInfo.of(transform.getBackgroundImageUrl(), null, resourceImage.getTag(), null, bgImage.getWidth(), bgImage.getHeight(), null, null, data.x, "CONCAT");
        customData.putViewData("randomY", data.y);
        imageCaptchaInfo.setTolerant(Float.valueOf(0.05f));
        return imageCaptchaInfo;
    }

    public static class Data {
        int x;
        int y;
    }
}

