/*
 * Decompiled with CFR 0.152.
 */
package cloud.tianai.captcha.generator.impl;

import cloud.tianai.captcha.generator.AbstractImageCaptchaGenerator;
import cloud.tianai.captcha.generator.ImageTransform;
import cloud.tianai.captcha.generator.common.model.dto.CaptchaTransferData;
import cloud.tianai.captcha.generator.common.model.dto.CustomData;
import cloud.tianai.captcha.generator.common.model.dto.GenerateParam;
import cloud.tianai.captcha.generator.common.model.dto.ImageCaptchaInfo;
import cloud.tianai.captcha.generator.common.model.dto.ImageTransformData;
import cloud.tianai.captcha.generator.common.model.dto.RotateImageCaptchaInfo;
import cloud.tianai.captcha.generator.common.util.CaptchaImageUtils;
import cloud.tianai.captcha.resource.ImageCaptchaResourceManager;
import cloud.tianai.captcha.resource.ResourceStore;
import cloud.tianai.captcha.resource.common.model.dto.Resource;
import cloud.tianai.captcha.resource.common.model.dto.ResourceMap;
import java.awt.image.BufferedImage;
import java.util.Optional;

public class StandardRotateImageCaptchaGenerator
extends AbstractImageCaptchaGenerator {
    public StandardRotateImageCaptchaGenerator(ImageCaptchaResourceManager imageCaptchaResourceManager) {
        super(imageCaptchaResourceManager);
    }

    public StandardRotateImageCaptchaGenerator(ImageCaptchaResourceManager imageCaptchaResourceManager, ImageTransform imageTransform) {
        super(imageCaptchaResourceManager);
        this.setImageTransform(imageTransform);
    }

    @Override
    protected void doInit(boolean initDefaultResource) {
        if (initDefaultResource) {
            this.initDefaultResource();
        }
    }

    public void initDefaultResource() {
        ResourceStore resourceStore = this.imageCaptchaResourceManager.getResourceStore();
        resourceStore.addResource("ROTATE", new Resource("classpath", "META-INF/cut-image/resource".concat("/1.jpg"), "default"));
        ResourceMap template1 = new ResourceMap("default", 4);
        template1.put("active.png", new Resource("classpath", "META-INF/cut-image/template".concat("/3/active.png")));
        template1.put("fixed.png", new Resource("classpath", "META-INF/cut-image/template".concat("/3/fixed.png")));
        resourceStore.addTemplate("ROTATE", template1);
        ResourceMap template2 = new ResourceMap("default_obfuscate", 4);
        template2.put("active.png", new Resource("classpath", "META-INF/cut-image/template".concat("/4/active.png")));
        template2.put("fixed.png", new Resource("classpath", "META-INF/cut-image/template".concat("/4/fixed.png")));
        template2.put("mask.png", new Resource("classpath", "META-INF/cut-image/template".concat("/4/mask.png")));
        resourceStore.addTemplate("ROTATE", template2);
    }

    @Override
    public void doGenerateCaptchaImage(CaptchaTransferData transferData) {
        GenerateParam param = transferData.getParam();
        CustomData data = new CustomData();
        ResourceMap templateResource = this.requiredRandomGetTemplate(param.getType(), param.getTemplateImageTag());
        Resource resourceImage = this.requiredRandomGetResource(param.getType(), param.getBackgroundImageTag());
        BufferedImage background = this.getResourceImage(resourceImage);
        BufferedImage fixedTemplate = this.getTemplateImage(templateResource, "fixed.png");
        BufferedImage activeTemplate = this.getTemplateImage(templateResource, "active.png");
        BufferedImage maskTemplate = fixedTemplate;
        Optional<BufferedImage> maskTemplateOptional = this.getTemplateImageOfOptional(templateResource, "mask.png");
        if (maskTemplateOptional.isPresent()) {
            maskTemplate = maskTemplateOptional.get();
        }
        int x = background.getWidth() / 2 - fixedTemplate.getWidth() / 2;
        int y = background.getHeight() / 2 - fixedTemplate.getHeight() / 2;
        BufferedImage cutImage = CaptchaImageUtils.cutImage(background, maskTemplate, x, y);
        BufferedImage rotateFixed = fixedTemplate;
        BufferedImage rotateActive = activeTemplate;
        if (param.getObfuscate().booleanValue()) {
            int randomDegree = this.randomInt(10, 350);
            rotateFixed = CaptchaImageUtils.rotateImage(fixedTemplate, randomDegree);
            randomDegree = this.randomInt(10, 350);
            rotateActive = CaptchaImageUtils.rotateImage(activeTemplate, randomDegree);
        }
        CaptchaImageUtils.overlayImage(background, rotateFixed, x, y);
        CaptchaImageUtils.overlayImage(cutImage, rotateActive, 0, 0);
        int randomX = this.randomInt(fixedTemplate.getWidth() + 10, background.getWidth() - 10);
        double degree = 360.0 - (double)randomX / ((double)background.getWidth() / 360.0);
        BufferedImage matrixTemplate = CaptchaImageUtils.createTransparentImage(background.getHeight(), background.getHeight());
        CaptchaImageUtils.centerOverlayAndRotateImage(matrixTemplate, cutImage, degree);
        RotateData rotateData = new RotateData();
        rotateData.degree = degree;
        rotateData.randomX = randomX;
        transferData.setTransferData(rotateData);
        transferData.setBackgroundImage(background);
        transferData.setTemplateImage(matrixTemplate);
        transferData.setTemplateResource(templateResource);
        transferData.setResourceImage(resourceImage);
    }

    private String getObfuscateTag(String templateTag) {
        if (templateTag == null) {
            return "obfuscate";
        }
        return templateTag + "_obfuscate";
    }

    @Override
    public ImageCaptchaInfo doWrapImageCaptchaInfo(CaptchaTransferData transferData) {
        GenerateParam param = transferData.getParam();
        BufferedImage backgroundImage = transferData.getBackgroundImage();
        BufferedImage sliderImage = transferData.getTemplateImage();
        Resource resourceImage = transferData.getResourceImage();
        ResourceMap templateResource = transferData.getTemplateResource();
        CustomData data = transferData.getCustomData();
        RotateData rotateData = (RotateData)transferData.getTransferData();
        ImageTransformData transform = this.getImageTransform().transform(param, backgroundImage, sliderImage, resourceImage, templateResource, data);
        RotateImageCaptchaInfo imageCaptchaInfo = RotateImageCaptchaInfo.of(rotateData.degree, rotateData.randomX, transform.getBackgroundImageUrl(), transform.getTemplateImageUrl(), resourceImage.getTag(), templateResource.getTag(), (Integer)backgroundImage.getWidth(), (Integer)backgroundImage.getHeight(), (Integer)sliderImage.getWidth(), sliderImage.getHeight());
        imageCaptchaInfo.setData(data);
        return imageCaptchaInfo;
    }

    public static class RotateData {
        double degree;
        int randomX;
    }
}

