/*
 * Decompiled with CFR 0.152.
 */
package cloud.tianai.captcha.generator.impl;

import cloud.tianai.captcha.common.util.CollectionUtils;
import cloud.tianai.captcha.common.util.FontUtils;
import cloud.tianai.captcha.generator.ImageTransform;
import cloud.tianai.captcha.generator.common.model.dto.CaptchaTransferData;
import cloud.tianai.captcha.generator.common.model.dto.ClickImageCheckDefinition;
import cloud.tianai.captcha.generator.common.model.dto.CustomData;
import cloud.tianai.captcha.generator.common.model.dto.GenerateParam;
import cloud.tianai.captcha.generator.common.model.dto.ImageCaptchaInfo;
import cloud.tianai.captcha.generator.common.model.dto.ImageTransformData;
import cloud.tianai.captcha.generator.common.util.CaptchaImageUtils;
import cloud.tianai.captcha.generator.impl.AbstractClickImageCaptchaGenerator;
import cloud.tianai.captcha.resource.ImageCaptchaResourceManager;
import cloud.tianai.captcha.resource.ResourceStore;
import cloud.tianai.captcha.resource.common.model.dto.Resource;
import cloud.tianai.captcha.resource.impl.provider.ClassPathResourceProvider;
import java.awt.Color;
import java.awt.Font;
import java.awt.image.BufferedImage;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.ThreadLocalRandom;
import java.util.stream.Collectors;

public class StandardWordClickImageCaptchaGenerator
extends AbstractClickImageCaptchaGenerator {
    protected List<FontWrapper> fonts = new ArrayList<FontWrapper>();
    protected Integer clickImgWidth = 100;
    protected Integer clickImgHeight = 100;
    protected int tipImageInterferenceLineNum = 2;
    protected int tipImageInterferencePointNum = 5;
    protected Integer checkClickCount = 4;
    protected Integer interferenceCount = 2;

    public StandardWordClickImageCaptchaGenerator(ImageCaptchaResourceManager imageCaptchaResourceManager) {
        super(imageCaptchaResourceManager);
    }

    public StandardWordClickImageCaptchaGenerator(ImageCaptchaResourceManager imageCaptchaResourceManager, ImageTransform imageTransform) {
        super(imageCaptchaResourceManager);
        this.setImageTransform(imageTransform);
    }

    public StandardWordClickImageCaptchaGenerator(ImageCaptchaResourceManager imageCaptchaResourceManager, ImageTransform imageTransform, List<FontWrapper> fonts) {
        super(imageCaptchaResourceManager);
        this.setImageTransform(imageTransform);
        this.fonts = fonts;
    }

    @Override
    protected List<Resource> randomGetClickImgTips(GenerateParam param) {
        int tipSize = this.interferenceCount + this.checkClickCount;
        ThreadLocalRandom random = ThreadLocalRandom.current();
        ArrayList<Resource> tipList = new ArrayList<Resource>(tipSize);
        for (int i = 0; i < tipSize; ++i) {
            String randomWord = FontUtils.getRandomChar(random);
            tipList.add(new Resource(null, randomWord));
        }
        return tipList;
    }

    @Override
    protected void doInit(boolean initDefaultResource) {
        if (CollectionUtils.isEmpty(this.fonts)) {
            Resource fontResource = new Resource(null, "META-INF/fonts/SIMSUN.TTC");
            InputStream inputStream = new ClassPathResourceProvider().doGetResourceInputStream(fontResource);
            Font font = Font.createFont(0, inputStream);
            font = font.deriveFont(1, 70.0f);
            float currentFontTopCoef = 0.14645833f * (float)font.getSize() + 0.39583334f;
            this.fonts.add(new FontWrapper(font, currentFontTopCoef));
        }
        if (initDefaultResource) {
            this.initDefaultResource();
        }
    }

    public void initDefaultResource() {
        ResourceStore resourceStore = this.imageCaptchaResourceManager.getResourceStore();
        resourceStore.addResource("WORD_IMAGE_CLICK", new Resource("classpath", "META-INF/cut-image/resource".concat("/1.jpg"), "default"));
    }

    public AbstractClickImageCaptchaGenerator.ImgWrapper genTipImage(List<ClickImageCheckDefinition> imageCheckDefinitions) {
        FontWrapper fontWrapper = this.fonts.get(this.randomInt(this.fonts.size()));
        Font font = fontWrapper.getFont();
        float currentFontTopCoef = fontWrapper.getCurrentFontTopCoef();
        String tips = imageCheckDefinitions.stream().map(c -> c.getTip().getData()).collect(Collectors.joining());
        int fontWidth = tips.length() * font.getSize();
        int width = fontWidth + 6;
        int height = font.getSize() + 6;
        float left = (float)(width - fontWidth) / 2.0f;
        float top = 3.0f + (float)font.getSize() - currentFontTopCoef;
        BufferedImage bufferedImage = CaptchaImageUtils.genSimpleImgCaptcha(tips, font, width, height, left, top, this.tipImageInterferenceLineNum, this.tipImageInterferencePointNum);
        return new AbstractClickImageCaptchaGenerator.ImgWrapper(bufferedImage, new Resource(null, tips));
    }

    @Override
    public AbstractClickImageCaptchaGenerator.ImgWrapper getClickImg(Resource tip) {
        ThreadLocalRandom random = ThreadLocalRandom.current();
        Color randomColor = CaptchaImageUtils.getRandomColor(random);
        int randomDeg = this.randomInt(0, 85);
        FontWrapper fontWrapper = this.fonts.get(this.randomInt(this.fonts.size()));
        Font font = fontWrapper.getFont();
        float currentFontTopCoef = fontWrapper.getCurrentFontTopCoef();
        BufferedImage fontImage = CaptchaImageUtils.drawWordImg(randomColor, tip.getData(), font, currentFontTopCoef, this.clickImgWidth, this.clickImgHeight, randomDeg);
        return new AbstractClickImageCaptchaGenerator.ImgWrapper(fontImage, tip);
    }

    @Override
    protected List<ClickImageCheckDefinition> filterAndSortClickImageCheckDefinition(List<ClickImageCheckDefinition> allCheckDefinitionList) {
        Collections.shuffle(allCheckDefinitionList);
        ArrayList<ClickImageCheckDefinition> checkClickImageCheckDefinitionList = new ArrayList<ClickImageCheckDefinition>(this.checkClickCount);
        for (int i = 0; i < this.checkClickCount; ++i) {
            ClickImageCheckDefinition clickImageCheckDefinition = allCheckDefinitionList.get(i);
            checkClickImageCheckDefinitionList.add(clickImageCheckDefinition);
        }
        return checkClickImageCheckDefinitionList;
    }

    @Override
    public ImageCaptchaInfo doWrapImageCaptchaInfo(CaptchaTransferData transferData) {
        List checkClickImageCheckDefinitionList = (List)transferData.getTransferData();
        BufferedImage bgImage = transferData.getBackgroundImage();
        GenerateParam param = transferData.getParam();
        Resource resourceImage = transferData.getResourceImage();
        CustomData data = transferData.getCustomData();
        BufferedImage tipImage = this.genTipImage(checkClickImageCheckDefinitionList).getImage();
        ImageTransformData transform = this.getImageTransform().transform(param, bgImage, tipImage, resourceImage, checkClickImageCheckDefinitionList, data);
        ImageCaptchaInfo clickImageCaptchaInfo = new ImageCaptchaInfo();
        clickImageCaptchaInfo.setBackgroundImage(transform.getBackgroundImageUrl());
        clickImageCaptchaInfo.setBackgroundImageTag(resourceImage.getTag());
        clickImageCaptchaInfo.setTemplateImage(transform.getTemplateImageUrl());
        clickImageCaptchaInfo.setBackgroundImageWidth(bgImage.getWidth());
        clickImageCaptchaInfo.setBackgroundImageHeight(bgImage.getHeight());
        clickImageCaptchaInfo.setTemplateImageWidth(tipImage.getWidth());
        clickImageCaptchaInfo.setTemplateImageHeight(tipImage.getHeight());
        clickImageCaptchaInfo.setRandomX(null);
        clickImageCaptchaInfo.setTolerant(null);
        clickImageCaptchaInfo.setType("WORD_IMAGE_CLICK");
        data.setExpand(checkClickImageCheckDefinitionList);
        return clickImageCaptchaInfo;
    }

    public List<FontWrapper> getFonts() {
        return this.fonts;
    }

    public void setFonts(List<FontWrapper> fonts) {
        this.fonts = fonts;
    }

    public Integer getClickImgWidth() {
        return this.clickImgWidth;
    }

    public void setClickImgWidth(Integer clickImgWidth) {
        this.clickImgWidth = clickImgWidth;
    }

    public Integer getClickImgHeight() {
        return this.clickImgHeight;
    }

    public void setClickImgHeight(Integer clickImgHeight) {
        this.clickImgHeight = clickImgHeight;
    }

    public int getTipImageInterferenceLineNum() {
        return this.tipImageInterferenceLineNum;
    }

    public void setTipImageInterferenceLineNum(int tipImageInterferenceLineNum) {
        this.tipImageInterferenceLineNum = tipImageInterferenceLineNum;
    }

    public int getTipImageInterferencePointNum() {
        return this.tipImageInterferencePointNum;
    }

    public void setTipImageInterferencePointNum(int tipImageInterferencePointNum) {
        this.tipImageInterferencePointNum = tipImageInterferencePointNum;
    }

    public Integer getCheckClickCount() {
        return this.checkClickCount;
    }

    public void setCheckClickCount(Integer checkClickCount) {
        this.checkClickCount = checkClickCount;
    }

    public Integer getInterferenceCount() {
        return this.interferenceCount;
    }

    public void setInterferenceCount(Integer interferenceCount) {
        this.interferenceCount = interferenceCount;
    }

    public static class FontWrapper {
        private Font font;
        private float currentFontTopCoef;

        public Font getFont() {
            return this.font;
        }

        public float getCurrentFontTopCoef() {
            return this.currentFontTopCoef;
        }

        public void setFont(Font font) {
            this.font = font;
        }

        public void setCurrentFontTopCoef(float currentFontTopCoef) {
            this.currentFontTopCoef = currentFontTopCoef;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof FontWrapper)) {
                return false;
            }
            FontWrapper other = (FontWrapper)o;
            if (!other.canEqual(this)) {
                return false;
            }
            Font this$font = this.getFont();
            Font other$font = other.getFont();
            if (this$font == null ? other$font != null : !((Object)this$font).equals(other$font)) {
                return false;
            }
            return Float.compare(this.getCurrentFontTopCoef(), other.getCurrentFontTopCoef()) == 0;
        }

        protected boolean canEqual(Object other) {
            return other instanceof FontWrapper;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            Font $font = this.getFont();
            result = result * 59 + ($font == null ? 43 : ((Object)$font).hashCode());
            result = result * 59 + Float.floatToIntBits(this.getCurrentFontTopCoef());
            return result;
        }

        public String toString() {
            return "StandardWordClickImageCaptchaGenerator.FontWrapper(font=" + this.getFont() + ", currentFontTopCoef=" + this.getCurrentFontTopCoef() + ")";
        }

        public FontWrapper() {
        }

        public FontWrapper(Font font, float currentFontTopCoef) {
            this.font = font;
            this.currentFontTopCoef = currentFontTopCoef;
        }
    }
}

