/*
 * Decompiled with CFR 0.152.
 */
package cloud.tianai.captcha.resource.impl;

import cloud.tianai.captcha.common.util.CollectionUtils;
import cloud.tianai.captcha.common.util.ObjectUtils;
import cloud.tianai.captcha.resource.ResourceStore;
import cloud.tianai.captcha.resource.common.model.dto.Resource;
import cloud.tianai.captcha.resource.common.model.dto.ResourceMap;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ThreadLocalRandom;

public class DefaultResourceStore
implements ResourceStore {
    private static final String TYPE_TAG_SPLIT_FLAG = "|";
    private Map<String, List<ResourceMap>> templateResourceMap = new HashMap<String, List<ResourceMap>>(2);
    private Map<String, List<Resource>> resourceMap = new HashMap<String, List<Resource>>(2);
    private Map<String, List<ResourceMap>> templateResourceTagMap = new HashMap<String, List<ResourceMap>>(2);
    private Map<String, List<Resource>> resourceTagMap = new HashMap<String, List<Resource>>(2);

    @Override
    public void addResource(String type, Resource resource) {
        this.resourceMap.computeIfAbsent(type, k -> new ArrayList(20)).add(resource);
        if (!ObjectUtils.isEmpty(resource.getTag())) {
            this.resourceTagMap.computeIfAbsent(this.mergeTypeAndTag(type, resource.getTag()), k -> new ArrayList(20)).add(resource);
        }
    }

    @Override
    public void addTemplate(String type, ResourceMap template) {
        this.templateResourceMap.computeIfAbsent(type, k -> new ArrayList(2)).add(template);
        if (!ObjectUtils.isEmpty(template.getTag())) {
            this.templateResourceTagMap.computeIfAbsent(this.mergeTypeAndTag(type, template.getTag()), k -> new ArrayList(2)).add(template);
        }
    }

    @Override
    public Resource randomGetResourceByTypeAndTag(String type, String tag) {
        List<Resource> resources = ObjectUtils.isEmpty(tag) ? this.resourceMap.get(type) : this.resourceTagMap.get(this.mergeTypeAndTag(type, tag));
        if (CollectionUtils.isEmpty(resources)) {
            throw new IllegalStateException("\u968f\u673a\u83b7\u53d6\u8d44\u6e90\u9519\u8bef\uff0cstore\u4e2d\u8d44\u6e90\u4e3a\u7a7a, type:" + type);
        }
        if (resources.size() == 1) {
            return resources.get(0);
        }
        int randomIndex = ThreadLocalRandom.current().nextInt(resources.size());
        return resources.get(randomIndex);
    }

    @Override
    public ResourceMap randomGetTemplateByTypeAndTag(String type, String tag) {
        List<ResourceMap> templateList = ObjectUtils.isEmpty(tag) ? this.templateResourceMap.get(type) : this.templateResourceTagMap.get(this.mergeTypeAndTag(type, tag));
        if (CollectionUtils.isEmpty(templateList)) {
            throw new IllegalStateException("\u968f\u673a\u83b7\u53d6\u6a21\u677f\u9519\u8bef\uff0cstore\u4e2d\u6a21\u677f\u4e3a\u7a7a, type:" + type);
        }
        if (templateList.size() == 1) {
            return templateList.get(0);
        }
        int randomIndex = ThreadLocalRandom.current().nextInt(templateList.size());
        return templateList.get(randomIndex);
    }

    public String mergeTypeAndTag(String type, String tag) {
        return type + TYPE_TAG_SPLIT_FLAG + tag;
    }

    public void clearResources(String type) {
        this.resourceMap.remove(type);
    }

    public void clearAllResources() {
        this.resourceMap.clear();
    }

    public Map<String, List<Resource>> listAllResources() {
        return this.resourceMap;
    }

    public List<Resource> listResourcesByType(String type) {
        return this.resourceMap.getOrDefault(type, Collections.emptyList());
    }

    public int getAllResourceCount() {
        int count = 0;
        for (List<Resource> value : this.resourceMap.values()) {
            count += value.size();
        }
        return count;
    }

    public int getResourceCount(String type) {
        return this.resourceMap.getOrDefault(type, Collections.emptyList()).size();
    }

    public void clearAllTemplates() {
        this.templateResourceMap.clear();
    }

    public void clearTemplates(String type) {
        this.templateResourceMap.remove(type);
    }

    public List<ResourceMap> listTemplatesByType(String type) {
        return this.templateResourceMap.getOrDefault(type, Collections.emptyList());
    }

    public Map<String, List<ResourceMap>> listAllTemplates() {
        return this.templateResourceMap;
    }
}

