/*
 * Decompiled with CFR 0.152.
 */
package cloud.tianai.captcha.validator.impl;

import cloud.tianai.captcha.common.response.ApiResponse;
import cloud.tianai.captcha.common.response.CodeDefinition;
import cloud.tianai.captcha.common.util.CaptchaUtils;
import cloud.tianai.captcha.common.util.CollectionUtils;
import cloud.tianai.captcha.common.util.ObjectUtils;
import cloud.tianai.captcha.validator.common.model.dto.ImageCaptchaTrack;
import cloud.tianai.captcha.validator.impl.SimpleImageCaptchaValidator;
import java.util.List;
import java.util.Map;

public class BasicCaptchaTrackValidator
extends SimpleImageCaptchaValidator {
    public static final CodeDefinition DEFINITION = new CodeDefinition(50001, "basic check fail");

    public BasicCaptchaTrackValidator() {
    }

    public BasicCaptchaTrackValidator(float defaultTolerant) {
        super(defaultTolerant);
    }

    @Override
    public ApiResponse<?> beforeValid(ImageCaptchaTrack imageCaptchaTrack, Map<String, Object> sliderCaptchaValidData, Float tolerant, String type) {
        this.checkParam(imageCaptchaTrack);
        return ApiResponse.SUCCESS;
    }

    @Override
    public ApiResponse<?> afterValid(ImageCaptchaTrack imageCaptchaTrack, Map<String, Object> sliderCaptchaValidData, Float tolerant, String type) {
        boolean check;
        if (!CaptchaUtils.isSliderCaptcha(type)) {
            return ApiResponse.ofSuccess();
        }
        long startSlidingTime = imageCaptchaTrack.getStartSlidingTime().getTime();
        long endSlidingTime = imageCaptchaTrack.getEndSlidingTime().getTime();
        Integer bgImageWidth = imageCaptchaTrack.getBgImageWidth();
        List<ImageCaptchaTrack.Track> trackList = imageCaptchaTrack.getTrackList();
        if (startSlidingTime + 300L > endSlidingTime) {
            return ApiResponse.ofMessage(DEFINITION);
        }
        if (trackList.size() < 10 || trackList.size() > bgImageWidth * 5) {
            return ApiResponse.ofMessage(DEFINITION);
        }
        ImageCaptchaTrack.Track firstTrack = trackList.get(0);
        if (firstTrack.getX() > 10 || firstTrack.getX() < -10 || firstTrack.getY() > 10 || firstTrack.getY() < -10) {
            return ApiResponse.ofMessage(DEFINITION);
        }
        int check4 = 0;
        int check7 = 0;
        for (int i = 1; i < trackList.size(); ++i) {
            ImageCaptchaTrack.Track track = trackList.get(i);
            float x = track.getX().intValue();
            float y = track.getY().intValue();
            if ((float)firstTrack.getY().intValue() == y) {
                ++check4;
            }
            if (x >= (float)bgImageWidth.intValue()) {
                ++check7;
            }
            ImageCaptchaTrack.Track preTrack = trackList.get(i - 1);
            if (track.getX() - preTrack.getX() <= 50 && track.getY() - preTrack.getY() <= 50) continue;
            return ApiResponse.ofMessage(DEFINITION);
        }
        if (check4 == trackList.size() || check7 > 200) {
            return ApiResponse.ofMessage(DEFINITION);
        }
        int splitPos = (int)((double)trackList.size() * 0.7);
        ImageCaptchaTrack.Track splitPostTrack = trackList.get(splitPos - 1);
        float posTime = splitPostTrack.getT().intValue();
        float startAvgPosTime = posTime / (float)splitPos;
        ImageCaptchaTrack.Track lastTrack = trackList.get(trackList.size() - 1);
        double endAvgPosTime = (float)lastTrack.getT().intValue() / (float)(trackList.size() - splitPos);
        boolean bl = check = endAvgPosTime > (double)startAvgPosTime;
        if (check) {
            return ApiResponse.ofSuccess();
        }
        return ApiResponse.ofMessage(DEFINITION);
    }

    public void checkParam(ImageCaptchaTrack imageCaptchaTrack) {
        if (ObjectUtils.isEmpty(imageCaptchaTrack.getBgImageWidth())) {
            throw new IllegalArgumentException("bgImageWidth must not be null");
        }
        if (ObjectUtils.isEmpty(imageCaptchaTrack.getBgImageHeight())) {
            throw new IllegalArgumentException("bgImageHeight must not be null");
        }
        if (ObjectUtils.isEmpty(imageCaptchaTrack.getStartSlidingTime())) {
            throw new IllegalArgumentException("startSlidingTime must not be null");
        }
        if (ObjectUtils.isEmpty(imageCaptchaTrack.getEndSlidingTime())) {
            throw new IllegalArgumentException("endSlidingTime must not be null");
        }
        if (CollectionUtils.isEmpty(imageCaptchaTrack.getTrackList())) {
            throw new IllegalArgumentException("trackList must not be null");
        }
        for (ImageCaptchaTrack.Track track : imageCaptchaTrack.getTrackList()) {
            Integer x = track.getX();
            Integer y = track.getY();
            Integer t = track.getT();
            String type = track.getType();
            if (x != null && y != null && t != null && !ObjectUtils.isEmpty(type)) continue;
            throw new IllegalArgumentException("track[x,y,t,type] must not be null");
        }
    }
}

