/*
 * Decompiled with CFR 0.152.
 */
package cn.afterturn.easypoi.excel.entity;

import cn.afterturn.easypoi.excel.entity.ExcelBaseParams;
import cn.afterturn.easypoi.excel.entity.enmus.ExcelType;
import cn.afterturn.easypoi.excel.export.styler.ExcelExportStylerDefaultImpl;
import java.util.Arrays;
import org.apache.poi.hssf.util.HSSFColor;

public class ExportParams
extends ExcelBaseParams {
    private String title;
    private short titleHeight = (short)10;
    private String secondTitle;
    private short secondTitleHeight = (short)8;
    private String sheetName;
    private String[] exclusions;
    private boolean addIndex;
    private String indexName = "\u5e8f\u53f7";
    private int freezeCol;
    private short color = HSSFColor.HSSFColorPredefined.WHITE.getIndex();
    private short headerColor = HSSFColor.HSSFColorPredefined.SKY_BLUE.getIndex();
    private ExcelType type = ExcelType.HSSF;
    private Class<?> style = ExcelExportStylerDefaultImpl.class;
    private double headerHeight = 9.0;
    private boolean isCreateHeadRows = true;
    private boolean isDynamicData = false;
    private boolean isAppendGraph = true;
    private boolean isFixedTitle = true;
    private int maxNum = 0;
    private short height = 0;
    private boolean readonly = false;

    public ExportParams() {
    }

    public ExportParams(String title, String sheetName) {
        this.title = title;
        this.sheetName = sheetName;
    }

    public ExportParams(String title, String sheetName, ExcelType type) {
        this.title = title;
        this.sheetName = sheetName;
        this.type = type;
    }

    public ExportParams(String title, String secondTitle, String sheetName) {
        this.title = title;
        this.secondTitle = secondTitle;
        this.sheetName = sheetName;
    }

    public short getSecondTitleHeight() {
        return (short)(this.secondTitleHeight * 50);
    }

    public short getTitleHeight() {
        return (short)(this.titleHeight * 50);
    }

    public short getHeight() {
        return this.height == -1 ? (short)-1 : (short)(this.height * 50);
    }

    public short getHeaderHeight() {
        return (short)(this.titleHeight * 50);
    }

    public String getTitle() {
        return this.title;
    }

    public String getSecondTitle() {
        return this.secondTitle;
    }

    public String getSheetName() {
        return this.sheetName;
    }

    public String[] getExclusions() {
        return this.exclusions;
    }

    public boolean isAddIndex() {
        return this.addIndex;
    }

    public String getIndexName() {
        return this.indexName;
    }

    public int getFreezeCol() {
        return this.freezeCol;
    }

    public short getColor() {
        return this.color;
    }

    public short getHeaderColor() {
        return this.headerColor;
    }

    public ExcelType getType() {
        return this.type;
    }

    public Class<?> getStyle() {
        return this.style;
    }

    public boolean isCreateHeadRows() {
        return this.isCreateHeadRows;
    }

    public boolean isDynamicData() {
        return this.isDynamicData;
    }

    public boolean isAppendGraph() {
        return this.isAppendGraph;
    }

    public boolean isFixedTitle() {
        return this.isFixedTitle;
    }

    public int getMaxNum() {
        return this.maxNum;
    }

    public boolean isReadonly() {
        return this.readonly;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public void setTitleHeight(short titleHeight) {
        this.titleHeight = titleHeight;
    }

    public void setSecondTitle(String secondTitle) {
        this.secondTitle = secondTitle;
    }

    public void setSecondTitleHeight(short secondTitleHeight) {
        this.secondTitleHeight = secondTitleHeight;
    }

    public void setSheetName(String sheetName) {
        this.sheetName = sheetName;
    }

    public void setExclusions(String[] exclusions) {
        this.exclusions = exclusions;
    }

    public void setAddIndex(boolean addIndex) {
        this.addIndex = addIndex;
    }

    public void setIndexName(String indexName) {
        this.indexName = indexName;
    }

    public void setFreezeCol(int freezeCol) {
        this.freezeCol = freezeCol;
    }

    public void setColor(short color) {
        this.color = color;
    }

    public void setHeaderColor(short headerColor) {
        this.headerColor = headerColor;
    }

    public void setType(ExcelType type) {
        this.type = type;
    }

    public void setStyle(Class<?> style) {
        this.style = style;
    }

    public void setHeaderHeight(double headerHeight) {
        this.headerHeight = headerHeight;
    }

    public void setCreateHeadRows(boolean isCreateHeadRows) {
        this.isCreateHeadRows = isCreateHeadRows;
    }

    public void setDynamicData(boolean isDynamicData) {
        this.isDynamicData = isDynamicData;
    }

    public void setAppendGraph(boolean isAppendGraph) {
        this.isAppendGraph = isAppendGraph;
    }

    public void setFixedTitle(boolean isFixedTitle) {
        this.isFixedTitle = isFixedTitle;
    }

    public void setMaxNum(int maxNum) {
        this.maxNum = maxNum;
    }

    public void setHeight(short height) {
        this.height = height;
    }

    public void setReadonly(boolean readonly) {
        this.readonly = readonly;
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ExportParams)) {
            return false;
        }
        ExportParams other = (ExportParams)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$title = this.getTitle();
        String other$title = other.getTitle();
        if (this$title == null ? other$title != null : !this$title.equals(other$title)) {
            return false;
        }
        if (this.getTitleHeight() != other.getTitleHeight()) {
            return false;
        }
        String this$secondTitle = this.getSecondTitle();
        String other$secondTitle = other.getSecondTitle();
        if (this$secondTitle == null ? other$secondTitle != null : !this$secondTitle.equals(other$secondTitle)) {
            return false;
        }
        if (this.getSecondTitleHeight() != other.getSecondTitleHeight()) {
            return false;
        }
        String this$sheetName = this.getSheetName();
        String other$sheetName = other.getSheetName();
        if (this$sheetName == null ? other$sheetName != null : !this$sheetName.equals(other$sheetName)) {
            return false;
        }
        if (!Arrays.deepEquals(this.getExclusions(), other.getExclusions())) {
            return false;
        }
        if (this.isAddIndex() != other.isAddIndex()) {
            return false;
        }
        String this$indexName = this.getIndexName();
        String other$indexName = other.getIndexName();
        if (this$indexName == null ? other$indexName != null : !this$indexName.equals(other$indexName)) {
            return false;
        }
        if (this.getFreezeCol() != other.getFreezeCol()) {
            return false;
        }
        if (this.getColor() != other.getColor()) {
            return false;
        }
        if (this.getHeaderColor() != other.getHeaderColor()) {
            return false;
        }
        ExcelType this$type = this.getType();
        ExcelType other$type = other.getType();
        if (this$type == null ? other$type != null : !((Object)((Object)this$type)).equals((Object)other$type)) {
            return false;
        }
        Class<?> this$style = this.getStyle();
        Class<?> other$style = other.getStyle();
        if (this$style == null ? other$style != null : !this$style.equals(other$style)) {
            return false;
        }
        if (this.getHeaderHeight() != other.getHeaderHeight()) {
            return false;
        }
        if (this.isCreateHeadRows() != other.isCreateHeadRows()) {
            return false;
        }
        if (this.isDynamicData() != other.isDynamicData()) {
            return false;
        }
        if (this.isAppendGraph() != other.isAppendGraph()) {
            return false;
        }
        if (this.isFixedTitle() != other.isFixedTitle()) {
            return false;
        }
        if (this.getMaxNum() != other.getMaxNum()) {
            return false;
        }
        if (this.getHeight() != other.getHeight()) {
            return false;
        }
        return this.isReadonly() == other.isReadonly();
    }

    @Override
    protected boolean canEqual(Object other) {
        return other instanceof ExportParams;
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $title = this.getTitle();
        result = result * 59 + ($title == null ? 43 : $title.hashCode());
        result = result * 59 + this.getTitleHeight();
        String $secondTitle = this.getSecondTitle();
        result = result * 59 + ($secondTitle == null ? 43 : $secondTitle.hashCode());
        result = result * 59 + this.getSecondTitleHeight();
        String $sheetName = this.getSheetName();
        result = result * 59 + ($sheetName == null ? 43 : $sheetName.hashCode());
        result = result * 59 + Arrays.deepHashCode(this.getExclusions());
        result = result * 59 + (this.isAddIndex() ? 79 : 97);
        String $indexName = this.getIndexName();
        result = result * 59 + ($indexName == null ? 43 : $indexName.hashCode());
        result = result * 59 + this.getFreezeCol();
        result = result * 59 + this.getColor();
        result = result * 59 + this.getHeaderColor();
        ExcelType $type = this.getType();
        result = result * 59 + ($type == null ? 43 : ((Object)((Object)$type)).hashCode());
        Class<?> $style = this.getStyle();
        result = result * 59 + ($style == null ? 43 : $style.hashCode());
        result = result * 59 + this.getHeaderHeight();
        result = result * 59 + (this.isCreateHeadRows() ? 79 : 97);
        result = result * 59 + (this.isDynamicData() ? 79 : 97);
        result = result * 59 + (this.isAppendGraph() ? 79 : 97);
        result = result * 59 + (this.isFixedTitle() ? 79 : 97);
        result = result * 59 + this.getMaxNum();
        result = result * 59 + this.getHeight();
        result = result * 59 + (this.isReadonly() ? 79 : 97);
        return result;
    }

    @Override
    public String toString() {
        return "ExportParams(title=" + this.getTitle() + ", titleHeight=" + this.getTitleHeight() + ", secondTitle=" + this.getSecondTitle() + ", secondTitleHeight=" + this.getSecondTitleHeight() + ", sheetName=" + this.getSheetName() + ", exclusions=" + Arrays.deepToString(this.getExclusions()) + ", addIndex=" + this.isAddIndex() + ", indexName=" + this.getIndexName() + ", freezeCol=" + this.getFreezeCol() + ", color=" + this.getColor() + ", headerColor=" + this.getHeaderColor() + ", type=" + (Object)((Object)this.getType()) + ", style=" + this.getStyle() + ", headerHeight=" + this.getHeaderHeight() + ", isCreateHeadRows=" + this.isCreateHeadRows() + ", isDynamicData=" + this.isDynamicData() + ", isAppendGraph=" + this.isAppendGraph() + ", isFixedTitle=" + this.isFixedTitle() + ", maxNum=" + this.getMaxNum() + ", height=" + this.getHeight() + ", readonly=" + this.isReadonly() + ")";
    }
}

