/*
 * Decompiled with CFR 0.152.
 */
package com.agentsflex.llm.tencent;

import com.agentsflex.core.document.Document;
import com.agentsflex.core.llm.BaseLlm;
import com.agentsflex.core.llm.ChatOptions;
import com.agentsflex.core.llm.Llm;
import com.agentsflex.core.llm.LlmConfig;
import com.agentsflex.core.llm.StreamResponseListener;
import com.agentsflex.core.llm.client.BaseLlmClientListener;
import com.agentsflex.core.llm.client.HttpClient;
import com.agentsflex.core.llm.client.LlmClient;
import com.agentsflex.core.llm.client.LlmClientListener;
import com.agentsflex.core.llm.client.impl.SseClient;
import com.agentsflex.core.llm.embedding.EmbeddingOptions;
import com.agentsflex.core.llm.response.AiMessageResponse;
import com.agentsflex.core.message.AiMessage;
import com.agentsflex.core.parser.AiMessageParser;
import com.agentsflex.core.prompt.Prompt;
import com.agentsflex.core.store.VectorData;
import com.agentsflex.core.util.LogUtil;
import com.agentsflex.core.util.Maps;
import com.agentsflex.core.util.StringUtil;
import com.agentsflex.llm.tencent.TencentLlmConfig;
import com.agentsflex.llm.tencent.TencentLlmUtil;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.JSONPath;
import java.util.Map;

public class TencentlmLlm
extends BaseLlm<TencentLlmConfig> {
    private HttpClient httpClient = new HttpClient();
    public AiMessageParser aiMessageParser = TencentLlmUtil.getAiMessageParser(false);
    public AiMessageParser aiStreamMessageParser = TencentLlmUtil.getAiMessageParser(true);

    public TencentlmLlm(TencentLlmConfig config) {
        super((LlmConfig)config);
    }

    public VectorData embed(Document document, EmbeddingOptions options) {
        String payload = Maps.of((String)"Input", (Object)document.getContent()).toJSON();
        Map<String, String> headers = TencentLlmUtil.createAuthorizationToken((TencentLlmConfig)this.config, "GetEmbedding", payload);
        String response = this.httpClient.post(((TencentLlmConfig)this.config).getEndpoint(), headers, payload);
        if (((TencentLlmConfig)this.config).isDebug()) {
            LogUtil.println((String)(">>>>receive payload:" + response));
        }
        if (StringUtil.noText((String)response)) {
            return null;
        }
        VectorData vectorData = new VectorData();
        vectorData.setVector((double[])JSONPath.read((String)response, (String)"$.Response.Data[0].Embedding", double[].class));
        return vectorData;
    }

    public AiMessageResponse chat(Prompt prompt, ChatOptions options) {
        String payload = TencentLlmUtil.promptToPayload(prompt, (TencentLlmConfig)this.config, false, options);
        Map<String, String> headers = TencentLlmUtil.createAuthorizationToken((TencentLlmConfig)this.config, "ChatCompletions", payload);
        String response = this.httpClient.post(((TencentLlmConfig)this.config).getEndpoint(), headers, payload);
        if (((TencentLlmConfig)this.config).isDebug()) {
            LogUtil.println((String)(">>>>receive payload:" + response));
        }
        if (StringUtil.noText((String)response)) {
            return AiMessageResponse.error((Prompt)prompt, (String)response, (String)"no content for response.");
        }
        JSONObject jsonObject = JSON.parseObject((String)response);
        JSONObject error = jsonObject.getJSONObject("Response").getJSONObject("Error");
        AiMessageResponse messageResponse = new AiMessageResponse(prompt, response, (AiMessage)this.aiMessageParser.parse((Object)jsonObject));
        if (error != null && !error.isEmpty()) {
            messageResponse.setError(true);
            messageResponse.setErrorMessage(error.getString("Message"));
            messageResponse.setErrorType(error.getString("type"));
            messageResponse.setErrorCode(error.getString("Code"));
        }
        return messageResponse;
    }

    public void chatStream(Prompt prompt, StreamResponseListener listener, ChatOptions options) {
        SseClient llmClient = new SseClient();
        String payload = TencentLlmUtil.promptToPayload(prompt, (TencentLlmConfig)this.config, true, options);
        Map<String, String> headers = TencentLlmUtil.createAuthorizationToken((TencentLlmConfig)this.config, "ChatCompletions", payload);
        BaseLlmClientListener clientListener = new BaseLlmClientListener((Llm)this, (LlmClient)llmClient, listener, prompt, this.aiStreamMessageParser);
        llmClient.start(((TencentLlmConfig)this.config).getEndpoint(), headers, payload, (LlmClientListener)clientListener, this.config);
    }
}

