/*
 * Decompiled with CFR 0.152.
 */
package com.ql.util.express;

import com.ql.util.express.ExportItem;
import com.ql.util.express.ExpressRunner;
import com.ql.util.express.InstructionSet;
import com.ql.util.express.instruction.FunctionInstructionSet;
import java.util.TreeMap;
import java.util.concurrent.ConcurrentHashMap;

public class ExpressLoader {
    private ConcurrentHashMap<String, InstructionSet> expressInstructionSetCache = new ConcurrentHashMap();
    ExpressRunner creator;

    public ExpressLoader(ExpressRunner aCreator) {
        this.creator = aCreator;
    }

    public InstructionSet loadExpress(String expressName) throws Exception {
        return this.parseInstructionSet(expressName, this.creator.getExpressResourceLoader().loadExpress(expressName));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addInstructionSet(String expressName, InstructionSet set) throws Exception {
        ConcurrentHashMap<String, InstructionSet> concurrentHashMap = this.expressInstructionSetCache;
        synchronized (concurrentHashMap) {
            if (this.expressInstructionSetCache.containsKey(expressName)) {
                throw new Exception("\u8868\u8fbe\u5f0f\u5b9a\u4e49\u91cd\u590d\uff1a" + expressName);
            }
            this.expressInstructionSetCache.put(expressName, set);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public InstructionSet parseInstructionSet(String expressName, String expressString) throws Exception {
        InstructionSet parseResult = null;
        if (this.expressInstructionSetCache.containsKey(expressName)) {
            throw new Exception("\u8868\u8fbe\u5f0f\u5b9a\u4e49\u91cd\u590d\uff1a" + expressName);
        }
        ConcurrentHashMap<String, InstructionSet> concurrentHashMap = this.expressInstructionSetCache;
        synchronized (concurrentHashMap) {
            parseResult = this.creator.parseInstructionSet(expressString);
            parseResult.setName(expressName);
            parseResult.setGlobeName(expressName);
            for (FunctionInstructionSet item : parseResult.getFunctionInstructionSets()) {
                this.addInstructionSet(item.name, item.instructionSet);
                item.instructionSet.setName(item.name);
                item.instructionSet.setGlobeName(expressName + "." + item.name);
            }
            if (parseResult.hasMain()) {
                this.addInstructionSet(expressName, parseResult);
            }
        }
        return parseResult;
    }

    public void clear() {
        this.expressInstructionSetCache.clear();
    }

    public InstructionSet getInstructionSet(String expressName) {
        return this.expressInstructionSetCache.get(expressName);
    }

    public ExportItem[] getExportInfo() {
        TreeMap<String, ExportItem> result = new TreeMap<String, ExportItem>();
        for (InstructionSet item : this.expressInstructionSetCache.values()) {
            for (ExportItem var : item.getExportDef()) {
                var.setGlobeName(item.getGlobeName() + "." + var.name);
                result.put(var.getGlobeName(), var);
            }
            result.put(item.getGlobeName(), new ExportItem(item.getGlobeName(), item.getName(), item.getType(), item.toString()));
        }
        return result.values().toArray(new ExportItem[0]);
    }
}

