/*
 * Decompiled with CFR 0.152.
 */
package com.ql.util.express;

import com.ql.util.express.ArraySwap;
import com.ql.util.express.ExpressUtil;
import com.ql.util.express.InstructionSetContext;
import com.ql.util.express.OperateData;
import com.ql.util.express.OperatorOfNumber;
import com.ql.util.express.instruction.OperateDataCacheManager;
import com.ql.util.express.instruction.op.OperatorBase;
import java.util.Date;

public abstract class Operator
extends OperatorBase {
    @Override
    public OperateData executeInner(InstructionSetContext context, ArraySwap list) throws Exception {
        Object[] parameters = new Object[list.length];
        for (int i = 0; i < list.length; ++i) {
            parameters[i] = list.get(i).getObject(context);
        }
        Object result = this.executeInner(parameters);
        if (result != null && result.getClass().equals(OperateData.class)) {
            throw new Exception("\u64cd\u4f5c\u7b26\u53f7\u5b9a\u4e49\u7684\u8fd4\u56de\u7c7b\u578b\u9519\u8bef\uff1a" + this.getAliasName());
        }
        if (result == null) {
            return OperateDataCacheManager.fetchOperateData(null, null);
        }
        return OperateDataCacheManager.fetchOperateData(result, ExpressUtil.getSimpleDataType(result.getClass()));
    }

    public abstract Object executeInner(Object[] var1) throws Exception;

    public static int compareData(Object op1, Object op2) throws Exception {
        int compareResult = -1;
        if (op1 instanceof String) {
            compareResult = ((String)op1).compareTo(op2.toString());
        } else if (op2 instanceof String) {
            compareResult = op1.toString().compareTo((String)op2);
        } else if (op1 instanceof Number && op2 instanceof Number) {
            compareResult = OperatorOfNumber.compareNumber((Number)op1, (Number)op2);
        } else if (op1 instanceof Boolean && op2 instanceof Boolean) {
            compareResult = ((Boolean)op1).booleanValue() == ((Boolean)op2).booleanValue() ? 0 : -1;
        } else if (op1 instanceof Date && op2 instanceof Date) {
            compareResult = ((Date)op1).compareTo((Date)op2);
        } else {
            throw new Exception(op1 + "\u548c" + op2 + "\u4e0d\u80fd\u6267\u884ccompare \u64cd\u4f5c");
        }
        return compareResult;
    }
}

