/*
 * Decompiled with CFR 0.152.
 */
package com.ql.util.express.instruction.detail;

import com.ql.util.express.RunEnvironment;
import com.ql.util.express.instruction.detail.Instruction;
import java.util.List;

public class InstructionGoToWithNotNull
extends Instruction {
    private static final long serialVersionUID = -2314675800146495935L;
    int offset;
    boolean isPopStackData;

    public InstructionGoToWithNotNull(int aOffset, boolean aIsPopStackData) {
        this.offset = aOffset;
        this.isPopStackData = aIsPopStackData;
    }

    @Override
    public void execute(RunEnvironment environment, List<String> errorList) throws Exception {
        Object o = null;
        o = !this.isPopStackData ? environment.peek().getObject(environment.getContext()) : environment.pop().getObject(environment.getContext());
        if (o != null) {
            if (environment.isTrace() && log.isDebugEnabled()) {
                log.debug((Object)("goto +" + this.offset));
            }
            environment.gotoWithOffset(this.offset);
        } else {
            if (environment.isTrace() && log.isDebugEnabled()) {
                log.debug((Object)"programPoint ++ ");
            }
            environment.programPointAddOne();
        }
    }

    public String toString() {
        String result = "GoToIf[NOTNULL,isPop=" + this.isPopStackData + "] ";
        if (this.offset >= 0) {
            result = result + "+";
        }
        result = result + this.offset;
        return result;
    }

    public int getOffset() {
        return this.offset;
    }

    public void setOffset(int offset) {
        this.offset = offset;
    }

    public boolean isPopStackData() {
        return this.isPopStackData;
    }

    public void setPopStackData(boolean isPopStackData) {
        this.isPopStackData = isPopStackData;
    }
}

