/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.dashscope.aigc.codegeneration;

import com.alibaba.dashscope.aigc.codegeneration.CodeGenerationParam;
import com.alibaba.dashscope.aigc.codegeneration.CodeGenerationResult;
import com.alibaba.dashscope.api.SynchronizeHalfDuplexApi;
import com.alibaba.dashscope.common.DashScopeResult;
import com.alibaba.dashscope.common.Function;
import com.alibaba.dashscope.common.OutputMode;
import com.alibaba.dashscope.common.ResultCallback;
import com.alibaba.dashscope.common.Task;
import com.alibaba.dashscope.common.TaskGroup;
import com.alibaba.dashscope.exception.ApiException;
import com.alibaba.dashscope.exception.InputRequiredException;
import com.alibaba.dashscope.exception.NoApiKeyException;
import com.alibaba.dashscope.protocol.ApiServiceOption;
import com.alibaba.dashscope.protocol.ClientOptions;
import com.alibaba.dashscope.protocol.HttpMethod;
import com.alibaba.dashscope.protocol.Protocol;
import com.alibaba.dashscope.protocol.StreamingMode;
import io.reactivex.Flowable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CodeGeneration {
    private static final Logger log = LoggerFactory.getLogger(CodeGeneration.class);
    private final SynchronizeHalfDuplexApi<CodeGenerationParam> syncApi;
    private final ApiServiceOption serviceOption = this.defaultServiceOption();

    private ApiServiceOption defaultServiceOption() {
        return ((ApiServiceOption.ApiServiceOptionBuilder)((ApiServiceOption.ApiServiceOptionBuilder)((ApiServiceOption.ApiServiceOptionBuilder)((ApiServiceOption.ApiServiceOptionBuilder)((ApiServiceOption.ApiServiceOptionBuilder)((ApiServiceOption.ApiServiceOptionBuilder)((ApiServiceOption.ApiServiceOptionBuilder)ApiServiceOption.builder().protocol(Protocol.HTTP)).httpMethod(HttpMethod.POST)).streamingMode(StreamingMode.OUT)).outputMode(OutputMode.ACCUMULATE)).taskGroup(TaskGroup.AIGC.getValue())).task(Task.CODE_GENERATION.getValue())).function(Function.GENERATION.getValue())).build();
    }

    public CodeGeneration() {
        this.syncApi = new SynchronizeHalfDuplexApi(this.serviceOption);
    }

    public CodeGeneration(String protocol) {
        this.serviceOption.setProtocol(Protocol.of(protocol));
        this.syncApi = new SynchronizeHalfDuplexApi((ClientOptions)((ClientOptions.ClientOptionsBuilder)ClientOptions.builder().protocol(protocol)).build(), this.serviceOption);
    }

    public CodeGeneration(String protocol, String baseUrl) {
        this.serviceOption.setProtocol(Protocol.of(protocol));
        if (Protocol.HTTP.getValue().equals(protocol)) {
            this.serviceOption.setBaseHttpUrl(baseUrl);
        } else {
            this.serviceOption.setBaseWebSocketUrl(baseUrl);
        }
        this.syncApi = new SynchronizeHalfDuplexApi((ClientOptions)((ClientOptions.ClientOptionsBuilder)ClientOptions.builder().protocol(protocol)).build(), this.serviceOption);
    }

    public CodeGenerationResult call(CodeGenerationParam param) throws ApiException, NoApiKeyException, InputRequiredException {
        param.validate();
        this.serviceOption.setIsSSE(false);
        this.serviceOption.setStreamingMode(StreamingMode.NONE);
        return CodeGenerationResult.fromDashScopeResult(this.syncApi.call(param));
    }

    public void call(CodeGenerationParam param, final ResultCallback<CodeGenerationResult> callback) throws ApiException, NoApiKeyException, InputRequiredException {
        param.validate();
        this.serviceOption.setIsSSE(false);
        this.serviceOption.setStreamingMode(StreamingMode.NONE);
        this.syncApi.call(param, new ResultCallback<DashScopeResult>(){

            @Override
            public void onEvent(DashScopeResult message) {
                callback.onEvent(CodeGenerationResult.fromDashScopeResult(message));
            }

            @Override
            public void onComplete() {
                callback.onComplete();
            }

            @Override
            public void onError(Exception e) {
                callback.onError(e);
            }
        });
    }

    public Flowable<CodeGenerationResult> streamCall(CodeGenerationParam param) throws ApiException, NoApiKeyException, InputRequiredException {
        param.validate();
        this.serviceOption.setIsSSE(true);
        this.serviceOption.setStreamingMode(StreamingMode.OUT);
        return this.syncApi.streamCall(param).map(item -> CodeGenerationResult.fromDashScopeResult(item));
    }

    public void streamCall(CodeGenerationParam param, final ResultCallback<CodeGenerationResult> callback) throws ApiException, NoApiKeyException, InputRequiredException {
        param.validate();
        this.serviceOption.setIsSSE(true);
        this.serviceOption.setStreamingMode(StreamingMode.OUT);
        this.syncApi.streamCall(param, new ResultCallback<DashScopeResult>(){

            @Override
            public void onEvent(DashScopeResult msg) {
                callback.onEvent(CodeGenerationResult.fromDashScopeResult(msg));
            }

            @Override
            public void onComplete() {
                callback.onComplete();
            }

            @Override
            public void onError(Exception e) {
                callback.onError(e);
            }
        });
    }

    public static class Scenes {
        public static final String CUSTOM = "custom";
        public static final String NL2CODE = "nl2code";
        public static final String CODE2COMMENT = "code2comment";
        public static final String CODE2EXPLAIN = "code2explain";
        public static final String COMMIT2MSG = "commit2msg";
        public static final String UNIT_TEST = "unittest";
        public static final String CODE_QA = "codeqa";
        public static final String NL2SQL = "nl2sql";
    }

    public static class Models {
        public static final String TONGYI_LINGMA_V1 = "tongyi-lingma-v1";
    }
}

