/*
 * Decompiled with CFR 0.152.
 */
import com.alibaba.dashscope.aigc.codegeneration.CodeGeneration;
import com.alibaba.dashscope.aigc.codegeneration.CodeGenerationParam;
import com.alibaba.dashscope.aigc.codegeneration.CodeGenerationResult;
import com.alibaba.dashscope.aigc.codegeneration.models.AttachmentRoleMessageParam;
import com.alibaba.dashscope.aigc.codegeneration.models.MessageParamBase;
import com.alibaba.dashscope.aigc.codegeneration.models.UserRoleMessageParam;
import com.alibaba.dashscope.base.HalfDuplexServiceParam;
import com.alibaba.dashscope.common.ResultCallback;
import com.alibaba.dashscope.exception.ApiException;
import com.alibaba.dashscope.exception.InputRequiredException;
import com.alibaba.dashscope.exception.NoApiKeyException;
import com.alibaba.dashscope.protocol.Protocol;
import com.alibaba.dashscope.utils.JsonUtils;
import io.reactivex.Flowable;
import java.util.ArrayList;
import java.util.concurrent.Semaphore;

public class CodeGenerationQuickStart {
    public static final String MODEL = "tongyi-lingma-v1";

    public static void testCustomSample() throws ApiException, NoApiKeyException, InputRequiredException {
        ArrayList<MessageParamBase> messageParams = new ArrayList<MessageParamBase>();
        messageParams.add(new UserRoleMessageParam("\u6839\u636e\u4e0b\u9762\u7684\u529f\u80fd\u63cf\u8ff0\u751f\u6210\u4e00\u4e2apython\u51fd\u6570\u3002\u4ee3\u7801\u7684\u529f\u80fd\u662f\u8ba1\u7b97\u7ed9\u5b9a\u8def\u5f84\u4e0b\u6240\u6709\u6587\u4ef6\u7684\u603b\u5927\u5c0f\u3002"));
        HalfDuplexServiceParam param = ((CodeGenerationParam.CodeGenerationParamBuilder)((CodeGenerationParam.CodeGenerationParamBuilder)((CodeGenerationParam.CodeGenerationParamBuilder)CodeGenerationParam.builder().model(MODEL)).scene("custom")).message(messageParams)).build();
        CodeGeneration generation = new CodeGeneration();
        CodeGenerationResult result = generation.call((CodeGenerationParam)param);
        System.out.println("testCustomSample\uff1a" + JsonUtils.toJson(result));
    }

    public static void testNl2codeSample() throws ApiException, NoApiKeyException, InputRequiredException {
        ArrayList<MessageParamBase> messageParams = new ArrayList<MessageParamBase>();
        messageParams.add(new UserRoleMessageParam("\u8ba1\u7b97\u7ed9\u5b9a\u8def\u5f84\u4e0b\u6240\u6709\u6587\u4ef6\u7684\u603b\u5927\u5c0f"));
        String meta = "{\"language\": \"java\"}";
        messageParams.add(new AttachmentRoleMessageParam(JsonUtils.parse(meta)));
        HalfDuplexServiceParam param = ((CodeGenerationParam.CodeGenerationParamBuilder)((CodeGenerationParam.CodeGenerationParamBuilder)((CodeGenerationParam.CodeGenerationParamBuilder)CodeGenerationParam.builder().model(MODEL)).scene("nl2code")).message(messageParams)).build();
        CodeGeneration generation = new CodeGeneration();
        CodeGenerationResult result = generation.call((CodeGenerationParam)param);
        System.out.println("testNl2codeSample\uff1a" + JsonUtils.toJson(result));
    }

    public static void testCode2commentSample() throws ApiException, NoApiKeyException, InputRequiredException {
        ArrayList<MessageParamBase> messageParams = new ArrayList<MessageParamBase>();
        messageParams.add(new UserRoleMessageParam("1. \u751f\u6210\u4e2d\u6587\u6ce8\u91ca\\n2. \u4ec5\u751f\u6210\u4ee3\u7801\u90e8\u5206\uff0c\u4e0d\u9700\u8981\u989d\u5916\u89e3\u91ca\u51fd\u6570\u529f\u80fd\\n"));
        String meta = "{\"code\": \"\\t\\t@Override\\n\\t\\tpublic  CancelExportTaskResponse  cancelExportTask(\\n\\t\\t\\t\\tCancelExportTask  cancelExportTask)  {\\n\\t\\t\\tAmazonEC2SkeletonInterface  ec2Service  =  ServiceProvider.getInstance().getServiceImpl(AmazonEC2SkeletonInterface.class);\\n\\t\\t\\treturn  ec2Service.cancelExportTask(cancelExportTask);\\n\\t\\t}\", \"language\": \"java\"}";
        messageParams.add(new AttachmentRoleMessageParam(JsonUtils.parse(meta)));
        HalfDuplexServiceParam param = ((CodeGenerationParam.CodeGenerationParamBuilder)((CodeGenerationParam.CodeGenerationParamBuilder)((CodeGenerationParam.CodeGenerationParamBuilder)CodeGenerationParam.builder().model(MODEL)).scene("code2comment")).message(messageParams)).build();
        CodeGeneration generation = new CodeGeneration();
        CodeGenerationResult result = generation.call((CodeGenerationParam)param);
        System.out.println("testCode2commentSample\uff1a" + JsonUtils.toJson(result));
    }

    public static void testCode2explainSample() throws ApiException, NoApiKeyException, InputRequiredException {
        ArrayList<MessageParamBase> messageParams = new ArrayList<MessageParamBase>();
        messageParams.add(new UserRoleMessageParam("\u8981\u6c42\u4e0d\u4f4e\u4e8e200\u5b57"));
        String meta = "{\"code\": \"@Override\\n                                public  int  getHeaderCacheSize()\\n                                {\\n                                        return  0;\\n                                }\\n\\n\", \"language\": \"java\"}";
        messageParams.add(new AttachmentRoleMessageParam(JsonUtils.parse(meta)));
        HalfDuplexServiceParam param = ((CodeGenerationParam.CodeGenerationParamBuilder)((CodeGenerationParam.CodeGenerationParamBuilder)((CodeGenerationParam.CodeGenerationParamBuilder)CodeGenerationParam.builder().model(MODEL)).scene("code2explain")).message(messageParams)).build();
        CodeGeneration generation = new CodeGeneration();
        CodeGenerationResult result = generation.call((CodeGenerationParam)param);
        System.out.println("testCode2explainSample\uff1a" + JsonUtils.toJson(result));
    }

    public static void testCommit2msgSample() throws ApiException, NoApiKeyException, InputRequiredException {
        ArrayList<MessageParamBase> messageParams = new ArrayList<MessageParamBase>();
        String meta = "{\"diff_list\": [{\"diff\": \"--- src/com/siondream/core/PlatformResolver.java\\n+++ src/com/siondream/core/PlatformResolver.java\\n@@ -1,11 +1,8 @@\\npackage com.siondream.core;\\n-\\n-import com.badlogic.gdx.files.FileHandle;\\n\\npublic interface PlatformResolver {\\npublic void openURL(String url);\\npublic void rateApp();\\npublic void sendFeedback();\\n-\\tpublic FileHandle[] listFolder(String path);\\n}\\n\", \"old_file_path\": \"src/com/siondream/core/PlatformResolver.java\", \"new_file_path\": \"src/com/siondream/core/PlatformResolver.java\"}]}";
        messageParams.add(new AttachmentRoleMessageParam(JsonUtils.parse(meta)));
        HalfDuplexServiceParam param = ((CodeGenerationParam.CodeGenerationParamBuilder)((CodeGenerationParam.CodeGenerationParamBuilder)((CodeGenerationParam.CodeGenerationParamBuilder)CodeGenerationParam.builder().model(MODEL)).scene("commit2msg")).message(messageParams)).build();
        CodeGeneration generation = new CodeGeneration();
        CodeGenerationResult result = generation.call((CodeGenerationParam)param);
        System.out.println("testCommit2msgSample\uff1a" + JsonUtils.toJson(result));
    }

    public static void testUnittestSample() throws ApiException, NoApiKeyException, InputRequiredException {
        ArrayList<MessageParamBase> messageParams = new ArrayList<MessageParamBase>();
        String meta = "{\"code\": \"public static <T> TimestampMap<T> parseTimestampMap(Class<T> typeClass, String input, DateTimeZone timeZone) throws IllegalArgumentException {\\n        if (typeClass == null) {\\n            throw new IllegalArgumentException(\\\"typeClass required\\\");\\n        }\\n\\n        if (input == null) {\\n            return null;\\n        }\\n\\n        TimestampMap result;\\n\\n        typeClass = AttributeUtils.getStandardizedType(typeClass);\\n        if (typeClass.equals(String.class)) {\\n            result = new TimestampStringMap();\\n        } else if (typeClass.equals(Byte.class)) {\\n            result = new TimestampByteMap();\\n        } else if (typeClass.equals(Short.class)) {\\n            result = new TimestampShortMap();\\n        } else if (typeClass.equals(Integer.class)) {\\n            result = new TimestampIntegerMap();\\n        } else if (typeClass.equals(Long.class)) {\\n            result = new TimestampLongMap();\\n        } else if (typeClass.equals(Float.class)) {\\n            result = new TimestampFloatMap();\\n        } else if (typeClass.equals(Double.class)) {\\n            result = new TimestampDoubleMap();\\n        } else if (typeClass.equals(Boolean.class)) {\\n            result = new TimestampBooleanMap();\\n        } else if (typeClass.equals(Character.class)) {\\n            result = new TimestampCharMap();\\n        } else {\\n            throw new IllegalArgumentException(\\\"Unsupported type \\\" + typeClass.getClass().getCanonicalName());\\n        }\\n\\n        if (input.equalsIgnoreCase(EMPTY_VALUE)) {\\n            return result;\\n        }\\n\\n        StringReader reader = new StringReader(input + ' ');// Add 1 space so\\n                                                            // reader.skip\\n                                                            // function always\\n                                                            // works when\\n                                                            // necessary (end of\\n                                                            // string not\\n                                                            // reached).\\n\\n        try {\\n            int r;\\n            char c;\\n            while ((r = reader.read()) != -1) {\\n                c = (char) r;\\n                switch (c) {\\n                    case LEFT_BOUND_SQUARE_BRACKET:\\n                    case LEFT_BOUND_BRACKET:\\n                        parseTimestampAndValue(typeClass, reader, result, timeZone);\\n                        break;\\n                    default:\\n                        // Ignore other chars outside of bounds\\n                }\\n            }\\n        } catch (IOException ex) {\\n            throw new RuntimeException(\\\"Unexpected expection while parsing timestamps\\\", ex);\\n        }\\n\\n        return result;\\n    }\", \"language\": \"java\"}";
        messageParams.add(new AttachmentRoleMessageParam(JsonUtils.parse(meta)));
        HalfDuplexServiceParam param = ((CodeGenerationParam.CodeGenerationParamBuilder)((CodeGenerationParam.CodeGenerationParamBuilder)((CodeGenerationParam.CodeGenerationParamBuilder)CodeGenerationParam.builder().model(MODEL)).scene("unittest")).message(messageParams)).build();
        CodeGeneration generation = new CodeGeneration();
        CodeGenerationResult result = generation.call((CodeGenerationParam)param);
        System.out.println("testUnittestSample\uff1a" + JsonUtils.toJson(result));
    }

    public static void testCodeqaSample() throws ApiException, NoApiKeyException, InputRequiredException {
        ArrayList<MessageParamBase> messageParams = new ArrayList<MessageParamBase>();
        messageParams.add(new UserRoleMessageParam("I'm writing a small web server in Python, using BaseHTTPServer and a custom subclass of BaseHTTPServer.BaseHTTPRequestHandler. Is it possible to make this listen on more than one port?\\nWhat I'm doing now:\\nclass MyRequestHandler(BaseHTTPServer.BaseHTTPRequestHandler):\\n  def doGET\\n  [...]\\n\\nclass ThreadingHTTPServer(ThreadingMixIn, HTTPServer): \\n    pass\\n\\nserver = ThreadingHTTPServer(('localhost', 80), MyRequestHandler)\\nserver.serve_forever()"));
        HalfDuplexServiceParam param = ((CodeGenerationParam.CodeGenerationParamBuilder)((CodeGenerationParam.CodeGenerationParamBuilder)((CodeGenerationParam.CodeGenerationParamBuilder)CodeGenerationParam.builder().model(MODEL)).scene("codeqa")).message(messageParams)).build();
        CodeGeneration generation = new CodeGeneration();
        CodeGenerationResult result = generation.call((CodeGenerationParam)param);
        System.out.println("testCodeqaSample\uff1a" + JsonUtils.toJson(result));
    }

    public static void testNl2sqlSample() throws ApiException, NoApiKeyException, InputRequiredException {
        ArrayList<MessageParamBase> messageParams = new ArrayList<MessageParamBase>();
        messageParams.add(new UserRoleMessageParam("\u5c0f\u660e\u7684\u603b\u5206\u6570\u662f\u591a\u5c11"));
        String meta = "{\"synonym_infos\": {\"\u5b66\u751f\u59d3\u540d\": \"\u59d3\u540d|\u540d\u5b57|\u540d\u79f0\", \"\u5b66\u751f\u5206\u6570\": \"\u5206\u6570|\u5f97\u5206\"}, \"recall_infos\": [{\"content\": \"student_score.id='\u5c0f\u660e'\", \"score\": \"0.83\"}], \"schema_infos\": [{\"table_id\": \"student_score\", \"table_desc\": \"\u5b66\u751f\u5206\u6570\u8868\", \"columns\": [{\"col_name\": \"id\", \"col_caption\": \"\u5b66\u751fid\", \"col_desc\": \"\u4f8b\u503c\u4e3a:1,2,3\", \"col_type\": \"string\"}, {\"col_name\": \"name\", \"col_caption\": \"\u5b66\u751f\u59d3\u540d\", \"col_desc\": \"\u4f8b\u503c\u4e3a:\u5f20\u4e09,\u674e\u56db,\u5c0f\u660e\", \"col_type\": \"string\"}, {\"col_name\": \"score\", \"col_caption\": \"\u5b66\u751f\u5206\u6570\", \"col_desc\": \"\u4f8b\u503c\u4e3a:98,100,66\", \"col_type\": \"string\"}]}]}";
        messageParams.add(new AttachmentRoleMessageParam(JsonUtils.parse(meta)));
        HalfDuplexServiceParam param = ((CodeGenerationParam.CodeGenerationParamBuilder)((CodeGenerationParam.CodeGenerationParamBuilder)((CodeGenerationParam.CodeGenerationParamBuilder)CodeGenerationParam.builder().model(MODEL)).scene("nl2sql")).message(messageParams)).build();
        CodeGeneration generation = new CodeGeneration();
        CodeGenerationResult result = generation.call((CodeGenerationParam)param);
        System.out.println("testNl2sqlSample\uff1a" + JsonUtils.toJson(result));
    }

    public static void testCustomSampleWithCallBack() throws ApiException, NoApiKeyException, InterruptedException, InputRequiredException {
        ArrayList<MessageParamBase> messageParams = new ArrayList<MessageParamBase>();
        messageParams.add(new UserRoleMessageParam("\u6839\u636e\u4e0b\u9762\u7684\u529f\u80fd\u63cf\u8ff0\u751f\u6210\u4e00\u4e2apython\u51fd\u6570\u3002\u4ee3\u7801\u7684\u529f\u80fd\u662f\u8ba1\u7b97\u7ed9\u5b9a\u8def\u5f84\u4e0b\u6240\u6709\u6587\u4ef6\u7684\u603b\u5927\u5c0f\u3002"));
        HalfDuplexServiceParam param = ((CodeGenerationParam.CodeGenerationParamBuilder)((CodeGenerationParam.CodeGenerationParamBuilder)((CodeGenerationParam.CodeGenerationParamBuilder)CodeGenerationParam.builder().model(MODEL)).scene("custom")).message(messageParams)).build();
        CodeGeneration generation = new CodeGeneration();
        final Semaphore semaphore = new Semaphore(0);
        final ArrayList results = new ArrayList();
        generation.call((CodeGenerationParam)param, new ResultCallback<CodeGenerationResult>(){

            @Override
            public void onEvent(CodeGenerationResult msg) {
                results.add(msg);
            }

            @Override
            public void onComplete() {
                semaphore.release();
            }

            @Override
            public void onError(Exception e) {
                semaphore.release();
            }
        });
        semaphore.acquire();
        System.out.println("testCustomSampleWithCallBack\uff1a" + JsonUtils.toJson(results));
    }

    public static void testCustomSampleWithStream() throws ApiException, NoApiKeyException, InputRequiredException {
        ArrayList<MessageParamBase> messageParams = new ArrayList<MessageParamBase>();
        messageParams.add(new UserRoleMessageParam("\u6839\u636e\u4e0b\u9762\u7684\u529f\u80fd\u63cf\u8ff0\u751f\u6210\u4e00\u4e2apython\u51fd\u6570\u3002\u4ee3\u7801\u7684\u529f\u80fd\u662f\u8ba1\u7b97\u7ed9\u5b9a\u8def\u5f84\u4e0b\u6240\u6709\u6587\u4ef6\u7684\u603b\u5927\u5c0f\u3002"));
        HalfDuplexServiceParam param = ((CodeGenerationParam.CodeGenerationParamBuilder)((CodeGenerationParam.CodeGenerationParamBuilder)((CodeGenerationParam.CodeGenerationParamBuilder)CodeGenerationParam.builder().model(MODEL)).scene("custom")).message(messageParams)).build();
        CodeGeneration generation = new CodeGeneration();
        Flowable<CodeGenerationResult> flowable = generation.streamCall((CodeGenerationParam)param);
        flowable.blockingForEach(result -> System.out.println("testCustomSampleWithStream forEach\uff1a" + JsonUtils.toJson(result)));
    }

    public static void testCustomSampleWithStreamCallBack() throws ApiException, NoApiKeyException, InterruptedException, InputRequiredException {
        ArrayList<MessageParamBase> messageParams = new ArrayList<MessageParamBase>();
        messageParams.add(new UserRoleMessageParam("\u6839\u636e\u4e0b\u9762\u7684\u529f\u80fd\u63cf\u8ff0\u751f\u6210\u4e00\u4e2apython\u51fd\u6570\u3002\u4ee3\u7801\u7684\u529f\u80fd\u662f\u8ba1\u7b97\u7ed9\u5b9a\u8def\u5f84\u4e0b\u6240\u6709\u6587\u4ef6\u7684\u603b\u5927\u5c0f\u3002"));
        HalfDuplexServiceParam param = ((CodeGenerationParam.CodeGenerationParamBuilder)((CodeGenerationParam.CodeGenerationParamBuilder)((CodeGenerationParam.CodeGenerationParamBuilder)CodeGenerationParam.builder().model(MODEL)).scene("custom")).message(messageParams)).build();
        CodeGeneration generation = new CodeGeneration();
        final Semaphore semaphore = new Semaphore(0);
        final ArrayList results = new ArrayList();
        generation.streamCall((CodeGenerationParam)param, new ResultCallback<CodeGenerationResult>(){

            @Override
            public void onEvent(CodeGenerationResult msg) {
                results.add(msg);
            }

            @Override
            public void onComplete() {
                semaphore.release();
            }

            @Override
            public void onError(Exception e) {
                semaphore.release();
            }
        });
        semaphore.acquire();
        System.out.println("testCustomSampleWithStreamCallBack\uff1a" + JsonUtils.toJson(results));
    }

    public static void testCustomSampleWithWebSocket() throws ApiException, NoApiKeyException, InterruptedException, InputRequiredException {
        ArrayList<MessageParamBase> messageParams = new ArrayList<MessageParamBase>();
        messageParams.add(new UserRoleMessageParam("\u6839\u636e\u4e0b\u9762\u7684\u529f\u80fd\u63cf\u8ff0\u751f\u6210\u4e00\u4e2apython\u51fd\u6570\u3002\u4ee3\u7801\u7684\u529f\u80fd\u662f\u8ba1\u7b97\u7ed9\u5b9a\u8def\u5f84\u4e0b\u6240\u6709\u6587\u4ef6\u7684\u603b\u5927\u5c0f\u3002"));
        HalfDuplexServiceParam param = ((CodeGenerationParam.CodeGenerationParamBuilder)((CodeGenerationParam.CodeGenerationParamBuilder)((CodeGenerationParam.CodeGenerationParamBuilder)CodeGenerationParam.builder().model(MODEL)).scene("custom")).message(messageParams)).build();
        CodeGeneration generation = new CodeGeneration(Protocol.WEBSOCKET.getValue());
        CodeGenerationResult result = generation.call((CodeGenerationParam)param);
        System.out.println(result);
        System.exit(0);
    }

    public static void main(String[] args) {
        try {
            CodeGenerationQuickStart.testCustomSample();
            CodeGenerationQuickStart.testNl2codeSample();
            CodeGenerationQuickStart.testCode2commentSample();
            CodeGenerationQuickStart.testCode2explainSample();
            CodeGenerationQuickStart.testCommit2msgSample();
            CodeGenerationQuickStart.testUnittestSample();
            CodeGenerationQuickStart.testCodeqaSample();
            CodeGenerationQuickStart.testNl2sqlSample();
            CodeGenerationQuickStart.testCustomSampleWithCallBack();
            CodeGenerationQuickStart.testCustomSampleWithStream();
            CodeGenerationQuickStart.testCustomSampleWithStreamCallBack();
            CodeGenerationQuickStart.testCustomSampleWithWebSocket();
        }
        catch (InputRequiredException | NoApiKeyException | InterruptedException e) {
            e.printStackTrace();
        }
    }
}

