/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.dashscope.threads.runs;

import com.alibaba.dashscope.common.DashScopeResult;
import com.alibaba.dashscope.common.FlattenResultBase;
import com.alibaba.dashscope.common.ResultCallback;
import com.alibaba.dashscope.threads.AssistantStreamEvents;
import com.alibaba.dashscope.threads.AssistantThread;
import com.alibaba.dashscope.threads.messages.ThreadMessage;
import com.alibaba.dashscope.threads.runs.AssistantEventHandler;
import com.alibaba.dashscope.threads.runs.Run;
import com.alibaba.dashscope.threads.runs.RunStep;

final class StreamEventProcessingCallback
extends ResultCallback<DashScopeResult> {
    private AssistantEventHandler handler;

    public StreamEventProcessingCallback(AssistantEventHandler handler) {
        this.handler = handler;
    }

    @Override
    public void onError(Exception ex) {
        this.handler.onError(ex.getMessage());
    }

    @Override
    public void onComplete() {
        this.handler.onDone();
    }

    @Override
    public void onEvent(DashScopeResult message) {
        switch (AssistantStreamEvents.fromValue(message.getEvent())) {
            case THREAD_CREATED: {
                AssistantThread thread = (AssistantThread)FlattenResultBase.fromDashScopeResult(message, AssistantThread.class);
                this.handler.onThreadCreated(thread);
                break;
            }
            case THREAD_RUN_CREATED: {
                Run run = (Run)FlattenResultBase.fromDashScopeResult(message, Run.class);
                this.handler.onThreadRunCreated(run);
                break;
            }
            case THREAD_RUN_QUEUED: {
                Run run = (Run)FlattenResultBase.fromDashScopeResult(message, Run.class);
                this.handler.onThreadRunQueued(run);
                break;
            }
            case THREAD_RUN_IN_PROGRESS: {
                Run run = (Run)FlattenResultBase.fromDashScopeResult(message, Run.class);
                this.handler.onThreadRunInProgress(run);
                break;
            }
            case THREAD_RUN_REQUIRES_ACTION: {
                Run run = (Run)FlattenResultBase.fromDashScopeResult(message, Run.class);
                this.handler.onThreadRunRequiresAction(run);
                break;
            }
            case THREAD_RUN_COMPLETED: {
                Run run = (Run)FlattenResultBase.fromDashScopeResult(message, Run.class);
                this.handler.onThreadRunCompleted(run);
                break;
            }
            case THREAD_RUN_FAILED: {
                Run run = (Run)FlattenResultBase.fromDashScopeResult(message, Run.class);
                this.handler.onThreadRunFailed(run);
                break;
            }
            case THREAD_RUN_CANCELLING: {
                Run run = (Run)FlattenResultBase.fromDashScopeResult(message, Run.class);
                this.handler.onThreadRunCancelling(run);
                break;
            }
            case THREAD_RUN_CANCELED: {
                Run run = (Run)FlattenResultBase.fromDashScopeResult(message, Run.class);
                this.handler.onThreadRunCancelled(run);
                break;
            }
            case THREAD_RUN_EXPIRED: {
                Run run = (Run)FlattenResultBase.fromDashScopeResult(message, Run.class);
                this.handler.onThreadRunExpired(run);
                break;
            }
            case THREAD_RUN_STEP_CREATED: {
                RunStep runStep = (RunStep)FlattenResultBase.fromDashScopeResult(message, RunStep.class);
                this.handler.OnThreadRunStepCreated(runStep);
                break;
            }
            case THREAD_RUN_STEP_IN_PROGRESS: {
                RunStep runStep = (RunStep)FlattenResultBase.fromDashScopeResult(message, RunStep.class);
                this.handler.OnThreadRunStepInProgress(runStep);
                break;
            }
            case THREAD_RUN_STEP_DELTA: {
                RunStep runStep = (RunStep)FlattenResultBase.fromDashScopeResult(message, RunStep.class);
                this.handler.OnThreadRunStepDelta(runStep);
                break;
            }
            case THREAD_RUN_STEP_COMPLETED: {
                RunStep runStep = (RunStep)FlattenResultBase.fromDashScopeResult(message, RunStep.class);
                this.handler.OnThreadRunStepCompleted(runStep);
                break;
            }
            case THREAD_RUN_STEP_FAILED: {
                RunStep runStep = (RunStep)FlattenResultBase.fromDashScopeResult(message, RunStep.class);
                this.handler.OnThreadRunStepFailed(runStep);
                break;
            }
            case THREAD_RUN_STEP_CANCELLED: {
                RunStep runStep = (RunStep)FlattenResultBase.fromDashScopeResult(message, RunStep.class);
                this.handler.OnThreadRunStepCancelled(runStep);
                break;
            }
            case THREAD_RUN_STEP_EXPIRED: {
                RunStep runStep = (RunStep)FlattenResultBase.fromDashScopeResult(message, RunStep.class);
                this.handler.OnThreadRunStepExpired(runStep);
                break;
            }
            case THREAD_MESSAGE_CREATED: {
                ThreadMessage threadMessage = (ThreadMessage)FlattenResultBase.fromDashScopeResult(message, ThreadMessage.class);
                this.handler.onThreadMessageCreated(threadMessage);
                break;
            }
            case THREAD_MESSAGE_DELTA: {
                ThreadMessage threadMessage = (ThreadMessage)FlattenResultBase.fromDashScopeResult(message, ThreadMessage.class);
                this.handler.onThreadMessageDelta(threadMessage);
                break;
            }
            case THREAD_MESSAGE_COMPLETED: {
                ThreadMessage threadMessage = (ThreadMessage)FlattenResultBase.fromDashScopeResult(message, ThreadMessage.class);
                this.handler.onThreadMessageCompleted(threadMessage);
                break;
            }
            case THREAD_MESSAGE_IN_PROGRESS: {
                ThreadMessage threadMessage = (ThreadMessage)FlattenResultBase.fromDashScopeResult(message, ThreadMessage.class);
                this.handler.onThreadMessageCompleted(threadMessage);
                break;
            }
            case THREAD_MESSAGE_INCOMPLETE: {
                ThreadMessage threadMessage = (ThreadMessage)FlattenResultBase.fromDashScopeResult(message, ThreadMessage.class);
                this.handler.onThreadMessageIncomplete(threadMessage);
                break;
            }
            case ERROR: {
                String errorMsg = String.format("Event: %s, data: %s", message.getEvent(), message.getOutput());
                this.handler.onError(errorMsg);
                break;
            }
            default: {
                String msg = String.format("Unknown event: %s, data: %s", message.getEvent(), message.getOutput());
                this.handler.onUnknown(msg);
            }
        }
    }
}

