/*
 * Decompiled with CFR 0.152.
 */
import com.alibaba.dashscope.aigc.multimodalconversation.AudioParameters;
import com.alibaba.dashscope.aigc.multimodalconversation.MultiModalConversation;
import com.alibaba.dashscope.aigc.multimodalconversation.MultiModalConversationMessage;
import com.alibaba.dashscope.aigc.multimodalconversation.MultiModalConversationParam;
import com.alibaba.dashscope.aigc.multimodalconversation.MultiModalConversationResult;
import com.alibaba.dashscope.aigc.multimodalconversation.MultiModalMessageItemImage;
import com.alibaba.dashscope.aigc.multimodalconversation.MultiModalMessageItemText;
import com.alibaba.dashscope.base.HalfDuplexServiceParam;
import com.alibaba.dashscope.common.MultiModalMessage;
import com.alibaba.dashscope.common.Role;
import com.alibaba.dashscope.exception.ApiException;
import com.alibaba.dashscope.exception.NoApiKeyException;
import com.alibaba.dashscope.exception.UploadFileException;
import com.alibaba.dashscope.tools.FunctionDefinition;
import com.alibaba.dashscope.tools.ToolBase;
import com.alibaba.dashscope.tools.ToolFunction;
import com.alibaba.dashscope.utils.JsonUtils;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.github.victools.jsonschema.generator.Option;
import com.github.victools.jsonschema.generator.OptionPreset;
import com.github.victools.jsonschema.generator.SchemaGenerator;
import com.github.victools.jsonschema.generator.SchemaGeneratorConfig;
import com.github.victools.jsonschema.generator.SchemaGeneratorConfigBuilder;
import com.github.victools.jsonschema.generator.SchemaVersion;
import io.reactivex.Flowable;
import java.io.BufferedOutputStream;
import java.io.IOException;
import java.lang.reflect.Type;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Base64;
import java.util.Collections;
import java.util.List;
import java.util.Map;

public class MultiModalConversationUsage {
    private static final String modelName = "qwen-vl-chat-v1";

    public static void simpleMultiModalConversationCall() throws ApiException, NoApiKeyException, UploadFileException {
        MultiModalConversation conv = new MultiModalConversation();
        MultiModalMessageItemText systemText = new MultiModalMessageItemText("You are a helpful assistant.");
        Object systemMessage = ((MultiModalConversationMessage.MultiModalConversationMessageBuilder)((MultiModalConversationMessage.MultiModalConversationMessageBuilder)MultiModalConversationMessage.builder().role(Role.SYSTEM.getValue())).content(Arrays.asList(systemText))).build();
        MultiModalMessageItemImage userImage = new MultiModalMessageItemImage("https://data-generator-idst.oss-cn-shanghai.aliyuncs.com/dashscope/image/multi_embedding/image/256_1.png");
        MultiModalMessageItemText userText = new MultiModalMessageItemText("\u56fe\u7247\u91cc\u6709\u4ec0\u4e48\u4e1c\u897f?");
        Object userMessage = ((MultiModalConversationMessage.MultiModalConversationMessageBuilder)((MultiModalConversationMessage.MultiModalConversationMessageBuilder)MultiModalConversationMessage.builder().role(Role.USER.getValue())).content(Arrays.asList(userImage, userText))).build();
        HalfDuplexServiceParam param = ((MultiModalConversationParam.MultiModalConversationParamBuilder)((MultiModalConversationParam.MultiModalConversationParamBuilder)((MultiModalConversationParam.MultiModalConversationParamBuilder)MultiModalConversationParam.builder().model(modelName)).message(systemMessage)).message(userMessage)).build();
        MultiModalConversationResult result = conv.call((MultiModalConversationParam)param);
        System.out.print(result);
    }

    public static void MultiRoundConversationCall() throws ApiException, NoApiKeyException, UploadFileException {
        MultiModalConversation conv = new MultiModalConversation();
        MultiModalMessageItemText systemText = new MultiModalMessageItemText("You are a helpful assistant.");
        Object systemMessage = ((MultiModalConversationMessage.MultiModalConversationMessageBuilder)((MultiModalConversationMessage.MultiModalConversationMessageBuilder)MultiModalConversationMessage.builder().role(Role.SYSTEM.getValue())).content(Arrays.asList(systemText))).build();
        MultiModalMessageItemImage userImage = new MultiModalMessageItemImage("https://data-generator-idst.oss-cn-shanghai.aliyuncs.com/dashscope/image/multi_embedding/image/256_1.png");
        MultiModalMessageItemText userText = new MultiModalMessageItemText("\u56fe\u7247\u91cc\u6709\u52a8\u7269\u5417?");
        Object userMessage = ((MultiModalConversationMessage.MultiModalConversationMessageBuilder)((MultiModalConversationMessage.MultiModalConversationMessageBuilder)MultiModalConversationMessage.builder().role(Role.USER.getValue())).content(Arrays.asList(userImage, userText))).build();
        ArrayList<Object> messages = new ArrayList<Object>();
        messages.add(systemMessage);
        messages.add(userMessage);
        HalfDuplexServiceParam param = ((MultiModalConversationParam.MultiModalConversationParamBuilder)((MultiModalConversationParam.MultiModalConversationParamBuilder)MultiModalConversationParam.builder().model(modelName)).messages(messages)).build();
        MultiModalConversationResult result = conv.call((MultiModalConversationParam)param);
        System.out.println(result);
        MultiModalMessage resultMessage = result.getOutput().getChoices().get(0).getMessage();
        MultiModalMessageItemText assistentText = new MultiModalMessageItemText((String)resultMessage.getContent().get(0).get("text"));
        Object assistentMessage = ((MultiModalConversationMessage.MultiModalConversationMessageBuilder)((MultiModalConversationMessage.MultiModalConversationMessageBuilder)MultiModalConversationMessage.builder().role(Role.ASSISTANT.getValue())).content(Arrays.asList(assistentText))).build();
        messages.add(assistentMessage);
        userText = new MultiModalMessageItemText("\u56fe\u7247\u52a8\u7269\u662f\u4ec0\u4e48\uff1f");
        messages.add(((MultiModalConversationMessage.MultiModalConversationMessageBuilder)((MultiModalConversationMessage.MultiModalConversationMessageBuilder)MultiModalConversationMessage.builder().role(Role.USER.getValue())).content(Arrays.asList(userText))).build());
        ((MultiModalConversationParam)param).setMessages(messages);
        result = conv.call((MultiModalConversationParam)param);
        System.out.print(result);
    }

    public static void textInTextStreamOut() throws ApiException, NoApiKeyException, UploadFileException, IOException {
        SchemaGeneratorConfigBuilder configBuilder = new SchemaGeneratorConfigBuilder(SchemaVersion.DRAFT_2020_12, OptionPreset.PLAIN_JSON);
        SchemaGeneratorConfig config = configBuilder.with(Option.EXTRA_OPEN_API_FORMAT_VALUES, new Option[0]).without(Option.FLATTENED_ENUMS_FROM_TOSTRING, new Option[0]).build();
        SchemaGenerator generator = new SchemaGenerator(config);
        ObjectNode jsonSchema = generator.generateSchema(GenerationToolChoice.AddFunctionTool.class, new Type[0]);
        Object fd = ((FunctionDefinition.FunctionDefinitionBuilder)((FunctionDefinition.FunctionDefinitionBuilder)((FunctionDefinition.FunctionDefinitionBuilder)FunctionDefinition.builder().name("add")).description("add two number")).parameters(JsonUtils.parseString(jsonSchema.toString()).getAsJsonObject())).build();
        Object systemMsg = ((MultiModalMessage.MultiModalMessageBuilder)((MultiModalMessage.MultiModalMessageBuilder)MultiModalMessage.builder().role(Role.SYSTEM.getValue())).content(Collections.singletonList(Collections.singletonMap("text", "You are a helpful assistant. When asked a question, use tools wherever possible.")))).build();
        Object userMsg = ((MultiModalMessage.MultiModalMessageBuilder)((MultiModalMessage.MultiModalMessageBuilder)MultiModalMessage.builder().role(Role.USER.getValue())).content(Collections.singletonList(Collections.singletonMap("text", "Add 1234 and 4321, Add 2345 and 5432")))).build();
        ToolBase toolFunction = ((ToolFunction.ToolFunctionBuilder)ToolFunction.builder().function((FunctionDefinition)((FunctionDefinition.FunctionDefinitionBuilder)FunctionDefinition.builder().name("add")).build())).build();
        MultiModalConversation conversation = new MultiModalConversation();
        HalfDuplexServiceParam param = ((MultiModalConversationParam.MultiModalConversationParamBuilder)((MultiModalConversationParam.MultiModalConversationParamBuilder)((MultiModalConversationParam.MultiModalConversationParamBuilder)((MultiModalConversationParam.MultiModalConversationParamBuilder)((MultiModalConversationParam.MultiModalConversationParamBuilder)((MultiModalConversationParam.MultiModalConversationParamBuilder)MultiModalConversationParam.builder().model("qwen-vl-max-latest")).messages(Arrays.asList(systemMsg, userMsg))).modalities(Collections.singletonList("text"))).toolChoice(toolFunction)).tools(Arrays.asList(((ToolFunction.ToolFunctionBuilder)ToolFunction.builder().function((FunctionDefinition)fd)).build()))).parallelToolCalls(true)).build();
        Flowable<MultiModalConversationResult> results = conversation.streamCall((MultiModalConversationParam)param);
        results.blockingForEach(result -> System.out.println(JsonUtils.toJson(result)));
    }

    public static void textInAudioStreamOut() throws ApiException, NoApiKeyException, UploadFileException, IOException {
        MultiModalConversation conversation = new MultiModalConversation();
        Object userMessage = ((MultiModalMessage.MultiModalMessageBuilder)((MultiModalMessage.MultiModalMessageBuilder)MultiModalMessage.builder().role(Role.USER.getValue())).content(Collections.singletonList(Collections.singletonMap("text", "1+1\u7b49\u4e8e\u51e0?")))).build();
        HalfDuplexServiceParam param = ((MultiModalConversationParam.MultiModalConversationParamBuilder)((MultiModalConversationParam.MultiModalConversationParamBuilder)((MultiModalConversationParam.MultiModalConversationParamBuilder)((MultiModalConversationParam.MultiModalConversationParamBuilder)MultiModalConversationParam.builder().model("qwen-omni-turbo-latest")).messages(Collections.singletonList(userMessage))).modalities(Collections.singletonList("audio"))).audio((AudioParameters)((AudioParameters.AudioParametersBuilder)AudioParameters.builder().voice(AudioParameters.Voice.ETHAN)).build())).build();
        Flowable<MultiModalConversationResult> results = conversation.streamCall((MultiModalConversationParam)param);
        try (BufferedOutputStream os = new BufferedOutputStream(Files.newOutputStream(Paths.get("out.pcm", new String[0]), new OpenOption[0]));){
            results.blockingForEach(result -> {
                List<Map<String, Object>> content = result.getOutput().getChoices().get(0).getMessage().getContent();
                if (content != null && !content.isEmpty()) {
                    Map<String, Object> map = content.get(0);
                    if (map.containsKey("text")) {
                        String text = String.valueOf(content.get(0).get("text"));
                        System.out.print(text);
                    } else if (map.containsKey("audio")) {
                        Map audio = (Map)map.get("audio");
                        byte[] data = Base64.getDecoder().decode((String)audio.get("data"));
                        Long expiresAt = (Long)audio.get("expires_at");
                        System.out.printf("write [%d] audio data to file, expires at: %d\n", data.length, expiresAt);
                        os.write(data);
                    }
                }
            });
        }
    }

    public static void audioInTextAudioStreamOut() throws ApiException, NoApiKeyException, UploadFileException, IOException {
        MultiModalConversation conversation = new MultiModalConversation();
        Object userMessage = ((MultiModalMessage.MultiModalMessageBuilder)((MultiModalMessage.MultiModalMessageBuilder)MultiModalMessage.builder().role(Role.USER.getValue())).content(Arrays.asList(Collections.singletonMap("audio", "https://dashscope.oss-cn-beijing.aliyuncs.com/samples/audio/paraformer/hello_world_female2.wav"), Collections.singletonMap("text", "\u8fd9\u6bb5\u97f3\u9891\u5728\u8bf4\u4ec0\u4e48?")))).build();
        HalfDuplexServiceParam param = ((MultiModalConversationParam.MultiModalConversationParamBuilder)((MultiModalConversationParam.MultiModalConversationParamBuilder)((MultiModalConversationParam.MultiModalConversationParamBuilder)((MultiModalConversationParam.MultiModalConversationParamBuilder)MultiModalConversationParam.builder().model("qwen-omni-turbo-latest")).messages(Collections.singletonList(userMessage))).modalities(Arrays.asList("text", "audio"))).audio((AudioParameters)((AudioParameters.AudioParametersBuilder)AudioParameters.builder().voice(AudioParameters.Voice.ETHAN)).build())).build();
        Flowable<MultiModalConversationResult> results = conversation.streamCall((MultiModalConversationParam)param);
        try (BufferedOutputStream os = new BufferedOutputStream(Files.newOutputStream(Paths.get("out.pcm", new String[0]), new OpenOption[0]));){
            results.blockingForEach(result -> {
                List<Map<String, Object>> content = result.getOutput().getChoices().get(0).getMessage().getContent();
                if (content != null && !content.isEmpty()) {
                    Map<String, Object> map = content.get(0);
                    if (map.containsKey("text")) {
                        String text = String.valueOf(content.get(0).get("text"));
                        System.out.print(text);
                    } else if (map.containsKey("audio")) {
                        Map audio = (Map)map.get("audio");
                        byte[] data = Base64.getDecoder().decode((String)audio.get("data"));
                        Long expiresAt = (Long)audio.get("expires_at");
                        System.out.printf("write [%d] audio data to file, expires at: %d\n", data.length, expiresAt);
                        os.write(data);
                    }
                }
            });
        }
    }

    public static void imageInTextAudioStreamOut() throws ApiException, NoApiKeyException, UploadFileException, IOException {
        MultiModalConversation conversation = new MultiModalConversation();
        Object userMessage = ((MultiModalMessage.MultiModalMessageBuilder)((MultiModalMessage.MultiModalMessageBuilder)MultiModalMessage.builder().role(Role.USER.getValue())).content(Arrays.asList(Collections.singletonMap("image", "https://dashscope.oss-cn-beijing.aliyuncs.com/images/dog_and_girl.jpeg"), Collections.singletonMap("text", "\u8fd9\u662f\u4ec0\u4e48")))).build();
        HalfDuplexServiceParam param = ((MultiModalConversationParam.MultiModalConversationParamBuilder)((MultiModalConversationParam.MultiModalConversationParamBuilder)((MultiModalConversationParam.MultiModalConversationParamBuilder)((MultiModalConversationParam.MultiModalConversationParamBuilder)MultiModalConversationParam.builder().model("qwen-omni-turbo-latest")).messages(Collections.singletonList(userMessage))).modalities(Arrays.asList("text", "audio"))).audio((AudioParameters)((AudioParameters.AudioParametersBuilder)AudioParameters.builder().voice(AudioParameters.Voice.ETHAN)).build())).build();
        Flowable<MultiModalConversationResult> results = conversation.streamCall((MultiModalConversationParam)param);
        try (BufferedOutputStream os = new BufferedOutputStream(Files.newOutputStream(Paths.get("out.pcm", new String[0]), new OpenOption[0]));){
            results.blockingForEach(result -> {
                List<Map<String, Object>> content = result.getOutput().getChoices().get(0).getMessage().getContent();
                if (content != null && !content.isEmpty()) {
                    Map<String, Object> map = content.get(0);
                    if (map.containsKey("text")) {
                        String text = String.valueOf(content.get(0).get("text"));
                        System.out.print(text);
                    } else if (map.containsKey("audio")) {
                        Map audio = (Map)map.get("audio");
                        byte[] data = Base64.getDecoder().decode((String)audio.get("data"));
                        Long expiresAt = (Long)audio.get("expires_at");
                        System.out.printf("write [%d] audio data to file, expires at: %d\n", data.length, expiresAt);
                        os.write(data);
                    }
                }
            });
        }
    }

    public static void videoInTextAudioStreamOut() throws ApiException, NoApiKeyException, UploadFileException, IOException {
        MultiModalConversation conversation = new MultiModalConversation();
        Object userMessage = ((MultiModalMessage.MultiModalMessageBuilder)((MultiModalMessage.MultiModalMessageBuilder)MultiModalMessage.builder().role(Role.USER.getValue())).content(Arrays.asList(Collections.singletonMap("video", Arrays.asList("https://dashscope.oss-cn-beijing.aliyuncs.com/images/tiger.png")), Collections.singletonMap("text", "\u63cf\u8ff0\u8fd9\u4e2a\u89c6\u9891\u7684\u5177\u4f53\u8fc7\u7a0b")))).build();
        HalfDuplexServiceParam param = ((MultiModalConversationParam.MultiModalConversationParamBuilder)((MultiModalConversationParam.MultiModalConversationParamBuilder)((MultiModalConversationParam.MultiModalConversationParamBuilder)((MultiModalConversationParam.MultiModalConversationParamBuilder)MultiModalConversationParam.builder().model("qwen-omni-turbo-latest")).messages(Collections.singletonList(userMessage))).modalities(Arrays.asList("text", "audio"))).audio((AudioParameters)((AudioParameters.AudioParametersBuilder)AudioParameters.builder().voice(AudioParameters.Voice.ETHAN)).build())).build();
        Flowable<MultiModalConversationResult> results = conversation.streamCall((MultiModalConversationParam)param);
        try (BufferedOutputStream os = new BufferedOutputStream(Files.newOutputStream(Paths.get("out.pcm", new String[0]), new OpenOption[0]));){
            results.blockingForEach(result -> {
                List<Map<String, Object>> content = result.getOutput().getChoices().get(0).getMessage().getContent();
                if (content != null && !content.isEmpty()) {
                    Map<String, Object> map = content.get(0);
                    if (map.containsKey("text")) {
                        String text = String.valueOf(content.get(0).get("text"));
                        System.out.print(text);
                    } else if (map.containsKey("audio")) {
                        Map audio = (Map)map.get("audio");
                        byte[] data = Base64.getDecoder().decode((String)audio.get("data"));
                        Long expiresAt = (Long)audio.get("expires_at");
                        System.out.printf("write [%d] audio data to file, expires at: %d\n", data.length, expiresAt);
                        os.write(data);
                    }
                }
            });
        }
    }

    public static void main(String[] args) {
        try {
            MultiModalConversationUsage.textInTextStreamOut();
        }
        catch (ApiException | NoApiKeyException | UploadFileException | IOException e) {
            System.out.println(e.getMessage());
        }
        System.exit(0);
    }
}

