/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.dashscope.app;

import com.alibaba.dashscope.app.FlowStreamMode;
import com.alibaba.dashscope.app.RagOptions;
import com.alibaba.dashscope.base.HalfDuplexParamBase;
import com.alibaba.dashscope.common.History;
import com.alibaba.dashscope.common.Message;
import com.alibaba.dashscope.common.Role;
import com.alibaba.dashscope.exception.InputRequiredException;
import com.alibaba.dashscope.utils.JsonUtils;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.nio.ByteBuffer;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import lombok.NonNull;

public class ApplicationParam
extends HalfDuplexParamBase {
    private Object resources;
    @NonNull
    private String appId;
    private String prompt;
    private List<History> history;
    private List<Message> messages;
    private String sessionId;
    private Boolean hasThoughts;
    private JsonObject bizParams;
    private Double topP;
    private Integer topK;
    private Integer seed;
    private Float temperature;
    private Boolean incrementalOutput;
    private String memoryId;
    private List<String> images;
    private RagOptions ragOptions;
    private List<String> mcpServers;
    private Boolean enableWebSearch;
    private Boolean enableSystemTime;
    private Boolean enablePremium;
    private Integer dialogRound;
    private String modelId;
    private FlowStreamMode flowStreamMode;

    @Override
    public String getModel() {
        return null;
    }

    @Override
    public Map<String, Object> getParameters() {
        HashMap<String, Object> params = new HashMap<String, Object>(0);
        if (this.topP != null) {
            params.put("top_p", this.topP);
        }
        if (this.topK != null) {
            params.put("top_k", this.topK);
        }
        if (this.seed != null) {
            params.put("seed", this.seed);
        }
        if (this.temperature != null) {
            params.put("temperature", this.temperature);
        }
        if (this.hasThoughts != null) {
            params.put("has_thoughts", this.hasThoughts);
        }
        if (this.incrementalOutput != null) {
            params.put("incremental_output", this.incrementalOutput);
        }
        if (this.ragOptions != null) {
            params.put("rag_options", this.ragOptions);
        }
        if (this.mcpServers != null) {
            params.put("mcp_servers", this.mcpServers);
        }
        if (this.enableWebSearch != null) {
            params.put("enable_web_search", this.enableWebSearch);
        }
        if (this.enableSystemTime != null) {
            params.put("enable_system_time", this.enableSystemTime);
        }
        if (this.enablePremium != null) {
            params.put("enable_premium", this.enablePremium);
        }
        if (this.dialogRound != null) {
            params.put("dialog_round", this.dialogRound);
        }
        if (this.modelId != null) {
            params.put("model_id", this.modelId);
        }
        if (this.flowStreamMode != null) {
            params.put("flow_stream_mode", this.flowStreamMode.getValue());
        }
        params.putAll(this.parameters);
        return params;
    }

    @Override
    public Map<String, String> getHeaders() {
        HashMap<String, String> reqHeaders = new HashMap<String, String>();
        for (Map.Entry entry : this.headers.entrySet()) {
            String key = (String)entry.getKey();
            String value = entry.getValue().toString();
            reqHeaders.put(key, value);
        }
        return reqHeaders;
    }

    @Override
    public JsonObject getHttpBody() {
        JsonObject body = new JsonObject();
        body.add("input", (JsonElement)this.getInput());
        Map<String, Object> params = this.getParameters();
        if (params != null && !params.isEmpty()) {
            body.add("parameters", (JsonElement)JsonUtils.parametersToJsonObject(params));
        }
        return body;
    }

    public JsonObject getInput() {
        JsonObject input = new JsonObject();
        input.addProperty("session_id", this.getSessionId());
        input.addProperty("memory_id", this.memoryId);
        if (this.getMessages() != null && !this.getMessages().isEmpty()) {
            JsonArray messagesJson = new JsonArray();
            messagesJson.addAll(JsonUtils.toJsonArray(this.getMessages()));
            if (this.getPrompt() != null) {
                Object msg = ((Message.MessageBuilder)((Message.MessageBuilder)Message.builder().role(Role.USER.getValue())).content(this.getPrompt())).build();
                messagesJson.add(JsonUtils.toJsonElement(msg));
            }
            input.add("messages", (JsonElement)messagesJson);
        } else if (this.getHistory() != null && !this.getHistory().isEmpty()) {
            JsonArray historyJson = JsonUtils.toJsonElement(this.getHistory()).getAsJsonArray();
            input.add("history", (JsonElement)historyJson);
            if (this.getPrompt() != null) {
                input.addProperty("prompt", this.getPrompt());
            }
        } else if (this.getPrompt() != null) {
            input.addProperty("prompt", this.getPrompt());
        }
        if (this.bizParams != null) {
            input.add("biz_params", (JsonElement)this.bizParams);
        }
        if (this.images != null && !this.images.isEmpty()) {
            JsonArray imagesJson = JsonUtils.toJsonElement(this.images).getAsJsonArray();
            input.add("image_list", (JsonElement)imagesJson);
        }
        return input;
    }

    @Override
    public Object getResources() {
        return this.resources;
    }

    @Override
    public ByteBuffer getBinaryData() {
        return null;
    }

    @Override
    public void validate() throws InputRequiredException {
        if (this.getPrompt() == null && (this.getMessages() == null || this.getMessages().isEmpty())) {
            throw new InputRequiredException("prompt or messages must not be null");
        }
    }

    private static Object $default$resources() {
        return null;
    }

    private static Boolean $default$hasThoughts() {
        return false;
    }

    private static Boolean $default$incrementalOutput() {
        return false;
    }

    protected ApplicationParam(ApplicationParamBuilder<?, ?> b) {
        super(b);
        this.resources = ((ApplicationParamBuilder)b).resources$set ? ((ApplicationParamBuilder)b).resources$value : ApplicationParam.$default$resources();
        this.appId = ((ApplicationParamBuilder)b).appId;
        if (this.appId == null) {
            throw new NullPointerException("appId is marked non-null but is null");
        }
        this.prompt = ((ApplicationParamBuilder)b).prompt;
        this.history = ((ApplicationParamBuilder)b).history;
        this.messages = ((ApplicationParamBuilder)b).messages;
        this.sessionId = ((ApplicationParamBuilder)b).sessionId;
        this.hasThoughts = ((ApplicationParamBuilder)b).hasThoughts$set ? ((ApplicationParamBuilder)b).hasThoughts$value : ApplicationParam.$default$hasThoughts();
        this.bizParams = ((ApplicationParamBuilder)b).bizParams;
        this.topP = ((ApplicationParamBuilder)b).topP;
        this.topK = ((ApplicationParamBuilder)b).topK;
        this.seed = ((ApplicationParamBuilder)b).seed;
        this.temperature = ((ApplicationParamBuilder)b).temperature;
        this.incrementalOutput = ((ApplicationParamBuilder)b).incrementalOutput$set ? ((ApplicationParamBuilder)b).incrementalOutput$value : ApplicationParam.$default$incrementalOutput();
        this.memoryId = ((ApplicationParamBuilder)b).memoryId;
        this.images = ((ApplicationParamBuilder)b).images;
        this.ragOptions = ((ApplicationParamBuilder)b).ragOptions;
        this.mcpServers = ((ApplicationParamBuilder)b).mcpServers;
        this.enableWebSearch = ((ApplicationParamBuilder)b).enableWebSearch;
        this.enableSystemTime = ((ApplicationParamBuilder)b).enableSystemTime;
        this.enablePremium = ((ApplicationParamBuilder)b).enablePremium;
        this.dialogRound = ((ApplicationParamBuilder)b).dialogRound;
        this.modelId = ((ApplicationParamBuilder)b).modelId;
        this.flowStreamMode = ((ApplicationParamBuilder)b).flowStreamMode;
    }

    public static ApplicationParamBuilder<?, ?> builder() {
        return new ApplicationParamBuilderImpl();
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ApplicationParam)) {
            return false;
        }
        ApplicationParam other = (ApplicationParam)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        Boolean this$hasThoughts = this.getHasThoughts();
        Boolean other$hasThoughts = other.getHasThoughts();
        if (this$hasThoughts == null ? other$hasThoughts != null : !((Object)this$hasThoughts).equals(other$hasThoughts)) {
            return false;
        }
        Double this$topP = this.getTopP();
        Double other$topP = other.getTopP();
        if (this$topP == null ? other$topP != null : !((Object)this$topP).equals(other$topP)) {
            return false;
        }
        Integer this$topK = this.getTopK();
        Integer other$topK = other.getTopK();
        if (this$topK == null ? other$topK != null : !((Object)this$topK).equals(other$topK)) {
            return false;
        }
        Integer this$seed = this.getSeed();
        Integer other$seed = other.getSeed();
        if (this$seed == null ? other$seed != null : !((Object)this$seed).equals(other$seed)) {
            return false;
        }
        Float this$temperature = this.getTemperature();
        Float other$temperature = other.getTemperature();
        if (this$temperature == null ? other$temperature != null : !((Object)this$temperature).equals(other$temperature)) {
            return false;
        }
        Boolean this$incrementalOutput = this.getIncrementalOutput();
        Boolean other$incrementalOutput = other.getIncrementalOutput();
        if (this$incrementalOutput == null ? other$incrementalOutput != null : !((Object)this$incrementalOutput).equals(other$incrementalOutput)) {
            return false;
        }
        Boolean this$enableWebSearch = this.getEnableWebSearch();
        Boolean other$enableWebSearch = other.getEnableWebSearch();
        if (this$enableWebSearch == null ? other$enableWebSearch != null : !((Object)this$enableWebSearch).equals(other$enableWebSearch)) {
            return false;
        }
        Boolean this$enableSystemTime = this.getEnableSystemTime();
        Boolean other$enableSystemTime = other.getEnableSystemTime();
        if (this$enableSystemTime == null ? other$enableSystemTime != null : !((Object)this$enableSystemTime).equals(other$enableSystemTime)) {
            return false;
        }
        Boolean this$enablePremium = this.getEnablePremium();
        Boolean other$enablePremium = other.getEnablePremium();
        if (this$enablePremium == null ? other$enablePremium != null : !((Object)this$enablePremium).equals(other$enablePremium)) {
            return false;
        }
        Integer this$dialogRound = this.getDialogRound();
        Integer other$dialogRound = other.getDialogRound();
        if (this$dialogRound == null ? other$dialogRound != null : !((Object)this$dialogRound).equals(other$dialogRound)) {
            return false;
        }
        Object this$resources = this.getResources();
        Object other$resources = other.getResources();
        if (this$resources == null ? other$resources != null : !this$resources.equals(other$resources)) {
            return false;
        }
        String this$appId = this.getAppId();
        String other$appId = other.getAppId();
        if (this$appId == null ? other$appId != null : !this$appId.equals(other$appId)) {
            return false;
        }
        String this$prompt = this.getPrompt();
        String other$prompt = other.getPrompt();
        if (this$prompt == null ? other$prompt != null : !this$prompt.equals(other$prompt)) {
            return false;
        }
        List<History> this$history = this.getHistory();
        List<History> other$history = other.getHistory();
        if (this$history == null ? other$history != null : !((Object)this$history).equals(other$history)) {
            return false;
        }
        List<Message> this$messages = this.getMessages();
        List<Message> other$messages = other.getMessages();
        if (this$messages == null ? other$messages != null : !((Object)this$messages).equals(other$messages)) {
            return false;
        }
        String this$sessionId = this.getSessionId();
        String other$sessionId = other.getSessionId();
        if (this$sessionId == null ? other$sessionId != null : !this$sessionId.equals(other$sessionId)) {
            return false;
        }
        JsonObject this$bizParams = this.getBizParams();
        JsonObject other$bizParams = other.getBizParams();
        if (this$bizParams == null ? other$bizParams != null : !this$bizParams.equals(other$bizParams)) {
            return false;
        }
        String this$memoryId = this.getMemoryId();
        String other$memoryId = other.getMemoryId();
        if (this$memoryId == null ? other$memoryId != null : !this$memoryId.equals(other$memoryId)) {
            return false;
        }
        List<String> this$images = this.getImages();
        List<String> other$images = other.getImages();
        if (this$images == null ? other$images != null : !((Object)this$images).equals(other$images)) {
            return false;
        }
        RagOptions this$ragOptions = this.getRagOptions();
        RagOptions other$ragOptions = other.getRagOptions();
        if (this$ragOptions == null ? other$ragOptions != null : !((Object)this$ragOptions).equals(other$ragOptions)) {
            return false;
        }
        List<String> this$mcpServers = this.getMcpServers();
        List<String> other$mcpServers = other.getMcpServers();
        if (this$mcpServers == null ? other$mcpServers != null : !((Object)this$mcpServers).equals(other$mcpServers)) {
            return false;
        }
        String this$modelId = this.getModelId();
        String other$modelId = other.getModelId();
        if (this$modelId == null ? other$modelId != null : !this$modelId.equals(other$modelId)) {
            return false;
        }
        FlowStreamMode this$flowStreamMode = this.getFlowStreamMode();
        FlowStreamMode other$flowStreamMode = other.getFlowStreamMode();
        return !(this$flowStreamMode == null ? other$flowStreamMode != null : !((Object)((Object)this$flowStreamMode)).equals((Object)other$flowStreamMode));
    }

    @Override
    protected boolean canEqual(Object other) {
        return other instanceof ApplicationParam;
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        Boolean $hasThoughts = this.getHasThoughts();
        result = result * 59 + ($hasThoughts == null ? 43 : ((Object)$hasThoughts).hashCode());
        Double $topP = this.getTopP();
        result = result * 59 + ($topP == null ? 43 : ((Object)$topP).hashCode());
        Integer $topK = this.getTopK();
        result = result * 59 + ($topK == null ? 43 : ((Object)$topK).hashCode());
        Integer $seed = this.getSeed();
        result = result * 59 + ($seed == null ? 43 : ((Object)$seed).hashCode());
        Float $temperature = this.getTemperature();
        result = result * 59 + ($temperature == null ? 43 : ((Object)$temperature).hashCode());
        Boolean $incrementalOutput = this.getIncrementalOutput();
        result = result * 59 + ($incrementalOutput == null ? 43 : ((Object)$incrementalOutput).hashCode());
        Boolean $enableWebSearch = this.getEnableWebSearch();
        result = result * 59 + ($enableWebSearch == null ? 43 : ((Object)$enableWebSearch).hashCode());
        Boolean $enableSystemTime = this.getEnableSystemTime();
        result = result * 59 + ($enableSystemTime == null ? 43 : ((Object)$enableSystemTime).hashCode());
        Boolean $enablePremium = this.getEnablePremium();
        result = result * 59 + ($enablePremium == null ? 43 : ((Object)$enablePremium).hashCode());
        Integer $dialogRound = this.getDialogRound();
        result = result * 59 + ($dialogRound == null ? 43 : ((Object)$dialogRound).hashCode());
        Object $resources = this.getResources();
        result = result * 59 + ($resources == null ? 43 : $resources.hashCode());
        String $appId = this.getAppId();
        result = result * 59 + ($appId == null ? 43 : $appId.hashCode());
        String $prompt = this.getPrompt();
        result = result * 59 + ($prompt == null ? 43 : $prompt.hashCode());
        List<History> $history = this.getHistory();
        result = result * 59 + ($history == null ? 43 : ((Object)$history).hashCode());
        List<Message> $messages = this.getMessages();
        result = result * 59 + ($messages == null ? 43 : ((Object)$messages).hashCode());
        String $sessionId = this.getSessionId();
        result = result * 59 + ($sessionId == null ? 43 : $sessionId.hashCode());
        JsonObject $bizParams = this.getBizParams();
        result = result * 59 + ($bizParams == null ? 43 : $bizParams.hashCode());
        String $memoryId = this.getMemoryId();
        result = result * 59 + ($memoryId == null ? 43 : $memoryId.hashCode());
        List<String> $images = this.getImages();
        result = result * 59 + ($images == null ? 43 : ((Object)$images).hashCode());
        RagOptions $ragOptions = this.getRagOptions();
        result = result * 59 + ($ragOptions == null ? 43 : ((Object)$ragOptions).hashCode());
        List<String> $mcpServers = this.getMcpServers();
        result = result * 59 + ($mcpServers == null ? 43 : ((Object)$mcpServers).hashCode());
        String $modelId = this.getModelId();
        result = result * 59 + ($modelId == null ? 43 : $modelId.hashCode());
        FlowStreamMode $flowStreamMode = this.getFlowStreamMode();
        result = result * 59 + ($flowStreamMode == null ? 43 : ((Object)((Object)$flowStreamMode)).hashCode());
        return result;
    }

    @NonNull
    public String getAppId() {
        return this.appId;
    }

    public String getPrompt() {
        return this.prompt;
    }

    public List<History> getHistory() {
        return this.history;
    }

    public List<Message> getMessages() {
        return this.messages;
    }

    public String getSessionId() {
        return this.sessionId;
    }

    public Boolean getHasThoughts() {
        return this.hasThoughts;
    }

    public JsonObject getBizParams() {
        return this.bizParams;
    }

    public Double getTopP() {
        return this.topP;
    }

    public Integer getTopK() {
        return this.topK;
    }

    public Integer getSeed() {
        return this.seed;
    }

    public Float getTemperature() {
        return this.temperature;
    }

    public Boolean getIncrementalOutput() {
        return this.incrementalOutput;
    }

    public String getMemoryId() {
        return this.memoryId;
    }

    public List<String> getImages() {
        return this.images;
    }

    public RagOptions getRagOptions() {
        return this.ragOptions;
    }

    public List<String> getMcpServers() {
        return this.mcpServers;
    }

    public Boolean getEnableWebSearch() {
        return this.enableWebSearch;
    }

    public Boolean getEnableSystemTime() {
        return this.enableSystemTime;
    }

    public Boolean getEnablePremium() {
        return this.enablePremium;
    }

    public Integer getDialogRound() {
        return this.dialogRound;
    }

    public String getModelId() {
        return this.modelId;
    }

    public FlowStreamMode getFlowStreamMode() {
        return this.flowStreamMode;
    }

    public void setResources(Object resources) {
        this.resources = resources;
    }

    public void setAppId(@NonNull String appId) {
        if (appId == null) {
            throw new NullPointerException("appId is marked non-null but is null");
        }
        this.appId = appId;
    }

    public void setPrompt(String prompt) {
        this.prompt = prompt;
    }

    public void setHistory(List<History> history) {
        this.history = history;
    }

    public void setMessages(List<Message> messages) {
        this.messages = messages;
    }

    public void setSessionId(String sessionId) {
        this.sessionId = sessionId;
    }

    public void setHasThoughts(Boolean hasThoughts) {
        this.hasThoughts = hasThoughts;
    }

    public void setBizParams(JsonObject bizParams) {
        this.bizParams = bizParams;
    }

    public void setTopP(Double topP) {
        this.topP = topP;
    }

    public void setTopK(Integer topK) {
        this.topK = topK;
    }

    public void setSeed(Integer seed) {
        this.seed = seed;
    }

    public void setTemperature(Float temperature) {
        this.temperature = temperature;
    }

    public void setIncrementalOutput(Boolean incrementalOutput) {
        this.incrementalOutput = incrementalOutput;
    }

    public void setMemoryId(String memoryId) {
        this.memoryId = memoryId;
    }

    public void setImages(List<String> images) {
        this.images = images;
    }

    public void setRagOptions(RagOptions ragOptions) {
        this.ragOptions = ragOptions;
    }

    public void setMcpServers(List<String> mcpServers) {
        this.mcpServers = mcpServers;
    }

    public void setEnableWebSearch(Boolean enableWebSearch) {
        this.enableWebSearch = enableWebSearch;
    }

    public void setEnableSystemTime(Boolean enableSystemTime) {
        this.enableSystemTime = enableSystemTime;
    }

    public void setEnablePremium(Boolean enablePremium) {
        this.enablePremium = enablePremium;
    }

    public void setDialogRound(Integer dialogRound) {
        this.dialogRound = dialogRound;
    }

    public void setModelId(String modelId) {
        this.modelId = modelId;
    }

    public void setFlowStreamMode(FlowStreamMode flowStreamMode) {
        this.flowStreamMode = flowStreamMode;
    }

    @Override
    public String toString() {
        return "ApplicationParam(resources=" + this.getResources() + ", appId=" + this.getAppId() + ", prompt=" + this.getPrompt() + ", history=" + this.getHistory() + ", messages=" + this.getMessages() + ", sessionId=" + this.getSessionId() + ", hasThoughts=" + this.getHasThoughts() + ", bizParams=" + this.getBizParams() + ", topP=" + this.getTopP() + ", topK=" + this.getTopK() + ", seed=" + this.getSeed() + ", temperature=" + this.getTemperature() + ", incrementalOutput=" + this.getIncrementalOutput() + ", memoryId=" + this.getMemoryId() + ", images=" + this.getImages() + ", ragOptions=" + this.getRagOptions() + ", mcpServers=" + this.getMcpServers() + ", enableWebSearch=" + this.getEnableWebSearch() + ", enableSystemTime=" + this.getEnableSystemTime() + ", enablePremium=" + this.getEnablePremium() + ", dialogRound=" + this.getDialogRound() + ", modelId=" + this.getModelId() + ", flowStreamMode=" + (Object)((Object)this.getFlowStreamMode()) + ")";
    }

    private static final class ApplicationParamBuilderImpl
    extends ApplicationParamBuilder<ApplicationParam, ApplicationParamBuilderImpl> {
        private ApplicationParamBuilderImpl() {
        }

        @Override
        protected ApplicationParamBuilderImpl self() {
            return this;
        }

        @Override
        public ApplicationParam build() {
            return new ApplicationParam(this);
        }
    }

    public static abstract class ApplicationParamBuilder<C extends ApplicationParam, B extends ApplicationParamBuilder<C, B>>
    extends HalfDuplexParamBase.HalfDuplexParamBaseBuilder<C, B> {
        private boolean resources$set;
        private Object resources$value;
        private String appId;
        private String prompt;
        private List<History> history;
        private List<Message> messages;
        private String sessionId;
        private boolean hasThoughts$set;
        private Boolean hasThoughts$value;
        private JsonObject bizParams;
        private Double topP;
        private Integer topK;
        private Integer seed;
        private Float temperature;
        private boolean incrementalOutput$set;
        private Boolean incrementalOutput$value;
        private String memoryId;
        private List<String> images;
        private RagOptions ragOptions;
        private List<String> mcpServers;
        private Boolean enableWebSearch;
        private Boolean enableSystemTime;
        private Boolean enablePremium;
        private Integer dialogRound;
        private String modelId;
        private FlowStreamMode flowStreamMode;

        public B resources(Object resources) {
            this.resources$value = resources;
            this.resources$set = true;
            return (B)this.self();
        }

        public B appId(@NonNull String appId) {
            if (appId == null) {
                throw new NullPointerException("appId is marked non-null but is null");
            }
            this.appId = appId;
            return (B)this.self();
        }

        public B prompt(String prompt) {
            this.prompt = prompt;
            return (B)this.self();
        }

        public B history(List<History> history) {
            this.history = history;
            return (B)this.self();
        }

        public B messages(List<Message> messages) {
            this.messages = messages;
            return (B)this.self();
        }

        public B sessionId(String sessionId) {
            this.sessionId = sessionId;
            return (B)this.self();
        }

        public B hasThoughts(Boolean hasThoughts) {
            this.hasThoughts$value = hasThoughts;
            this.hasThoughts$set = true;
            return (B)this.self();
        }

        public B bizParams(JsonObject bizParams) {
            this.bizParams = bizParams;
            return (B)this.self();
        }

        public B topP(Double topP) {
            this.topP = topP;
            return (B)this.self();
        }

        public B topK(Integer topK) {
            this.topK = topK;
            return (B)this.self();
        }

        public B seed(Integer seed) {
            this.seed = seed;
            return (B)this.self();
        }

        public B temperature(Float temperature) {
            this.temperature = temperature;
            return (B)this.self();
        }

        public B incrementalOutput(Boolean incrementalOutput) {
            this.incrementalOutput$value = incrementalOutput;
            this.incrementalOutput$set = true;
            return (B)this.self();
        }

        public B memoryId(String memoryId) {
            this.memoryId = memoryId;
            return (B)this.self();
        }

        public B images(List<String> images) {
            this.images = images;
            return (B)this.self();
        }

        public B ragOptions(RagOptions ragOptions) {
            this.ragOptions = ragOptions;
            return (B)this.self();
        }

        public B mcpServers(List<String> mcpServers) {
            this.mcpServers = mcpServers;
            return (B)this.self();
        }

        public B enableWebSearch(Boolean enableWebSearch) {
            this.enableWebSearch = enableWebSearch;
            return (B)this.self();
        }

        public B enableSystemTime(Boolean enableSystemTime) {
            this.enableSystemTime = enableSystemTime;
            return (B)this.self();
        }

        public B enablePremium(Boolean enablePremium) {
            this.enablePremium = enablePremium;
            return (B)this.self();
        }

        public B dialogRound(Integer dialogRound) {
            this.dialogRound = dialogRound;
            return (B)this.self();
        }

        public B modelId(String modelId) {
            this.modelId = modelId;
            return (B)this.self();
        }

        public B flowStreamMode(FlowStreamMode flowStreamMode) {
            this.flowStreamMode = flowStreamMode;
            return (B)this.self();
        }

        @Override
        protected abstract B self();

        @Override
        public abstract C build();

        @Override
        public String toString() {
            return "ApplicationParam.ApplicationParamBuilder(super=" + super.toString() + ", resources$value=" + this.resources$value + ", appId=" + this.appId + ", prompt=" + this.prompt + ", history=" + this.history + ", messages=" + this.messages + ", sessionId=" + this.sessionId + ", hasThoughts$value=" + this.hasThoughts$value + ", bizParams=" + this.bizParams + ", topP=" + this.topP + ", topK=" + this.topK + ", seed=" + this.seed + ", temperature=" + this.temperature + ", incrementalOutput$value=" + this.incrementalOutput$value + ", memoryId=" + this.memoryId + ", images=" + this.images + ", ragOptions=" + this.ragOptions + ", mcpServers=" + this.mcpServers + ", enableWebSearch=" + this.enableWebSearch + ", enableSystemTime=" + this.enableSystemTime + ", enablePremium=" + this.enablePremium + ", dialogRound=" + this.dialogRound + ", modelId=" + this.modelId + ", flowStreamMode=" + (Object)((Object)this.flowStreamMode) + ")";
        }
    }
}

