/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.dashscope.app;

import com.alibaba.dashscope.app.ApplicationOutput;
import com.alibaba.dashscope.app.ApplicationUsage;
import com.alibaba.dashscope.common.DashScopeResult;
import com.alibaba.dashscope.utils.JsonUtils;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.annotations.SerializedName;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ApplicationResult {
    private static final Logger log = LoggerFactory.getLogger(ApplicationResult.class);
    @SerializedName(value="request_id")
    private String requestId;
    @SerializedName(value="output")
    private ApplicationOutput output;
    @SerializedName(value="usage")
    private ApplicationUsage usage;

    public static ApplicationResult fromDashScopeResult(DashScopeResult dashScopeResult) {
        ApplicationResult result = new ApplicationResult();
        result.setRequestId(dashScopeResult.getRequestId());
        if (dashScopeResult.getUsage() != null) {
            result.setUsage(JsonUtils.fromJsonObject((JsonElement)dashScopeResult.getUsage().getAsJsonObject(), ApplicationUsage.class));
        }
        if (dashScopeResult.getOutput() != null) {
            result.setOutput(JsonUtils.fromJsonObject((JsonElement)((JsonObject)dashScopeResult.getOutput()), ApplicationOutput.class));
        } else {
            log.error(String.format("Result no output: %s", dashScopeResult));
        }
        return result;
    }

    public String getRequestId() {
        return this.requestId;
    }

    public ApplicationOutput getOutput() {
        return this.output;
    }

    public ApplicationUsage getUsage() {
        return this.usage;
    }

    public void setRequestId(String requestId) {
        this.requestId = requestId;
    }

    public void setOutput(ApplicationOutput output) {
        this.output = output;
    }

    public void setUsage(ApplicationUsage usage) {
        this.usage = usage;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ApplicationResult)) {
            return false;
        }
        ApplicationResult other = (ApplicationResult)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$requestId = this.getRequestId();
        String other$requestId = other.getRequestId();
        if (this$requestId == null ? other$requestId != null : !this$requestId.equals(other$requestId)) {
            return false;
        }
        ApplicationOutput this$output = this.getOutput();
        ApplicationOutput other$output = other.getOutput();
        if (this$output == null ? other$output != null : !((Object)this$output).equals(other$output)) {
            return false;
        }
        ApplicationUsage this$usage = this.getUsage();
        ApplicationUsage other$usage = other.getUsage();
        return !(this$usage == null ? other$usage != null : !((Object)this$usage).equals(other$usage));
    }

    protected boolean canEqual(Object other) {
        return other instanceof ApplicationResult;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $requestId = this.getRequestId();
        result = result * 59 + ($requestId == null ? 43 : $requestId.hashCode());
        ApplicationOutput $output = this.getOutput();
        result = result * 59 + ($output == null ? 43 : ((Object)$output).hashCode());
        ApplicationUsage $usage = this.getUsage();
        result = result * 59 + ($usage == null ? 43 : ((Object)$usage).hashCode());
        return result;
    }

    public String toString() {
        return "ApplicationResult(requestId=" + this.getRequestId() + ", output=" + this.getOutput() + ", usage=" + this.getUsage() + ")";
    }
}

