/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.dashscope.aigc.videosynthesis;

import com.alibaba.dashscope.base.HalfDuplexServiceParam;
import com.alibaba.dashscope.exception.InputRequiredException;
import com.alibaba.dashscope.exception.NoApiKeyException;
import com.alibaba.dashscope.exception.UploadFileException;
import com.alibaba.dashscope.utils.GsonExclude;
import com.alibaba.dashscope.utils.JsonUtils;
import com.alibaba.dashscope.utils.PreprocessInputImage;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;

public class VideoSynthesisParam
extends HalfDuplexServiceParam {
    private Map<String, String> inputChecks;
    private String size;
    private Integer steps;
    private Integer seed;
    private String prompt;
    @Deprecated
    private String negative_prompt;
    private String negativePrompt;
    private String template;
    @Deprecated
    private Boolean extendPrompt;
    private String imgUrl;
    @GsonExclude
    protected Map<String, Object> extraInputs;
    private Integer duration;
    private String firstFrameUrl;
    private String lastFrameUrl;
    private String headFrame;
    private String tailFrame;
    private Boolean withAudio;
    private String resolution;

    public JsonObject getInput() {
        JsonObject jsonObject = new JsonObject();
        if (this.prompt != null && !this.prompt.isEmpty()) {
            jsonObject.addProperty("prompt", this.prompt);
        }
        jsonObject.addProperty("extend_prompt", this.extendPrompt);
        if (this.negative_prompt != null && !this.negative_prompt.isEmpty()) {
            jsonObject.addProperty("negative_prompt", this.negative_prompt);
        }
        if (this.negativePrompt != null && !this.negativePrompt.isEmpty()) {
            jsonObject.addProperty("negative_prompt", this.negativePrompt);
        }
        if (this.template != null && !this.template.isEmpty()) {
            jsonObject.addProperty("template", this.template);
        }
        if (this.imgUrl != null && !this.imgUrl.isEmpty()) {
            jsonObject.addProperty("img_url", this.imgUrl);
        }
        if (this.firstFrameUrl != null && !this.firstFrameUrl.isEmpty()) {
            jsonObject.addProperty("first_frame_url", this.firstFrameUrl);
        }
        if (this.lastFrameUrl != null && !this.lastFrameUrl.isEmpty()) {
            jsonObject.addProperty("last_frame_url", this.lastFrameUrl);
        }
        if (this.headFrame != null && !this.headFrame.isEmpty()) {
            jsonObject.addProperty("head_frame", this.headFrame);
        }
        if (this.tailFrame != null && !this.tailFrame.isEmpty()) {
            jsonObject.addProperty("tail_frame", this.tailFrame);
        }
        if (this.extraInputs != null && !this.extraInputs.isEmpty()) {
            JsonObject extraInputsJsonObject = JsonUtils.parametersToJsonObject(this.extraInputs);
            JsonUtils.merge(jsonObject, extraInputsJsonObject);
        }
        return jsonObject;
    }

    @Override
    public Map<String, Object> getParameters() {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("duration", this.duration);
        params.put("size", this.size);
        params.put("resolution", this.resolution);
        params.put("with_audio", this.withAudio);
        if (this.steps != null) {
            params.put("steps", this.steps);
        }
        if (this.seed != null) {
            params.put("seed", this.seed);
        }
        params.putAll(super.getParameters());
        return params;
    }

    @Override
    public JsonObject getHttpBody() {
        JsonObject body = new JsonObject();
        body.addProperty("model", this.getModel());
        body.add("input", (JsonElement)this.getInput());
        Map<String, Object> params = this.getParameters();
        if (params != null) {
            body.add("parameters", (JsonElement)JsonUtils.parametersToJsonObject(params));
        }
        return body;
    }

    @Override
    public ByteBuffer getBinaryData() {
        throw new UnsupportedOperationException("Unimplemented method 'getBinaryData'");
    }

    @Override
    public void validate() throws InputRequiredException {
    }

    public void checkAndUpload() throws NoApiKeyException, UploadFileException {
        HashMap<String, String> inputChecks = new HashMap<String, String>();
        inputChecks.put("img_url", this.imgUrl);
        inputChecks.put("first_frame_url", this.firstFrameUrl);
        inputChecks.put("last_frame_url", this.lastFrameUrl);
        inputChecks.put("head_frame", this.headFrame);
        inputChecks.put("tail_frame", this.tailFrame);
        boolean isUpload = PreprocessInputImage.checkAndUploadImage(this.getModel(), inputChecks, this.getApiKey());
        if (isUpload) {
            this.putHeader("X-DashScope-OssResourceResolve", "enable");
            this.imgUrl = (String)inputChecks.get("img_url");
            this.firstFrameUrl = (String)inputChecks.get("first_frame_url");
            this.lastFrameUrl = (String)inputChecks.get("last_frame_url");
            this.headFrame = (String)inputChecks.get("head_frame");
            this.tailFrame = (String)inputChecks.get("tail_frame");
        }
    }

    private static Map<String, String> $default$inputChecks() {
        return new HashMap<String, String>();
    }

    private static String $default$size() {
        return "1280*720";
    }

    private static Integer $default$steps() {
        return null;
    }

    private static Integer $default$seed() {
        return null;
    }

    private static String $default$prompt() {
        return null;
    }

    private static String $default$negative_prompt() {
        return null;
    }

    private static String $default$negativePrompt() {
        return null;
    }

    private static String $default$template() {
        return null;
    }

    private static Boolean $default$extendPrompt() {
        return Boolean.TRUE;
    }

    private static String $default$imgUrl() {
        return null;
    }

    private static Integer $default$duration() {
        return 5;
    }

    private static String $default$firstFrameUrl() {
        return null;
    }

    private static String $default$lastFrameUrl() {
        return null;
    }

    private static String $default$headFrame() {
        return null;
    }

    private static String $default$tailFrame() {
        return null;
    }

    private static Boolean $default$withAudio() {
        return Boolean.FALSE;
    }

    private static String $default$resolution() {
        return "720P";
    }

    protected VideoSynthesisParam(VideoSynthesisParamBuilder<?, ?> b) {
        super((HalfDuplexServiceParam.HalfDuplexServiceParamBuilder<?, ?>)b);
        Map<Object, Object> extraInputs;
        this.inputChecks = ((VideoSynthesisParamBuilder)b).inputChecks$set ? ((VideoSynthesisParamBuilder)b).inputChecks$value : VideoSynthesisParam.$default$inputChecks();
        this.size = ((VideoSynthesisParamBuilder)b).size$set ? ((VideoSynthesisParamBuilder)b).size$value : VideoSynthesisParam.$default$size();
        this.steps = ((VideoSynthesisParamBuilder)b).steps$set ? ((VideoSynthesisParamBuilder)b).steps$value : VideoSynthesisParam.$default$steps();
        this.seed = ((VideoSynthesisParamBuilder)b).seed$set ? ((VideoSynthesisParamBuilder)b).seed$value : VideoSynthesisParam.$default$seed();
        this.prompt = ((VideoSynthesisParamBuilder)b).prompt$set ? ((VideoSynthesisParamBuilder)b).prompt$value : VideoSynthesisParam.$default$prompt();
        this.negative_prompt = ((VideoSynthesisParamBuilder)b).negative_prompt$set ? ((VideoSynthesisParamBuilder)b).negative_prompt$value : VideoSynthesisParam.$default$negative_prompt();
        this.negativePrompt = ((VideoSynthesisParamBuilder)b).negativePrompt$set ? ((VideoSynthesisParamBuilder)b).negativePrompt$value : VideoSynthesisParam.$default$negativePrompt();
        this.template = ((VideoSynthesisParamBuilder)b).template$set ? ((VideoSynthesisParamBuilder)b).template$value : VideoSynthesisParam.$default$template();
        this.extendPrompt = ((VideoSynthesisParamBuilder)b).extendPrompt$set ? ((VideoSynthesisParamBuilder)b).extendPrompt$value : VideoSynthesisParam.$default$extendPrompt();
        this.imgUrl = ((VideoSynthesisParamBuilder)b).imgUrl$set ? ((VideoSynthesisParamBuilder)b).imgUrl$value : VideoSynthesisParam.$default$imgUrl();
        switch (((VideoSynthesisParamBuilder)b).extraInputs$key == null ? 0 : ((VideoSynthesisParamBuilder)b).extraInputs$key.size()) {
            case 0: {
                extraInputs = Collections.emptyMap();
                break;
            }
            case 1: {
                extraInputs = Collections.singletonMap(((VideoSynthesisParamBuilder)b).extraInputs$key.get(0), ((VideoSynthesisParamBuilder)b).extraInputs$value.get(0));
                break;
            }
            default: {
                extraInputs = new LinkedHashMap(((VideoSynthesisParamBuilder)b).extraInputs$key.size() < 0x40000000 ? 1 + ((VideoSynthesisParamBuilder)b).extraInputs$key.size() + (((VideoSynthesisParamBuilder)b).extraInputs$key.size() - 3) / 3 : Integer.MAX_VALUE);
                for (int $i = 0; $i < ((VideoSynthesisParamBuilder)b).extraInputs$key.size(); ++$i) {
                    extraInputs.put(((VideoSynthesisParamBuilder)b).extraInputs$key.get($i), ((VideoSynthesisParamBuilder)b).extraInputs$value.get($i));
                }
                extraInputs = Collections.unmodifiableMap(extraInputs);
            }
        }
        this.extraInputs = extraInputs;
        this.duration = ((VideoSynthesisParamBuilder)b).duration$set ? ((VideoSynthesisParamBuilder)b).duration$value : VideoSynthesisParam.$default$duration();
        this.firstFrameUrl = ((VideoSynthesisParamBuilder)b).firstFrameUrl$set ? ((VideoSynthesisParamBuilder)b).firstFrameUrl$value : VideoSynthesisParam.$default$firstFrameUrl();
        this.lastFrameUrl = ((VideoSynthesisParamBuilder)b).lastFrameUrl$set ? ((VideoSynthesisParamBuilder)b).lastFrameUrl$value : VideoSynthesisParam.$default$lastFrameUrl();
        this.headFrame = ((VideoSynthesisParamBuilder)b).headFrame$set ? ((VideoSynthesisParamBuilder)b).headFrame$value : VideoSynthesisParam.$default$headFrame();
        this.tailFrame = ((VideoSynthesisParamBuilder)b).tailFrame$set ? ((VideoSynthesisParamBuilder)b).tailFrame$value : VideoSynthesisParam.$default$tailFrame();
        this.withAudio = ((VideoSynthesisParamBuilder)b).withAudio$set ? ((VideoSynthesisParamBuilder)b).withAudio$value : VideoSynthesisParam.$default$withAudio();
        this.resolution = ((VideoSynthesisParamBuilder)b).resolution$set ? ((VideoSynthesisParamBuilder)b).resolution$value : VideoSynthesisParam.$default$resolution();
    }

    public static VideoSynthesisParamBuilder<?, ?> builder() {
        return new VideoSynthesisParamBuilderImpl();
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof VideoSynthesisParam)) {
            return false;
        }
        VideoSynthesisParam other = (VideoSynthesisParam)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        Integer this$steps = this.getSteps();
        Integer other$steps = other.getSteps();
        if (this$steps == null ? other$steps != null : !((Object)this$steps).equals(other$steps)) {
            return false;
        }
        Integer this$seed = this.getSeed();
        Integer other$seed = other.getSeed();
        if (this$seed == null ? other$seed != null : !((Object)this$seed).equals(other$seed)) {
            return false;
        }
        Boolean this$extendPrompt = this.getExtendPrompt();
        Boolean other$extendPrompt = other.getExtendPrompt();
        if (this$extendPrompt == null ? other$extendPrompt != null : !((Object)this$extendPrompt).equals(other$extendPrompt)) {
            return false;
        }
        Integer this$duration = this.getDuration();
        Integer other$duration = other.getDuration();
        if (this$duration == null ? other$duration != null : !((Object)this$duration).equals(other$duration)) {
            return false;
        }
        Boolean this$withAudio = this.getWithAudio();
        Boolean other$withAudio = other.getWithAudio();
        if (this$withAudio == null ? other$withAudio != null : !((Object)this$withAudio).equals(other$withAudio)) {
            return false;
        }
        Map<String, String> this$inputChecks = this.getInputChecks();
        Map<String, String> other$inputChecks = other.getInputChecks();
        if (this$inputChecks == null ? other$inputChecks != null : !((Object)this$inputChecks).equals(other$inputChecks)) {
            return false;
        }
        String this$size = this.getSize();
        String other$size = other.getSize();
        if (this$size == null ? other$size != null : !this$size.equals(other$size)) {
            return false;
        }
        String this$prompt = this.getPrompt();
        String other$prompt = other.getPrompt();
        if (this$prompt == null ? other$prompt != null : !this$prompt.equals(other$prompt)) {
            return false;
        }
        String this$negative_prompt = this.getNegative_prompt();
        String other$negative_prompt = other.getNegative_prompt();
        if (this$negative_prompt == null ? other$negative_prompt != null : !this$negative_prompt.equals(other$negative_prompt)) {
            return false;
        }
        String this$negativePrompt = this.getNegativePrompt();
        String other$negativePrompt = other.getNegativePrompt();
        if (this$negativePrompt == null ? other$negativePrompt != null : !this$negativePrompt.equals(other$negativePrompt)) {
            return false;
        }
        String this$template = this.getTemplate();
        String other$template = other.getTemplate();
        if (this$template == null ? other$template != null : !this$template.equals(other$template)) {
            return false;
        }
        String this$imgUrl = this.getImgUrl();
        String other$imgUrl = other.getImgUrl();
        if (this$imgUrl == null ? other$imgUrl != null : !this$imgUrl.equals(other$imgUrl)) {
            return false;
        }
        Map<String, Object> this$extraInputs = this.getExtraInputs();
        Map<String, Object> other$extraInputs = other.getExtraInputs();
        if (this$extraInputs == null ? other$extraInputs != null : !((Object)this$extraInputs).equals(other$extraInputs)) {
            return false;
        }
        String this$firstFrameUrl = this.getFirstFrameUrl();
        String other$firstFrameUrl = other.getFirstFrameUrl();
        if (this$firstFrameUrl == null ? other$firstFrameUrl != null : !this$firstFrameUrl.equals(other$firstFrameUrl)) {
            return false;
        }
        String this$lastFrameUrl = this.getLastFrameUrl();
        String other$lastFrameUrl = other.getLastFrameUrl();
        if (this$lastFrameUrl == null ? other$lastFrameUrl != null : !this$lastFrameUrl.equals(other$lastFrameUrl)) {
            return false;
        }
        String this$headFrame = this.getHeadFrame();
        String other$headFrame = other.getHeadFrame();
        if (this$headFrame == null ? other$headFrame != null : !this$headFrame.equals(other$headFrame)) {
            return false;
        }
        String this$tailFrame = this.getTailFrame();
        String other$tailFrame = other.getTailFrame();
        if (this$tailFrame == null ? other$tailFrame != null : !this$tailFrame.equals(other$tailFrame)) {
            return false;
        }
        String this$resolution = this.getResolution();
        String other$resolution = other.getResolution();
        return !(this$resolution == null ? other$resolution != null : !this$resolution.equals(other$resolution));
    }

    @Override
    protected boolean canEqual(Object other) {
        return other instanceof VideoSynthesisParam;
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        Integer $steps = this.getSteps();
        result = result * 59 + ($steps == null ? 43 : ((Object)$steps).hashCode());
        Integer $seed = this.getSeed();
        result = result * 59 + ($seed == null ? 43 : ((Object)$seed).hashCode());
        Boolean $extendPrompt = this.getExtendPrompt();
        result = result * 59 + ($extendPrompt == null ? 43 : ((Object)$extendPrompt).hashCode());
        Integer $duration = this.getDuration();
        result = result * 59 + ($duration == null ? 43 : ((Object)$duration).hashCode());
        Boolean $withAudio = this.getWithAudio();
        result = result * 59 + ($withAudio == null ? 43 : ((Object)$withAudio).hashCode());
        Map<String, String> $inputChecks = this.getInputChecks();
        result = result * 59 + ($inputChecks == null ? 43 : ((Object)$inputChecks).hashCode());
        String $size = this.getSize();
        result = result * 59 + ($size == null ? 43 : $size.hashCode());
        String $prompt = this.getPrompt();
        result = result * 59 + ($prompt == null ? 43 : $prompt.hashCode());
        String $negative_prompt = this.getNegative_prompt();
        result = result * 59 + ($negative_prompt == null ? 43 : $negative_prompt.hashCode());
        String $negativePrompt = this.getNegativePrompt();
        result = result * 59 + ($negativePrompt == null ? 43 : $negativePrompt.hashCode());
        String $template = this.getTemplate();
        result = result * 59 + ($template == null ? 43 : $template.hashCode());
        String $imgUrl = this.getImgUrl();
        result = result * 59 + ($imgUrl == null ? 43 : $imgUrl.hashCode());
        Map<String, Object> $extraInputs = this.getExtraInputs();
        result = result * 59 + ($extraInputs == null ? 43 : ((Object)$extraInputs).hashCode());
        String $firstFrameUrl = this.getFirstFrameUrl();
        result = result * 59 + ($firstFrameUrl == null ? 43 : $firstFrameUrl.hashCode());
        String $lastFrameUrl = this.getLastFrameUrl();
        result = result * 59 + ($lastFrameUrl == null ? 43 : $lastFrameUrl.hashCode());
        String $headFrame = this.getHeadFrame();
        result = result * 59 + ($headFrame == null ? 43 : $headFrame.hashCode());
        String $tailFrame = this.getTailFrame();
        result = result * 59 + ($tailFrame == null ? 43 : $tailFrame.hashCode());
        String $resolution = this.getResolution();
        result = result * 59 + ($resolution == null ? 43 : $resolution.hashCode());
        return result;
    }

    public Map<String, String> getInputChecks() {
        return this.inputChecks;
    }

    public String getSize() {
        return this.size;
    }

    public Integer getSteps() {
        return this.steps;
    }

    public Integer getSeed() {
        return this.seed;
    }

    public String getPrompt() {
        return this.prompt;
    }

    @Deprecated
    public String getNegative_prompt() {
        return this.negative_prompt;
    }

    public String getNegativePrompt() {
        return this.negativePrompt;
    }

    public String getTemplate() {
        return this.template;
    }

    @Deprecated
    public Boolean getExtendPrompt() {
        return this.extendPrompt;
    }

    public String getImgUrl() {
        return this.imgUrl;
    }

    public Map<String, Object> getExtraInputs() {
        return this.extraInputs;
    }

    public Integer getDuration() {
        return this.duration;
    }

    public String getFirstFrameUrl() {
        return this.firstFrameUrl;
    }

    public String getLastFrameUrl() {
        return this.lastFrameUrl;
    }

    public String getHeadFrame() {
        return this.headFrame;
    }

    public String getTailFrame() {
        return this.tailFrame;
    }

    public Boolean getWithAudio() {
        return this.withAudio;
    }

    public String getResolution() {
        return this.resolution;
    }

    public void setInputChecks(Map<String, String> inputChecks) {
        this.inputChecks = inputChecks;
    }

    public void setSize(String size) {
        this.size = size;
    }

    public void setSteps(Integer steps) {
        this.steps = steps;
    }

    public void setSeed(Integer seed) {
        this.seed = seed;
    }

    public void setPrompt(String prompt) {
        this.prompt = prompt;
    }

    @Deprecated
    public void setNegative_prompt(String negative_prompt) {
        this.negative_prompt = negative_prompt;
    }

    public void setNegativePrompt(String negativePrompt) {
        this.negativePrompt = negativePrompt;
    }

    public void setTemplate(String template) {
        this.template = template;
    }

    @Deprecated
    public void setExtendPrompt(Boolean extendPrompt) {
        this.extendPrompt = extendPrompt;
    }

    public void setImgUrl(String imgUrl) {
        this.imgUrl = imgUrl;
    }

    public void setExtraInputs(Map<String, Object> extraInputs) {
        this.extraInputs = extraInputs;
    }

    public void setDuration(Integer duration) {
        this.duration = duration;
    }

    public void setFirstFrameUrl(String firstFrameUrl) {
        this.firstFrameUrl = firstFrameUrl;
    }

    public void setLastFrameUrl(String lastFrameUrl) {
        this.lastFrameUrl = lastFrameUrl;
    }

    public void setHeadFrame(String headFrame) {
        this.headFrame = headFrame;
    }

    public void setTailFrame(String tailFrame) {
        this.tailFrame = tailFrame;
    }

    public void setWithAudio(Boolean withAudio) {
        this.withAudio = withAudio;
    }

    public void setResolution(String resolution) {
        this.resolution = resolution;
    }

    @Override
    public String toString() {
        return "VideoSynthesisParam(inputChecks=" + this.getInputChecks() + ", size=" + this.getSize() + ", steps=" + this.getSteps() + ", seed=" + this.getSeed() + ", prompt=" + this.getPrompt() + ", negative_prompt=" + this.getNegative_prompt() + ", negativePrompt=" + this.getNegativePrompt() + ", template=" + this.getTemplate() + ", extendPrompt=" + this.getExtendPrompt() + ", imgUrl=" + this.getImgUrl() + ", extraInputs=" + this.getExtraInputs() + ", duration=" + this.getDuration() + ", firstFrameUrl=" + this.getFirstFrameUrl() + ", lastFrameUrl=" + this.getLastFrameUrl() + ", headFrame=" + this.getHeadFrame() + ", tailFrame=" + this.getTailFrame() + ", withAudio=" + this.getWithAudio() + ", resolution=" + this.getResolution() + ")";
    }

    private static final class VideoSynthesisParamBuilderImpl
    extends VideoSynthesisParamBuilder<VideoSynthesisParam, VideoSynthesisParamBuilderImpl> {
        private VideoSynthesisParamBuilderImpl() {
        }

        @Override
        protected VideoSynthesisParamBuilderImpl self() {
            return this;
        }

        @Override
        public VideoSynthesisParam build() {
            return new VideoSynthesisParam(this);
        }
    }

    public static abstract class VideoSynthesisParamBuilder<C extends VideoSynthesisParam, B extends VideoSynthesisParamBuilder<C, B>>
    extends HalfDuplexServiceParam.HalfDuplexServiceParamBuilder<C, B> {
        private boolean inputChecks$set;
        private Map<String, String> inputChecks$value;
        private boolean size$set;
        private String size$value;
        private boolean steps$set;
        private Integer steps$value;
        private boolean seed$set;
        private Integer seed$value;
        private boolean prompt$set;
        private String prompt$value;
        private boolean negative_prompt$set;
        private String negative_prompt$value;
        private boolean negativePrompt$set;
        private String negativePrompt$value;
        private boolean template$set;
        private String template$value;
        private boolean extendPrompt$set;
        private Boolean extendPrompt$value;
        private boolean imgUrl$set;
        private String imgUrl$value;
        private ArrayList<String> extraInputs$key;
        private ArrayList<Object> extraInputs$value;
        private boolean duration$set;
        private Integer duration$value;
        private boolean firstFrameUrl$set;
        private String firstFrameUrl$value;
        private boolean lastFrameUrl$set;
        private String lastFrameUrl$value;
        private boolean headFrame$set;
        private String headFrame$value;
        private boolean tailFrame$set;
        private String tailFrame$value;
        private boolean withAudio$set;
        private Boolean withAudio$value;
        private boolean resolution$set;
        private String resolution$value;

        public B inputChecks(Map<String, String> inputChecks) {
            this.inputChecks$value = inputChecks;
            this.inputChecks$set = true;
            return (B)this.self();
        }

        public B size(String size) {
            this.size$value = size;
            this.size$set = true;
            return (B)this.self();
        }

        public B steps(Integer steps) {
            this.steps$value = steps;
            this.steps$set = true;
            return (B)this.self();
        }

        public B seed(Integer seed) {
            this.seed$value = seed;
            this.seed$set = true;
            return (B)this.self();
        }

        public B prompt(String prompt) {
            this.prompt$value = prompt;
            this.prompt$set = true;
            return (B)this.self();
        }

        @Deprecated
        public B negative_prompt(String negative_prompt) {
            this.negative_prompt$value = negative_prompt;
            this.negative_prompt$set = true;
            return (B)this.self();
        }

        public B negativePrompt(String negativePrompt) {
            this.negativePrompt$value = negativePrompt;
            this.negativePrompt$set = true;
            return (B)this.self();
        }

        public B template(String template) {
            this.template$value = template;
            this.template$set = true;
            return (B)this.self();
        }

        @Deprecated
        public B extendPrompt(Boolean extendPrompt) {
            this.extendPrompt$value = extendPrompt;
            this.extendPrompt$set = true;
            return (B)this.self();
        }

        public B imgUrl(String imgUrl) {
            this.imgUrl$value = imgUrl;
            this.imgUrl$set = true;
            return (B)this.self();
        }

        public B extraInput(String extraInputKey, Object extraInputValue) {
            if (this.extraInputs$key == null) {
                this.extraInputs$key = new ArrayList();
                this.extraInputs$value = new ArrayList();
            }
            this.extraInputs$key.add(extraInputKey);
            this.extraInputs$value.add(extraInputValue);
            return (B)this.self();
        }

        public B extraInputs(Map<? extends String, ? extends Object> extraInputs) {
            if (extraInputs == null) {
                throw new NullPointerException("extraInputs cannot be null");
            }
            if (this.extraInputs$key == null) {
                this.extraInputs$key = new ArrayList();
                this.extraInputs$value = new ArrayList();
            }
            for (Map.Entry<? extends String, ? extends Object> $lombokEntry : extraInputs.entrySet()) {
                this.extraInputs$key.add($lombokEntry.getKey());
                this.extraInputs$value.add($lombokEntry.getValue());
            }
            return (B)this.self();
        }

        public B clearExtraInputs() {
            if (this.extraInputs$key != null) {
                this.extraInputs$key.clear();
                this.extraInputs$value.clear();
            }
            return (B)this.self();
        }

        public B duration(Integer duration) {
            this.duration$value = duration;
            this.duration$set = true;
            return (B)this.self();
        }

        public B firstFrameUrl(String firstFrameUrl) {
            this.firstFrameUrl$value = firstFrameUrl;
            this.firstFrameUrl$set = true;
            return (B)this.self();
        }

        public B lastFrameUrl(String lastFrameUrl) {
            this.lastFrameUrl$value = lastFrameUrl;
            this.lastFrameUrl$set = true;
            return (B)this.self();
        }

        public B headFrame(String headFrame) {
            this.headFrame$value = headFrame;
            this.headFrame$set = true;
            return (B)this.self();
        }

        public B tailFrame(String tailFrame) {
            this.tailFrame$value = tailFrame;
            this.tailFrame$set = true;
            return (B)this.self();
        }

        public B withAudio(Boolean withAudio) {
            this.withAudio$value = withAudio;
            this.withAudio$set = true;
            return (B)this.self();
        }

        public B resolution(String resolution) {
            this.resolution$value = resolution;
            this.resolution$set = true;
            return (B)this.self();
        }

        @Override
        protected abstract B self();

        @Override
        public abstract C build();

        @Override
        public String toString() {
            return "VideoSynthesisParam.VideoSynthesisParamBuilder(super=" + super.toString() + ", inputChecks$value=" + this.inputChecks$value + ", size$value=" + this.size$value + ", steps$value=" + this.steps$value + ", seed$value=" + this.seed$value + ", prompt$value=" + this.prompt$value + ", negative_prompt$value=" + this.negative_prompt$value + ", negativePrompt$value=" + this.negativePrompt$value + ", template$value=" + this.template$value + ", extendPrompt$value=" + this.extendPrompt$value + ", imgUrl$value=" + this.imgUrl$value + ", extraInputs$key=" + this.extraInputs$key + ", extraInputs$value=" + this.extraInputs$value + ", duration$value=" + this.duration$value + ", firstFrameUrl$value=" + this.firstFrameUrl$value + ", lastFrameUrl$value=" + this.lastFrameUrl$value + ", headFrame$value=" + this.headFrame$value + ", tailFrame$value=" + this.tailFrame$value + ", withAudio$value=" + this.withAudio$value + ", resolution$value=" + this.resolution$value + ")";
        }
    }
}

