/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.druid.sql.parser;

import com.alibaba.druid.sql.parser.Lexer;
import com.alibaba.druid.sql.parser.ParserException;
import com.alibaba.druid.sql.parser.SQLParserFeature;
import com.alibaba.druid.sql.parser.Token;

public class SQLParser {
    protected final Lexer lexer;
    protected String dbType;
    private int errorEndPos = -1;

    public SQLParser(String sql, String dbType) {
        this(new Lexer(sql, null, dbType), dbType);
        this.lexer.nextToken();
    }

    public SQLParser(String sql) {
        this(sql, null);
    }

    public SQLParser(Lexer lexer) {
        this(lexer, null);
    }

    public SQLParser(Lexer lexer, String dbType) {
        this.lexer = lexer;
        this.dbType = dbType;
    }

    public final Lexer getLexer() {
        return this.lexer;
    }

    public String getDbType() {
        return this.dbType;
    }

    protected boolean identifierEquals(String text) {
        return this.lexer.identifierEquals(text);
    }

    protected void acceptIdentifier(String text) {
        if (!this.lexer.identifierEquals(text)) {
            this.setErrorEndPos(this.lexer.pos());
            throw new ParserException("syntax error, expect " + text + ", actual " + (Object)((Object)this.lexer.token) + ", " + this.lexer.info());
        }
        this.lexer.nextToken();
    }

    protected String tableAlias() {
        return this.tableAlias(false);
    }

    protected String tableAlias(boolean must) {
        String ident;
        Token token = this.lexer.token;
        if (token == Token.CONNECT || token == Token.START || token == Token.SELECT || token == Token.FROM || token == Token.WHERE) {
            if (must) {
                throw new ParserException("illegal alias. " + this.lexer.info());
            }
            return null;
        }
        if (token == Token.IDENTIFIER && ((ident = this.lexer.stringVal).equalsIgnoreCase("START") || ident.equalsIgnoreCase("CONNECT"))) {
            if (must) {
                throw new ParserException("illegal alias. " + this.lexer.info());
            }
            return null;
        }
        return this.as();
    }

    protected String as() {
        String alias = null;
        Token token = this.lexer.token;
        if (token == Token.COMMA) {
            return null;
        }
        if (token == Token.AS) {
            this.lexer.nextToken();
            alias = this.alias();
            if (alias != null) {
                while (this.lexer.token == Token.DOT) {
                    this.lexer.nextToken();
                    alias = alias + '.' + this.lexer.token.name();
                    this.lexer.nextToken();
                }
                return alias;
            }
            if (this.lexer.token == Token.LPAREN) {
                return null;
            }
            throw new ParserException("Error : " + this.lexer.info());
        }
        if (this.lexer.token == Token.LITERAL_ALIAS) {
            alias = this.lexer.stringVal();
            this.lexer.nextToken();
        } else if (this.lexer.token == Token.IDENTIFIER) {
            alias = this.lexer.stringVal();
            this.lexer.nextToken();
        } else if (this.lexer.token == Token.LITERAL_CHARS) {
            alias = "'" + this.lexer.stringVal() + "'";
            this.lexer.nextToken();
        } else {
            switch (this.lexer.token) {
                case CASE: 
                case USER: 
                case LOB: 
                case END: 
                case DEFERRED: 
                case OUTER: 
                case DO: 
                case STORE: {
                    alias = this.lexer.stringVal();
                    this.lexer.nextToken();
                    break;
                }
            }
        }
        switch (this.lexer.token) {
            case KEY: 
            case INTERVAL: 
            case CONSTRAINT: {
                alias = this.lexer.token.name();
                this.lexer.nextToken();
                return alias;
            }
        }
        return alias;
    }

    protected String alias() {
        String alias = null;
        if (this.lexer.token == Token.LITERAL_ALIAS) {
            alias = this.lexer.stringVal();
            this.lexer.nextToken();
        } else if (this.lexer.token == Token.IDENTIFIER) {
            alias = this.lexer.stringVal();
            this.lexer.nextToken();
        } else if (this.lexer.token == Token.LITERAL_CHARS) {
            alias = "'" + this.lexer.stringVal() + "'";
            this.lexer.nextToken();
        } else {
            switch (this.lexer.token) {
                case CASE: 
                case USER: 
                case LOB: 
                case END: 
                case DEFERRED: 
                case STORE: 
                case KEY: 
                case INTERVAL: 
                case INDEX: 
                case MODEL: 
                case PCTFREE: 
                case INITRANS: 
                case MAXTRANS: 
                case SEGMENT: 
                case CREATION: 
                case IMMEDIATE: 
                case STORAGE: 
                case NEXT: 
                case MINEXTENTS: 
                case MAXEXTENTS: 
                case MAXSIZE: 
                case PCTINCREASE: 
                case FLASH_CACHE: 
                case CELL_FLASH_CACHE: 
                case NONE: 
                case ROW: 
                case CHUNK: 
                case CACHE: 
                case NOCACHE: 
                case LOGGING: 
                case NOCOMPRESS: 
                case KEEP_DUPLICATES: 
                case EXCEPTIONS: 
                case PURGE: 
                case INITIALLY: 
                case COMMENT: 
                case ENABLE: 
                case DISABLE: 
                case SEQUENCE: 
                case ANALYZE: 
                case OPTIMIZE: 
                case GRANT: 
                case REVOKE: 
                case FULL: 
                case TO: 
                case NEW: 
                case LOCK: 
                case LIMIT: 
                case IDENTIFIED: 
                case PASSWORD: 
                case BINARY: 
                case WINDOW: 
                case OFFSET: 
                case SHARE: 
                case START: 
                case CONNECT: 
                case MATCHED: 
                case ERRORS: 
                case REJECT: 
                case UNLIMITED: 
                case BEGIN: 
                case EXCLUSIVE: 
                case MODE: 
                case ADVISE: 
                case TYPE: 
                case CLOSE: 
                case OPEN: {
                    alias = this.lexer.stringVal();
                    this.lexer.nextToken();
                    return alias;
                }
                case QUES: {
                    alias = "?";
                    this.lexer.nextToken();
                }
            }
        }
        return alias;
    }

    protected void printError(Token token) {
        String arround = this.lexer.mark >= 0 && this.lexer.text.length() > this.lexer.mark + 30 ? (this.lexer.mark - 5 > 0 ? this.lexer.text.substring(this.lexer.mark - 5, this.lexer.mark + 30) : this.lexer.text.substring(this.lexer.mark, this.lexer.mark + 30)) : (this.lexer.mark >= 0 ? (this.lexer.mark - 5 > 0 ? this.lexer.text.substring(this.lexer.mark - 5) : this.lexer.text.substring(this.lexer.mark)) : this.lexer.text);
        throw new ParserException("syntax error, error in :'" + arround + "', expect " + (Object)((Object)token) + ", actual " + (Object)((Object)this.lexer.token) + " " + this.lexer.info());
    }

    public void accept(Token token) {
        if (this.lexer.token == token) {
            this.lexer.nextToken();
        } else {
            this.setErrorEndPos(this.lexer.pos());
            this.printError(token);
        }
    }

    public int acceptInteger() {
        if (this.lexer.token == Token.LITERAL_INT) {
            int intVal = (Integer)this.lexer.integerValue();
            this.lexer.nextToken();
            return intVal;
        }
        throw new ParserException("syntax error, expect int, actual " + (Object)((Object)this.lexer.token) + " " + this.lexer.info());
    }

    public void match(Token token) {
        if (this.lexer.token != token) {
            throw new ParserException("syntax error, expect " + (Object)((Object)token) + ", actual " + (Object)((Object)this.lexer.token) + " " + this.lexer.info());
        }
    }

    protected void setErrorEndPos(int errPos) {
        if (errPos > this.errorEndPos) {
            this.errorEndPos = errPos;
        }
    }

    public void config(SQLParserFeature feature, boolean state) {
        this.lexer.config(feature, state);
    }

    public final boolean isEnabled(SQLParserFeature feature) {
        return this.lexer.isEnabled(feature);
    }
}

