/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.druid.sql.ast.expr;

import com.alibaba.druid.sql.ast.SQLDataType;
import com.alibaba.druid.sql.ast.SQLDataTypeImpl;
import com.alibaba.druid.sql.ast.SQLExpr;
import com.alibaba.druid.sql.ast.SQLObject;
import com.alibaba.druid.sql.ast.expr.SQLIntegerExpr;
import com.alibaba.druid.sql.ast.expr.SQLNumericLiteralExpr;
import com.alibaba.druid.sql.ast.expr.SQLValuableExpr;
import com.alibaba.druid.sql.visitor.SQLASTVisitor;
import com.alibaba.druid.util.Utils;
import java.math.BigDecimal;

public class SQLNumberExpr
extends SQLNumericLiteralExpr
implements SQLValuableExpr {
    public static final SQLDataType DATA_TYPE_NUMBER = new SQLDataTypeImpl("number");
    public static final SQLDataType DATA_TYPE_DOUBLE = new SQLDataTypeImpl("double");
    public static final SQLDataType DATA_TYPE_BIGINT = SQLIntegerExpr.DATA_TYPE;
    private char[] chars;

    public SQLNumberExpr() {
        super(new SQLDataTypeImpl("NUMBER"));
    }

    public SQLNumberExpr(Number number) {
        this();
        this.value = number;
    }

    public SQLNumberExpr(char[] chars, SQLObject parent) {
        this();
        this.chars = chars;
        this.parent = parent;
    }

    public SQLNumberExpr(char[] chars) {
        this();
        this.chars = chars;
    }

    @Override
    public Number getNumber() {
        if (this.chars != null && this.value == null) {
            boolean exp = false;
            for (int i = 0; i < this.chars.length; ++i) {
                char ch = this.chars[i];
                if (ch != 'e' && ch != 'E') continue;
                exp = true;
            }
            this.value = exp ? Double.valueOf(Double.parseDouble(new String(this.chars))) : new BigDecimal(this.chars);
        }
        return this.getValue();
    }

    @Override
    public Number getValue() {
        return (Number)this.value;
    }

    @Override
    public void setNumber(Number number) {
        this.value = number;
        this.chars = null;
    }

    @Override
    public void output(StringBuilder buf) {
        if (this.chars != null) {
            buf.append(this.chars);
        } else {
            buf.append(this.value.toString());
        }
    }

    @Override
    protected void accept0(SQLASTVisitor visitor) {
        visitor.visit(this);
        visitor.endVisit(this);
    }

    @Override
    public int hashCode() {
        Number number = this.getNumber();
        if (number == null) {
            return 0;
        }
        return number.hashCode();
    }

    @Override
    public boolean equals(Object obj) {
        if (this.chars != null && this.value == null) {
            this.value = new BigDecimal(this.chars);
        }
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        SQLNumberExpr other = (SQLNumberExpr)obj;
        return Utils.equals(this.getNumber(), other.getNumber());
    }

    @Override
    public SQLNumberExpr clone() {
        SQLNumberExpr x = new SQLNumberExpr();
        x.chars = this.chars;
        x.value = this.value;
        return x;
    }

    @Override
    public SQLDataType computeDataType() {
        return DATA_TYPE_NUMBER;
    }

    public static boolean isZero(SQLExpr x) {
        if (x instanceof SQLNumberExpr) {
            Number number = ((SQLNumberExpr)x).getNumber();
            if (number instanceof Integer) {
                return number.intValue() == 0;
            }
            if (number instanceof Long) {
                return number.longValue() == 0L;
            }
        }
        return false;
    }

    public static boolean isOne(SQLExpr x) {
        if (x instanceof SQLNumberExpr) {
            Number number = ((SQLNumberExpr)x).getNumber();
            if (number instanceof Integer) {
                return number.intValue() == 1;
            }
            if (number instanceof Long) {
                return number.longValue() == 1L;
            }
        }
        return false;
    }
}

