/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.druid.sql.dialect.spark.visitor;

import com.alibaba.druid.DbType;
import com.alibaba.druid.sql.ast.SQLExpr;
import com.alibaba.druid.sql.ast.SQLObject;
import com.alibaba.druid.sql.ast.expr.SQLHexExpr;
import com.alibaba.druid.sql.ast.statement.SQLCreateTableStatement;
import com.alibaba.druid.sql.ast.statement.SQLSelect;
import com.alibaba.druid.sql.dialect.hive.visitor.HiveOutputVisitor;
import com.alibaba.druid.sql.dialect.spark.ast.SparkCreateTableStatement;
import com.alibaba.druid.sql.dialect.spark.ast.stmt.SparkCacheTableStatement;
import com.alibaba.druid.sql.dialect.spark.ast.stmt.SparkCreateScanStatement;
import com.alibaba.druid.sql.dialect.spark.visitor.SparkASTVisitor;
import com.alibaba.druid.sql.visitor.ExportParameterVisitorUtils;
import java.util.List;
import java.util.Map;

public class SparkOutputASTVisitor
extends HiveOutputVisitor
implements SparkASTVisitor {
    public SparkOutputASTVisitor(StringBuilder appender, DbType dbType) {
        super(appender, dbType);
    }

    public SparkOutputASTVisitor(StringBuilder appender) {
        super(appender);
    }

    @Override
    public boolean visit(SQLCreateTableStatement x) {
        if (x instanceof SparkCreateTableStatement) {
            return this.visit((SparkCreateTableStatement)x);
        }
        return super.visit(x);
    }

    @Override
    public boolean visit(SparkCreateTableStatement x) {
        this.print0(this.ucase ? "CREATE " : "create ");
        this.printCreateTableFeatures(x);
        if (x.isIfNotExists()) {
            this.print0(this.ucase ? "TABLE IF NOT EXISTS " : "table if not exists ");
        } else {
            this.print0(this.ucase ? "TABLE " : "table ");
        }
        x.getName().accept(this);
        this.printCreateTableLike(x);
        this.printTableElementsWithComment(x);
        this.printUsing(x);
        this.printComment(x.getComment());
        this.printPartitionedBy(x);
        this.printClusteredBy(x);
        this.printSortedBy(x.getSortedBy());
        this.printIntoBuckets(x.getBuckets());
        this.printStoredAs(x);
        this.printSelectAs(x, true);
        this.printTableOptions(x);
        this.printLocation(x);
        return false;
    }

    protected void printUsing(SparkCreateTableStatement x) {
        if (x.getDatasource() != null) {
            this.println();
            this.print0(this.ucase ? "USING " : "using ");
            this.print0(x.getDatasource().toString());
        }
    }

    protected void printTableOptions(SparkCreateTableStatement x) {
        Map<String, SQLObject> serdeProperties = x.getSerdeProperties();
        if (serdeProperties.size() > 0) {
            this.println();
            this.print0(this.ucase ? "TBLPROPERTIES (" : "tblproperties (");
            String seperator = "";
            for (Map.Entry<String, SQLObject> entry : serdeProperties.entrySet()) {
                this.print0("'" + entry.getKey() + "'='");
                entry.getValue().accept(this);
                this.print0("'" + seperator);
                seperator = ",";
            }
            this.print(')');
        }
    }

    @Override
    public boolean visit(SQLHexExpr x) {
        if (this.parameterized) {
            this.print('?');
            this.incrementReplaceCunt();
            if (this.parameters != null) {
                ExportParameterVisitorUtils.exportParameter((List<Object>)this.parameters, x);
            }
            return false;
        }
        this.print0("x'");
        this.print0(x.getHex());
        this.print('\'');
        return false;
    }

    @Override
    public boolean visit(SparkCreateScanStatement x) {
        SQLExpr using;
        this.print0(this.ucase ? "CREATE " : "create ");
        this.print0(this.ucase ? "SCAN " : "scan ");
        x.getName().accept(this);
        if (x.getOn() != null) {
            this.print0(this.ucase ? " ON " : " on ");
            x.getOn().accept(this);
        }
        if ((using = x.getUsing()) != null) {
            this.println();
            this.print0(this.ucase ? "USING " : "using ");
            this.printExpr(using);
        }
        if (x.getOptions().size() > 0) {
            this.print0(this.ucase ? " OPTIONS (" : " options (");
            this.printAndAccept(x.getOptions(), ", ");
            this.print(')');
        }
        return false;
    }

    @Override
    public boolean visit(SparkCacheTableStatement x) {
        SQLSelect query;
        this.print0(this.ucase ? "CACHE " : "cache ");
        if (x.isLazy()) {
            this.print0(this.ucase ? " LAZY " : " lazy ");
        }
        this.print0(this.ucase ? "TABLE " : "table ");
        x.getName().accept(this);
        if (x.getOptions().size() > 0) {
            this.print0(this.ucase ? " OPTIONS (" : " options (");
            this.printAndAccept(x.getOptions(), ", ");
            this.print(')');
        }
        if (x.isAs()) {
            this.print0(this.ucase ? " AS " : " as ");
        }
        if ((query = x.getQuery()) != null) {
            this.print(' ');
            query.accept(this);
        }
        return false;
    }
}

