/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.druid.sql.dialect.sqlserver.parser;

import com.alibaba.druid.DbType;
import com.alibaba.druid.sql.ast.SQLExpr;
import com.alibaba.druid.sql.ast.SQLName;
import com.alibaba.druid.sql.ast.expr.SQLIdentifierExpr;
import com.alibaba.druid.sql.ast.expr.SQLIntegerExpr;
import com.alibaba.druid.sql.ast.expr.SQLNullExpr;
import com.alibaba.druid.sql.ast.expr.SQLPropertyExpr;
import com.alibaba.druid.sql.ast.expr.SQLSequenceExpr;
import com.alibaba.druid.sql.ast.statement.SQLColumnDefinition;
import com.alibaba.druid.sql.ast.statement.SQLExprTableSource;
import com.alibaba.druid.sql.ast.statement.SQLSelectItem;
import com.alibaba.druid.sql.dialect.sqlserver.ast.SQLServerOutput;
import com.alibaba.druid.sql.dialect.sqlserver.ast.expr.SQLServerObjectReferenceExpr;
import com.alibaba.druid.sql.dialect.sqlserver.parser.SQLServerLexer;
import com.alibaba.druid.sql.dialect.sqlserver.parser.SQLServerSelectParser;
import com.alibaba.druid.sql.parser.Lexer;
import com.alibaba.druid.sql.parser.SQLExprParser;
import com.alibaba.druid.sql.parser.SQLParserFeature;
import com.alibaba.druid.sql.parser.Token;
import com.alibaba.druid.util.FnvHash;
import java.util.Arrays;
import java.util.List;

public class SQLServerExprParser
extends SQLExprParser {
    public static final String[] AGGREGATE_FUNCTIONS;
    public static final long[] AGGREGATE_FUNCTIONS_CODES;

    public SQLServerExprParser(Lexer lexer) {
        super(lexer);
        this.dbType = DbType.sqlserver;
        this.aggregateFunctions = AGGREGATE_FUNCTIONS;
        this.aggregateFunctionHashCodes = AGGREGATE_FUNCTIONS_CODES;
    }

    public SQLServerExprParser(String sql) {
        this(new SQLServerLexer(sql));
        this.lexer.nextToken();
        this.dbType = DbType.sqlserver;
    }

    public SQLServerExprParser(String sql, SQLParserFeature ... features) {
        this(new SQLServerLexer(sql, features));
        this.lexer.nextToken();
        this.dbType = DbType.sqlserver;
    }

    @Override
    public SQLExpr primary() {
        if (this.lexer.token() == Token.LBRACKET) {
            this.lexer.nextToken();
            SQLName name = this.name();
            this.accept(Token.RBRACKET);
            return this.primaryRest(name);
        }
        return super.primary();
    }

    @Override
    public SQLServerSelectParser createSelectParser() {
        return new SQLServerSelectParser(this);
    }

    @Override
    public SQLExpr primaryRest(SQLExpr expr) {
        SQLIdentifierExpr identExpr;
        Token token = this.lexer.token();
        if (token == Token.DOTDOT) {
            expr = this.nameRest((SQLName)expr);
        } else if (this.lexer.identifierEquals(FnvHash.Constants.VALUE) && expr instanceof SQLIdentifierExpr && (identExpr = (SQLIdentifierExpr)expr).nameHashCode64() == FnvHash.Constants.NEXT) {
            this.lexer.nextToken();
            this.accept(Token.FOR);
            SQLName name = this.name();
            SQLSequenceExpr seq = new SQLSequenceExpr();
            seq.setSequence(name);
            seq.setFunction(SQLSequenceExpr.Function.NextVal);
            expr = seq;
        }
        return super.primaryRest(expr);
    }

    @Override
    protected SQLExpr dotRest(SQLExpr expr) {
        boolean backet = false;
        if (this.lexer.token() == Token.LBRACKET) {
            this.lexer.nextToken();
            backet = true;
        }
        expr = super.dotRest(expr);
        if (backet) {
            this.accept(Token.RBRACKET);
        }
        return expr;
    }

    @Override
    public SQLName nameRest(SQLName expr) {
        if (this.lexer.token() == Token.DOTDOT) {
            this.lexer.nextToken();
            boolean backet = false;
            if (this.lexer.token() == Token.LBRACKET) {
                this.lexer.nextToken();
                backet = true;
            }
            String text = this.lexer.stringVal();
            this.lexer.nextToken();
            if (backet) {
                this.accept(Token.RBRACKET);
            }
            SQLServerObjectReferenceExpr owner = new SQLServerObjectReferenceExpr(expr);
            expr = new SQLPropertyExpr(owner, text);
        }
        return super.nameRest(expr);
    }

    protected SQLServerOutput parserOutput() {
        if (this.lexer.identifierEquals("OUTPUT")) {
            this.lexer.nextToken();
            SQLServerOutput output = new SQLServerOutput();
            List<SQLSelectItem> selectList = output.getSelectList();
            while (true) {
                SQLSelectItem selectItem = this.parseSelectItem();
                selectList.add(selectItem);
                if (this.lexer.token() != Token.COMMA) break;
                this.lexer.nextToken();
            }
            if (this.lexer.token() == Token.INTO) {
                this.lexer.nextToken();
                output.setInto(new SQLExprTableSource(this.name()));
                if (this.lexer.token() == Token.LPAREN) {
                    this.lexer.nextToken();
                    this.exprList(output.getColumns(), output);
                    this.accept(Token.RPAREN);
                }
            }
            return output;
        }
        return null;
    }

    @Override
    public SQLSelectItem parseSelectItem() {
        SQLExpr expr;
        if (this.lexer.token() == Token.IDENTIFIER) {
            expr = new SQLIdentifierExpr(this.lexer.stringVal());
            this.lexer.computeRowAndColumn(expr);
            this.lexer.nextTokenComma();
            if (this.lexer.token() != Token.COMMA) {
                expr = this.primaryRest(expr);
                expr = this.exprRest(expr);
            }
        } else {
            expr = this.expr();
        }
        String alias = this.as();
        return new SQLSelectItem(expr, alias);
    }

    @Override
    public SQLColumnDefinition createColumnDefinition() {
        SQLColumnDefinition column = new SQLColumnDefinition();
        column.setDbType(this.dbType);
        return column;
    }

    @Override
    public SQLColumnDefinition parseColumnRest(SQLColumnDefinition column) {
        if (this.lexer.token() == Token.IDENTITY) {
            this.lexer.nextToken();
            SQLColumnDefinition.Identity identity = new SQLColumnDefinition.Identity();
            if (this.lexer.token() == Token.LPAREN) {
                this.lexer.nextToken();
                SQLIntegerExpr seed = (SQLIntegerExpr)this.primary();
                this.accept(Token.COMMA);
                SQLIntegerExpr increment = (SQLIntegerExpr)this.primary();
                this.accept(Token.RPAREN);
                identity.setSeed((Integer)seed.getNumber());
                identity.setIncrement((Integer)increment.getNumber());
            }
            if (this.lexer.token() == Token.NOT) {
                this.lexer.nextToken();
                if (this.lexer.token() == Token.NULL) {
                    this.lexer.nextToken();
                    column.setDefaultExpr(new SQLNullExpr());
                } else {
                    this.accept(Token.FOR);
                    this.acceptIdentifier("REPLICATION ");
                    identity.setNotForReplication(true);
                }
            }
            column.setIdentity(identity);
        }
        return super.parseColumnRest(column);
    }

    static {
        String[] strings = new String[]{"AVG", "COUNT", "FIRST_VALUE", "MAX", "MIN", "ROW_NUMBER", "STDDEV", "SUM"};
        AGGREGATE_FUNCTIONS_CODES = FnvHash.fnv1a_64_lower(strings, true);
        AGGREGATE_FUNCTIONS = new String[AGGREGATE_FUNCTIONS_CODES.length];
        for (String str : strings) {
            long hash = FnvHash.fnv1a_64_lower(str);
            int index = Arrays.binarySearch(AGGREGATE_FUNCTIONS_CODES, hash);
            SQLServerExprParser.AGGREGATE_FUNCTIONS[index] = str;
        }
    }
}

