/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.dubbo.common.status.support;

import com.alibaba.dubbo.common.extension.Activate;
import com.alibaba.dubbo.common.status.Status;
import com.alibaba.dubbo.common.status.StatusChecker;
import com.sun.management.OperatingSystemMXBean;
import java.lang.management.ManagementFactory;
import java.lang.reflect.Method;

@Activate
public class LoadStatusChecker
implements StatusChecker {
    @Override
    public Status check() {
        double load;
        java.lang.management.OperatingSystemMXBean operatingSystemMXBean = ManagementFactory.getOperatingSystemMXBean();
        try {
            Method method = java.lang.management.OperatingSystemMXBean.class.getMethod("getSystemLoadAverage", new Class[0]);
            load = (Double)method.invoke((Object)operatingSystemMXBean, new Object[0]);
            if (load == -1.0) {
                OperatingSystemMXBean bean = (OperatingSystemMXBean)operatingSystemMXBean;
                load = bean.getSystemCpuLoad();
            }
        }
        catch (Throwable e) {
            load = -1.0;
        }
        int cpu = operatingSystemMXBean.getAvailableProcessors();
        return new Status(load < 0.0 ? Status.Level.UNKNOWN : (load < (double)cpu ? Status.Level.OK : Status.Level.WARN), (load < 0.0 ? "" : "load:" + load + ",") + "cpu:" + cpu);
    }
}

