/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.dubbo.common.utils;

import com.alibaba.dubbo.common.Constants;
import com.alibaba.dubbo.common.logger.Logger;
import com.alibaba.dubbo.common.logger.LoggerFactory;
import com.alibaba.dubbo.common.utils.ConfigUtils;
import com.alibaba.dubbo.common.utils.StringUtils;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.InvalidClassException;
import java.io.ObjectInputStream;
import java.io.ObjectStreamClass;
import java.util.Arrays;
import java.util.Iterator;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class SerialDetector
extends ObjectInputStream {
    private static final Logger logger = LoggerFactory.getLogger(SerialDetector.class);
    private static final BlacklistConfiguration configuration = new BlacklistConfiguration();

    public SerialDetector(InputStream inputStream) throws IOException {
        super(inputStream);
    }

    @Override
    protected Class<?> resolveClass(ObjectStreamClass serialInput) throws IOException, ClassNotFoundException {
        if (SerialDetector.isClassInBlacklist(serialInput)) {
            if (!configuration.shouldCheck()) {
                logger.info(String.format("Blacklist match: '%s'", serialInput.getName()));
            } else {
                logger.error(String.format("Blocked by blacklist'. Match found for '%s'", serialInput.getName()));
                throw new InvalidClassException(serialInput.getName(), "Class blocked from deserialization (blacklist)");
            }
        }
        return super.resolveClass(serialInput);
    }

    public static boolean isClassInBlacklist(ObjectStreamClass serialInput) {
        Iterable<Pattern> blacklistIterable = configuration.blacklist();
        if (blacklistIterable == null) {
            return false;
        }
        boolean inBlacklist = false;
        for (Pattern blackPattern : blacklistIterable) {
            Matcher blackMatcher = blackPattern.matcher(serialInput.getName());
            if (!blackMatcher.find()) continue;
            inBlacklist = true;
            break;
        }
        return inBlacklist;
    }

    public static boolean shouldCheck() {
        return configuration.shouldCheck();
    }

    static final class PatternList
    implements Iterable<Pattern> {
        private final Pattern[] patterns;

        PatternList(String ... regExps) {
            int i;
            for (i = 0; i < regExps.length; ++i) {
                if (regExps[i] != null) continue;
                throw new IllegalStateException("Deserialization blacklist reg expression cannot be null!");
            }
            this.patterns = new Pattern[regExps.length];
            for (i = 0; i < regExps.length; ++i) {
                this.patterns[i] = Pattern.compile(regExps[i]);
            }
        }

        @Override
        public Iterator<Pattern> iterator() {
            return new Iterator<Pattern>(){
                int index = 0;

                @Override
                public boolean hasNext() {
                    return this.index < PatternList.this.patterns.length;
                }

                @Override
                public Pattern next() {
                    return PatternList.this.patterns[this.index++];
                }

                @Override
                public void remove() {
                    throw new UnsupportedOperationException("remove");
                }
            };
        }

        public String toString() {
            return Arrays.toString(this.patterns);
        }
    }

    static final class BlacklistConfiguration {
        private static final String DUBBO_SECURITY_SERIALIZATION_CHECK = "dubbo.security.serialization.check";
        private static final String DUBBO_SECURITY_SERIALIZATION_BLACKLIST = "dubbo.security.serialization.blacklist";
        private static final String DUBBO_SECURITY_SERIALIZATION_BLACKLIST_FILE = "dubbo.registry.serialization.blacklist.file";
        private boolean check;
        private PatternList blacklistPattern;

        BlacklistConfiguration() {
            try {
                String blacklistFile;
                this.check = Boolean.parseBoolean(this.getSecurityProperty(DUBBO_SECURITY_SERIALIZATION_CHECK, "false"));
                String blacklist = this.getSecurityProperty(DUBBO_SECURITY_SERIALIZATION_BLACKLIST, "");
                if (StringUtils.isEmpty(blacklist) && StringUtils.isNotEmpty(blacklistFile = this.getSecurityProperty(DUBBO_SECURITY_SERIALIZATION_BLACKLIST_FILE, ""))) {
                    blacklist = this.loadBlacklistFile(blacklistFile);
                }
                if (StringUtils.isNotEmpty(blacklist)) {
                    this.blacklistPattern = new PatternList(Constants.COMMA_SPLIT_PATTERN.split(blacklist));
                }
            }
            catch (Throwable t) {
                logger.warn("Failed to initialize the Serialization Security Checker component!", t);
            }
        }

        Iterable<Pattern> blacklist() {
            return this.blacklistPattern;
        }

        boolean shouldCheck() {
            return this.check;
        }

        private String loadBlacklistFile(String fileName) {
            StringBuilder blacklist = new StringBuilder();
            InputStream is = null;
            File file = new File(fileName);
            if (file.exists()) {
                try {
                    is = new FileInputStream(fileName);
                }
                catch (Throwable e) {
                    logger.warn("Failed to load " + fileName + " file " + e.getMessage(), e);
                }
            } else {
                is = this.getClass().getClassLoader().getResourceAsStream(fileName);
            }
            try {
                BufferedReader reader = new BufferedReader(new InputStreamReader(is));
                String line = null;
                while ((line = reader.readLine()) != null) {
                    if (line.startsWith("#") || !StringUtils.isNotEmpty(line)) continue;
                    blacklist.append(line);
                    blacklist.append(",");
                }
            }
            catch (Throwable e) {
                logger.warn("Failed to read from file " + fileName + e.getMessage(), e);
            }
            return blacklist.toString();
        }

        private String getSecurityProperty(String key, String defaultValue) {
            String value = ConfigUtils.getSystemProperty(key);
            if (StringUtils.isEmpty(value)) {
                value = ConfigUtils.getProperty(key);
            }
            return StringUtils.isEmpty(value) ? defaultValue : value;
        }
    }
}

