/*
 * Decompiled with CFR 0.152.
 */
package com.alicp.jetcache.autoconfigure;

import com.alicp.jetcache.CacheBuilder;
import com.alicp.jetcache.CacheConfigException;
import com.alicp.jetcache.autoconfigure.AutoConfigureBeans;
import com.alicp.jetcache.autoconfigure.ConfigTree;
import com.alicp.jetcache.autoconfigure.ExternalCacheAutoInit;
import com.alicp.jetcache.autoconfigure.JetCacheCondition;
import com.alicp.jetcache.redis.RedisCacheBuilder;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.pool2.impl.GenericObjectPoolConfig;
import org.springframework.beans.PropertyValues;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Conditional;
import org.springframework.context.annotation.Configuration;
import org.springframework.core.env.Environment;
import org.springframework.util.ClassUtils;
import redis.clients.jedis.HostAndPort;
import redis.clients.jedis.JedisCluster;
import redis.clients.jedis.JedisPool;
import redis.clients.jedis.JedisSentinelPool;
import redis.clients.jedis.UnifiedJedis;
import redis.clients.jedis.util.Pool;

@Configuration
@Conditional(value={RedisCondition.class})
public class RedisAutoConfiguration {
    public static final String AUTO_INIT_BEAN_NAME = "redisAutoInit";

    @Bean(name={"redisAutoInit"})
    public RedisAutoInit redisAutoInit() {
        return new RedisAutoInit();
    }

    public static class RedisAutoInit
    extends ExternalCacheAutoInit {
        @Autowired
        private AutoConfigureBeans autoConfigureBeans;

        public RedisAutoInit() {
            super("redis");
        }

        @Override
        protected CacheBuilder initCache(ConfigTree ct, String cacheAreaWithPrefix) {
            Object jedisObj = this.parsePool(ct);
            boolean readFromSlave = Boolean.parseBoolean(ct.getProperty("readFromSlave", "False"));
            RedisCacheBuilder.RedisCacheBuilderImpl builder = (RedisCacheBuilder.RedisCacheBuilderImpl)RedisCacheBuilder.createRedisCacheBuilder().readFromSlave(readFromSlave);
            if (jedisObj instanceof Pool) {
                builder.jedisPool((Pool)jedisObj);
            } else {
                builder.jedis((UnifiedJedis)jedisObj);
            }
            ConfigTree slaves = ct.subTree("slaves.");
            Set<String> slaveNames = slaves.directChildrenKeys();
            if (slaveNames.size() > 0) {
                ArrayList<Object> slavesObjects = new ArrayList<Object>();
                int[] slavesWeights = new int[slaveNames.size()];
                int i = 0;
                for (String slaveName : slaveNames) {
                    ConfigTree slaveConfig = slaves.subTree(slaveName + ".");
                    slavesObjects.add(this.parsePool(slaveConfig));
                    slavesWeights[i] = Integer.parseInt(slaveConfig.getProperty("weight", "100"));
                    ++i;
                }
                builder.slaveReadWeights(slavesWeights);
                if (slavesObjects.get(0) instanceof Pool) {
                    builder.jedisSlavePools(slavesObjects.toArray(new Pool[0]));
                } else {
                    builder.slaves(slavesObjects.toArray(new UnifiedJedis[0]));
                }
            }
            this.parseGeneralConfig((CacheBuilder)builder, ct);
            this.autoConfigureBeans.getCustomContainer().put("jedisPool." + cacheAreaWithPrefix, jedisObj);
            if (jedisObj instanceof UnifiedJedis) {
                this.autoConfigureBeans.getCustomContainer().put("jedis." + cacheAreaWithPrefix, jedisObj);
            }
            return builder;
        }

        private Object parsePool(ConfigTree ct) {
            GenericObjectPoolConfig poolConfig = this.parsePoolConfig(ct);
            Map<String, Object> cluster = ct.subTree("cluster").getProperties();
            String host = ct.getProperty("host", null);
            int port = Integer.parseInt(ct.getProperty("port", "0"));
            int timeout = Integer.parseInt(ct.getProperty("timeout", String.valueOf(2000)));
            int connectionTimeout = Integer.parseInt(ct.getProperty("connectionTimeout", String.valueOf(timeout)));
            int soTimeout = Integer.parseInt(ct.getProperty("soTimeout", String.valueOf(timeout)));
            String user = ct.getProperty("user", null);
            String password = ct.getProperty("password", null);
            int database = Integer.parseInt(ct.getProperty("database", String.valueOf(0)));
            String clientName = ct.getProperty("clientName", null);
            boolean ssl = Boolean.parseBoolean(ct.getProperty("ssl", "false"));
            String sentinels = ct.getProperty("sentinels", null);
            if (sentinels == null) {
                if (cluster == null || cluster.size() == 0) {
                    Objects.requireNonNull(host, "host is required");
                    if (port == 0) {
                        throw new IllegalStateException("port is required");
                    }
                    return new JedisPool(poolConfig, host, port, connectionTimeout, soTimeout, user, password, database, clientName, ssl);
                }
                int maxAttempt = Integer.parseInt(ct.getProperty("maxAttempt", "5"));
                Set hostAndPortSet = cluster.values().stream().map(uri -> uri.toString().split(":")).map(hostAndPort -> new HostAndPort(hostAndPort[0], Integer.parseInt(hostAndPort[1]))).collect(Collectors.toSet());
                return new JedisCluster(hostAndPortSet, connectionTimeout, soTimeout, maxAttempt, user, password, clientName, poolConfig, ssl);
            }
            String masterName = ct.getProperty("masterName", null);
            Objects.requireNonNull(masterName, "masterName is required");
            int sentinelConnectionTimeout = Integer.parseInt(ct.getProperty("sentinelConnectionTimeout", String.valueOf(2000)));
            int sentinelSoTimeout = Integer.parseInt(ct.getProperty("sentinelSoTimeout", String.valueOf(2000)));
            String sentinelUser = ct.getProperty("sentinelUser", null);
            String sentinelPassword = ct.getProperty("sentinelPassword", null);
            String sentinelClientName = ct.getProperty("sentinelClientName", null);
            String[] strings = sentinels.split(",");
            HashSet<String> sentinelsSet = new HashSet<String>();
            for (String s : strings) {
                if (s == null || s.trim().equals("")) continue;
                sentinelsSet.add(s.trim());
            }
            return new JedisSentinelPool(masterName, sentinelsSet, poolConfig, connectionTimeout, soTimeout, user, password, database, clientName, sentinelConnectionTimeout, sentinelSoTimeout, sentinelUser, sentinelPassword, sentinelClientName);
        }

        private GenericObjectPoolConfig parsePoolConfig(ConfigTree ct) {
            try {
                if (ClassUtils.isPresent((String)"org.springframework.boot.context.properties.bind.Binder", (ClassLoader)this.getClass().getClassLoader())) {
                    String prefix = ct.subTree("poolConfig").getPrefix().toLowerCase();
                    Class<?> binderClass = Class.forName("org.springframework.boot.context.properties.bind.Binder");
                    Class<?> bindableClass = Class.forName("org.springframework.boot.context.properties.bind.Bindable");
                    Class<?> bindResultClass = Class.forName("org.springframework.boot.context.properties.bind.BindResult");
                    Method getMethodOnBinder = binderClass.getMethod("get", Environment.class);
                    Method getMethodOnBindResult = bindResultClass.getMethod("get", new Class[0]);
                    Method bindMethod = binderClass.getMethod("bind", String.class, bindableClass);
                    Method ofMethod = bindableClass.getMethod("of", Class.class);
                    Object binder = getMethodOnBinder.invoke(null, this.environment);
                    Object bindable = ofMethod.invoke(null, GenericObjectPoolConfig.class);
                    Object bindResult = bindMethod.invoke(binder, prefix, bindable);
                    return (GenericObjectPoolConfig)getMethodOnBindResult.invoke(bindResult, new Object[0]);
                }
                GenericObjectPoolConfig poolConfig = new GenericObjectPoolConfig();
                Map<String, Object> props = ct.subTree("poolConfig.").getProperties();
                Class<?> relaxedDataBinderClass = Class.forName("org.springframework.boot.bind.RelaxedDataBinder");
                Class<?> mutablePropertyValuesClass = Class.forName("org.springframework.beans.MutablePropertyValues");
                Constructor<?> c1 = relaxedDataBinderClass.getConstructor(Object.class);
                Constructor<?> c2 = mutablePropertyValuesClass.getConstructor(Map.class);
                Method bindMethod = relaxedDataBinderClass.getMethod("bind", PropertyValues.class);
                Object binder = c1.newInstance(poolConfig);
                bindMethod.invoke(binder, c2.newInstance(props));
                return poolConfig;
            }
            catch (Throwable ex) {
                throw new CacheConfigException("parse poolConfig fail", ex);
            }
        }
    }

    public static class RedisCondition
    extends JetCacheCondition {
        public RedisCondition() {
            super("redis");
        }
    }
}

