/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.iot.model;

import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.services.iot.model.DetectMitigationActionsTaskTarget;
import com.amazonaws.services.iot.model.ViolationEventOccurrenceRange;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class StartDetectMitigationActionsTaskRequest
extends AmazonWebServiceRequest
implements Serializable,
Cloneable {
    private String taskId;
    private DetectMitigationActionsTaskTarget target;
    private List<String> actions;
    private ViolationEventOccurrenceRange violationEventOccurrenceRange;
    private Boolean includeOnlyActiveViolations;
    private Boolean includeSuppressedAlerts;
    private String clientRequestToken;

    public void setTaskId(String taskId) {
        this.taskId = taskId;
    }

    public String getTaskId() {
        return this.taskId;
    }

    public StartDetectMitigationActionsTaskRequest withTaskId(String taskId) {
        this.setTaskId(taskId);
        return this;
    }

    public void setTarget(DetectMitigationActionsTaskTarget target) {
        this.target = target;
    }

    public DetectMitigationActionsTaskTarget getTarget() {
        return this.target;
    }

    public StartDetectMitigationActionsTaskRequest withTarget(DetectMitigationActionsTaskTarget target) {
        this.setTarget(target);
        return this;
    }

    public List<String> getActions() {
        return this.actions;
    }

    public void setActions(Collection<String> actions) {
        if (actions == null) {
            this.actions = null;
            return;
        }
        this.actions = new ArrayList<String>(actions);
    }

    public StartDetectMitigationActionsTaskRequest withActions(String ... actions) {
        if (this.actions == null) {
            this.setActions(new ArrayList<String>(actions.length));
        }
        for (String ele : actions) {
            this.actions.add(ele);
        }
        return this;
    }

    public StartDetectMitigationActionsTaskRequest withActions(Collection<String> actions) {
        this.setActions(actions);
        return this;
    }

    public void setViolationEventOccurrenceRange(ViolationEventOccurrenceRange violationEventOccurrenceRange) {
        this.violationEventOccurrenceRange = violationEventOccurrenceRange;
    }

    public ViolationEventOccurrenceRange getViolationEventOccurrenceRange() {
        return this.violationEventOccurrenceRange;
    }

    public StartDetectMitigationActionsTaskRequest withViolationEventOccurrenceRange(ViolationEventOccurrenceRange violationEventOccurrenceRange) {
        this.setViolationEventOccurrenceRange(violationEventOccurrenceRange);
        return this;
    }

    public void setIncludeOnlyActiveViolations(Boolean includeOnlyActiveViolations) {
        this.includeOnlyActiveViolations = includeOnlyActiveViolations;
    }

    public Boolean getIncludeOnlyActiveViolations() {
        return this.includeOnlyActiveViolations;
    }

    public StartDetectMitigationActionsTaskRequest withIncludeOnlyActiveViolations(Boolean includeOnlyActiveViolations) {
        this.setIncludeOnlyActiveViolations(includeOnlyActiveViolations);
        return this;
    }

    public Boolean isIncludeOnlyActiveViolations() {
        return this.includeOnlyActiveViolations;
    }

    public void setIncludeSuppressedAlerts(Boolean includeSuppressedAlerts) {
        this.includeSuppressedAlerts = includeSuppressedAlerts;
    }

    public Boolean getIncludeSuppressedAlerts() {
        return this.includeSuppressedAlerts;
    }

    public StartDetectMitigationActionsTaskRequest withIncludeSuppressedAlerts(Boolean includeSuppressedAlerts) {
        this.setIncludeSuppressedAlerts(includeSuppressedAlerts);
        return this;
    }

    public Boolean isIncludeSuppressedAlerts() {
        return this.includeSuppressedAlerts;
    }

    public void setClientRequestToken(String clientRequestToken) {
        this.clientRequestToken = clientRequestToken;
    }

    public String getClientRequestToken() {
        return this.clientRequestToken;
    }

    public StartDetectMitigationActionsTaskRequest withClientRequestToken(String clientRequestToken) {
        this.setClientRequestToken(clientRequestToken);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getTaskId() != null) {
            sb.append("TaskId: ").append(this.getTaskId()).append(",");
        }
        if (this.getTarget() != null) {
            sb.append("Target: ").append(this.getTarget()).append(",");
        }
        if (this.getActions() != null) {
            sb.append("Actions: ").append(this.getActions()).append(",");
        }
        if (this.getViolationEventOccurrenceRange() != null) {
            sb.append("ViolationEventOccurrenceRange: ").append(this.getViolationEventOccurrenceRange()).append(",");
        }
        if (this.getIncludeOnlyActiveViolations() != null) {
            sb.append("IncludeOnlyActiveViolations: ").append(this.getIncludeOnlyActiveViolations()).append(",");
        }
        if (this.getIncludeSuppressedAlerts() != null) {
            sb.append("IncludeSuppressedAlerts: ").append(this.getIncludeSuppressedAlerts()).append(",");
        }
        if (this.getClientRequestToken() != null) {
            sb.append("ClientRequestToken: ").append(this.getClientRequestToken());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof StartDetectMitigationActionsTaskRequest)) {
            return false;
        }
        StartDetectMitigationActionsTaskRequest other = (StartDetectMitigationActionsTaskRequest)obj;
        if (other.getTaskId() == null ^ this.getTaskId() == null) {
            return false;
        }
        if (other.getTaskId() != null && !other.getTaskId().equals(this.getTaskId())) {
            return false;
        }
        if (other.getTarget() == null ^ this.getTarget() == null) {
            return false;
        }
        if (other.getTarget() != null && !other.getTarget().equals(this.getTarget())) {
            return false;
        }
        if (other.getActions() == null ^ this.getActions() == null) {
            return false;
        }
        if (other.getActions() != null && !other.getActions().equals(this.getActions())) {
            return false;
        }
        if (other.getViolationEventOccurrenceRange() == null ^ this.getViolationEventOccurrenceRange() == null) {
            return false;
        }
        if (other.getViolationEventOccurrenceRange() != null && !other.getViolationEventOccurrenceRange().equals(this.getViolationEventOccurrenceRange())) {
            return false;
        }
        if (other.getIncludeOnlyActiveViolations() == null ^ this.getIncludeOnlyActiveViolations() == null) {
            return false;
        }
        if (other.getIncludeOnlyActiveViolations() != null && !other.getIncludeOnlyActiveViolations().equals(this.getIncludeOnlyActiveViolations())) {
            return false;
        }
        if (other.getIncludeSuppressedAlerts() == null ^ this.getIncludeSuppressedAlerts() == null) {
            return false;
        }
        if (other.getIncludeSuppressedAlerts() != null && !other.getIncludeSuppressedAlerts().equals(this.getIncludeSuppressedAlerts())) {
            return false;
        }
        if (other.getClientRequestToken() == null ^ this.getClientRequestToken() == null) {
            return false;
        }
        return other.getClientRequestToken() == null || other.getClientRequestToken().equals(this.getClientRequestToken());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getTaskId() == null ? 0 : this.getTaskId().hashCode());
        hashCode = 31 * hashCode + (this.getTarget() == null ? 0 : this.getTarget().hashCode());
        hashCode = 31 * hashCode + (this.getActions() == null ? 0 : this.getActions().hashCode());
        hashCode = 31 * hashCode + (this.getViolationEventOccurrenceRange() == null ? 0 : this.getViolationEventOccurrenceRange().hashCode());
        hashCode = 31 * hashCode + (this.getIncludeOnlyActiveViolations() == null ? 0 : this.getIncludeOnlyActiveViolations().hashCode());
        hashCode = 31 * hashCode + (this.getIncludeSuppressedAlerts() == null ? 0 : this.getIncludeSuppressedAlerts().hashCode());
        hashCode = 31 * hashCode + (this.getClientRequestToken() == null ? 0 : this.getClientRequestToken().hashCode());
        return hashCode;
    }

    public StartDetectMitigationActionsTaskRequest clone() {
        return (StartDetectMitigationActionsTaskRequest)super.clone();
    }
}

