/*
 * Decompiled with CFR 0.152.
 */
package com.auth0.jwt.pem;

import com.auth0.jwt.internal.org.apache.commons.lang3.Validate;
import com.auth0.jwt.internal.org.bouncycastle.jce.provider.BouncyCastleProvider;
import com.auth0.jwt.pem.PemFileReader;
import com.auth0.jwt.pem.X509CertUtils;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.security.KeyFactory;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.Security;
import java.security.cert.X509Certificate;
import java.security.spec.InvalidKeySpecException;
import java.security.spec.PKCS8EncodedKeySpec;
import java.security.spec.X509EncodedKeySpec;

public class PemReader {
    public static PrivateKey readPrivateKey(String filePath) throws NoSuchProviderException, NoSuchAlgorithmException, IOException, InvalidKeySpecException {
        Validate.notNull(filePath);
        KeyFactory factory = KeyFactory.getInstance("RSA", "BC");
        PrivateKey privateKey = PemReader.readPrivateKeyFromFile(factory, filePath);
        return privateKey;
    }

    public static PublicKey readPublicKey(String filePath) throws NoSuchProviderException, NoSuchAlgorithmException, IOException, InvalidKeySpecException {
        Validate.notNull(filePath);
        KeyFactory factory = KeyFactory.getInstance("RSA", "BC");
        PublicKey publicKey = PemReader.readPublicKeyFromFile(factory, filePath);
        return publicKey;
    }

    private static PrivateKey readPrivateKeyFromFile(KeyFactory factory, String filename) throws InvalidKeySpecException, IOException {
        Validate.notNull(factory);
        Validate.notNull(filename);
        PemFileReader pemFileReader = new PemFileReader(filename);
        byte[] content = pemFileReader.getPemObject().getContent();
        PKCS8EncodedKeySpec privKeySpec = new PKCS8EncodedKeySpec(content);
        return factory.generatePrivate(privKeySpec);
    }

    private static PublicKey readPublicKeyFromFile(KeyFactory factory, String filename) throws InvalidKeySpecException, IOException {
        Validate.notNull(factory);
        Validate.notNull(filename);
        File file = new File(filename);
        byte[] data = Files.readAllBytes(file.toPath());
        X509Certificate cert = X509CertUtils.parse(new String(data));
        if (cert != null) {
            PublicKey publicKey = cert.getPublicKey();
            return publicKey;
        }
        PemFileReader pemFileReader = new PemFileReader(filename);
        byte[] content = pemFileReader.getPemObject().getContent();
        X509EncodedKeySpec pubKeySpec = new X509EncodedKeySpec(content);
        return factory.generatePublic(pubKeySpec);
    }

    static {
        if (Security.getProvider("BC") == null) {
            Security.addProvider(new BouncyCastleProvider());
        }
    }
}

