/*
 * Decompiled with CFR 0.152.
 */
package com.baidu.bjf.remoting.protobuf.code;

import com.baidu.bjf.remoting.protobuf.Codec;
import com.baidu.bjf.remoting.protobuf.FieldType;
import com.baidu.bjf.remoting.protobuf.annotation.EnableZigZap;
import com.baidu.bjf.remoting.protobuf.annotation.Protobuf;
import com.baidu.bjf.remoting.protobuf.annotation.ProtobufClass;
import com.baidu.bjf.remoting.protobuf.code.AbstractCodeGenerator;
import com.baidu.bjf.remoting.protobuf.code.ClassCode;
import com.baidu.bjf.remoting.protobuf.code.CodeTemplate;
import com.baidu.bjf.remoting.protobuf.code.CodedConstant;
import com.baidu.bjf.remoting.protobuf.code.MethodCode;
import com.baidu.bjf.remoting.protobuf.utils.ClassHelper;
import com.baidu.bjf.remoting.protobuf.utils.FieldInfo;
import com.baidu.bjf.remoting.protobuf.utils.FieldUtils;
import com.baidu.bjf.remoting.protobuf.utils.ProtobufProxyUtils;
import com.baidu.bjf.remoting.protobuf.utils.StringUtils;
import com.google.protobuf.Descriptors;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Deprecated
public class CodeGenerator
extends AbstractCodeGenerator {
    public static final String DEFAULT_SUFFIX_CLASSNAME = "$$JProtoBufClass";
    public static final String JAVA_CLASS_FILE_SUFFIX = ".class";
    private static final Logger LOGGER = LoggerFactory.getLogger((String)CodeGenerator.class.getCanonicalName());
    private Set<Class<?>> relativeProxyClasses = new HashSet();
    protected List<FieldInfo> fields;

    @Override
    public Set<Class<?>> getRelativeProxyClasses() {
        return this.relativeProxyClasses;
    }

    public CodeGenerator(Class<?> cls) {
        super(cls);
    }

    @Override
    public String getClassName() {
        return ClassHelper.getClassName(this.cls) + DEFAULT_SUFFIX_CLASSNAME;
    }

    @Override
    public String getCode() {
        if (this.fields == null) {
            this.fields = this.fetchFieldInfos();
        }
        String className = this.getClassName();
        ClassCode code = new ClassCode("public", className);
        code.addInteface(Codec.class.getName() + "<" + ClassHelper.getInternalName(this.cls.getCanonicalName()) + ">");
        code.setPkg(this.getPackage());
        this.genImportCode(code);
        String descriptorClsName = ClassHelper.getInternalName(Descriptors.Descriptor.class.getCanonicalName());
        code.addField("private", descriptorClsName, "descriptor", null);
        code.addMethod(this.getEncodeMethodCode());
        code.addMethod(this.getDecodeMethodCode());
        code.addMethod(this.getSizeMethodCode());
        code.addMethod(this.getWriteToMethodCode());
        code.addMethod(this.getReadFromMethodCode());
        code.addMethod(this.getGetDescriptorMethodCode());
        return code.toCode();
    }

    protected List<FieldInfo> fetchFieldInfos() {
        ProtobufClass annotation = this.cls.getAnnotation(ProtobufClass.class);
        EnableZigZap zipZap = this.cls.getAnnotation(EnableZigZap.class);
        boolean isZipZap = false;
        if (zipZap != null) {
            isZipZap = true;
        }
        boolean typeDefined = false;
        List<Field> fields = null;
        if (annotation == null) {
            fields = FieldUtils.findMatchedFields(this.cls, Protobuf.class);
            if (fields.isEmpty()) {
                throw new IllegalArgumentException("Invalid class [" + this.cls.getName() + "] no field use annotation @" + Protobuf.class.getName() + " at class " + this.cls.getName());
            }
        } else {
            typeDefined = true;
            fields = FieldUtils.findMatchedFields(this.cls, null);
        }
        List<FieldInfo> fieldInfos = ProtobufProxyUtils.processDefaultValue(fields, typeDefined, isZipZap);
        return fieldInfos;
    }

    private void genImportCode(ClassCode code) {
        code.importClass("java.util.*");
        code.importClass("java.io.IOException");
        code.importClass("java.lang.reflect.*");
        code.importClass("com.baidu.bjf.remoting.protobuf.code.*");
        code.importClass("com.baidu.bjf.remoting.protobuf.utils.*");
        code.importClass("com.baidu.bjf.remoting.protobuf.*");
        code.importClass("com.google.protobuf.*");
        if (!StringUtils.isEmpty(this.getPackage())) {
            code.importClass(ClassHelper.getInternalName(this.cls.getCanonicalName()));
        }
    }

    private void getParseBytesMethodCode(MethodCode mc) {
        boolean isList;
        StringBuilder code = new StringBuilder();
        code.append(ClassHelper.getInternalName(this.cls.getCanonicalName())).append(" ret = new ");
        code.append(ClassHelper.getInternalName(this.cls.getCanonicalName())).append("()");
        mc.appendLineCode1(code.toString());
        code.setLength(0);
        for (FieldInfo field : this.fields) {
            isList = field.isList();
            if (field.getFieldType() != FieldType.ENUM) continue;
            String clsName = ClassHelper.getInternalName(field.getField().getType().getCanonicalName());
            if (isList) continue;
            String express = "CodedConstant.getEnumValue(" + clsName + ".class, " + clsName + ".values()[0].name())";
            mc.appendLineCode1(this.getSetToField("ret", field.getField(), this.cls, express, isList, field.isMap()));
        }
        mc.appendLineCode0("try {");
        mc.appendLineCode1("    boolean done = false");
        mc.appendLineCode1("    Codec codec = null");
        mc.appendLineCode0("    while (!done) {");
        mc.appendLineCode1("    int tag = input.readTag()");
        mc.appendLineCode0("    if (tag == 0) { break;}");
        for (FieldInfo field : this.fields) {
            String spath;
            String name;
            Class<?> cls;
            String express;
            isList = field.isList();
            if (field.getFieldType() != FieldType.DEFAULT) {
                code.append("if (tag == ").append(CodedConstant.makeTag(field.getOrder(), field.getFieldType().getInternalFieldType().getWireType()));
                code.append(") {");
                mc.appendLineCode0(code.toString());
            } else {
                code.append("if (tag == CodedConstant.makeTag(").append(field.getOrder());
                code.append(",WireFormat.").append(field.getFieldType().getWireFormat()).append(")) {");
                mc.appendLineCode0(code.toString());
            }
            code.setLength(0);
            String t = field.getFieldType().getType();
            t = CodedConstant.capitalize(t);
            boolean listTypeCheck = false;
            if (field.getFieldType() == FieldType.ENUM) {
                String clsName = ClassHelper.getInternalName(field.getField().getType().getCanonicalName());
                if (isList && field.getGenericKeyType() != null) {
                    Class<?> cls2 = field.getGenericKeyType();
                    clsName = ClassHelper.getInternalName(cls2.getCanonicalName());
                }
                express = "CodedConstant.getEnumValue(" + clsName + ".class, CodedConstant.getEnumName(" + clsName + ".values(),input.read" + t + "()))";
            } else {
                express = "input.read" + t + "()";
            }
            if (isList && field.getFieldType() == FieldType.OBJECT) {
                if (field.getGenericKeyType() != null) {
                    cls = field.getGenericKeyType();
                    name = ClassHelper.getInternalName(cls.getCanonicalName());
                    code.append("codec = ProtobufProxy.create(").append(name).append(JAVA_CLASS_FILE_SUFFIX);
                    if (this.debug) {
                        code.append(", true");
                    } else {
                        code.append(", false");
                    }
                    spath = "ProtobufProxy.OUTPUT_PATH.get()";
                    code.append(",").append(spath);
                    code.append(")");
                    mc.appendLineCode1(code.toString());
                    code.setLength(0);
                    mc.appendLineCode1("int length = input.readRawVarint32()");
                    mc.appendLineCode1("final int oldLimit = input.pushLimit(length)");
                    listTypeCheck = true;
                    express = "(" + name + ") codec.readFrom(input)";
                }
            } else if (field.getFieldType() == FieldType.OBJECT) {
                cls = field.getField().getType();
                name = ClassHelper.getInternalName(cls.getCanonicalName());
                code.append("codec = ProtobufProxy.create(").append(name).append(JAVA_CLASS_FILE_SUFFIX);
                if (this.debug) {
                    code.append(", true");
                } else {
                    code.append(", false");
                }
                spath = "ProtobufProxy.OUTPUT_PATH.get()";
                code.append(",").append(spath);
                code.append(")");
                mc.appendLineCode1(code.toString());
                code.setLength(0);
                mc.appendLineCode1("int length = input.readRawVarint32()");
                mc.appendLineCode1("final int oldLimit = input.pushLimit(length)");
                listTypeCheck = true;
                express = "(" + name + ") codec.readFrom(input)";
            }
            if (field.getFieldType() == FieldType.BYTES) {
                express = express + ".toByteArray()";
            }
            mc.appendLineCode1(this.getSetToField("ret", field.getField(), this.cls, express, isList, field.isMap()));
            if (listTypeCheck) {
                mc.appendLineCode1("input.checkLastTagWas(0)");
                mc.appendLineCode1("input.popLimit(oldLimit)");
            }
            mc.appendLineCode1("continue");
            mc.appendLineCode0("}");
        }
        mc.appendLineCode1("input.skipField(tag)");
        mc.appendLineCode0("}");
        mc.appendLineCode0("} catch (com.google.protobuf.InvalidProtocolBufferException e) {");
        mc.appendLineCode1("throw e");
        mc.appendLineCode0("} catch (java.io.IOException e) {");
        mc.appendLineCode1("throw e");
        mc.appendLineCode0("}");
        for (FieldInfo field : this.fields) {
            if (!field.isRequired()) continue;
            mc.appendLineCode0(CodedConstant.getRetRequiredCheck(this.getAccessByField("ret", field.getField(), this.cls), field.getField()));
        }
        mc.appendLineCode1("return ret");
    }

    private MethodCode getDecodeMethodCode() {
        MethodCode mc = new MethodCode();
        mc.setName("decode");
        mc.setScope("public");
        mc.setReturnType(ClassHelper.getInternalName(this.cls.getCanonicalName()));
        mc.addParameter("byte[]", "bb");
        mc.addException("IOException");
        mc.appendLineCode1("CodedInputStream input = CodedInputStream.newInstance(bb, 0, bb.length)");
        this.getParseBytesMethodCode(mc);
        return mc;
    }

    private MethodCode getGetDescriptorMethodCode() {
        String descriptorClsName = ClassHelper.getInternalName(Descriptors.Descriptor.class.getCanonicalName());
        MethodCode mc = new MethodCode();
        mc.setName("getDescriptor");
        mc.setReturnType(descriptorClsName);
        mc.setScope("public");
        mc.addException("IOException");
        String methodSource = CodeTemplate.descriptorMethodSource(this.cls);
        mc.appendLineCode0(methodSource);
        return mc;
    }

    private MethodCode getReadFromMethodCode() {
        MethodCode mc = new MethodCode();
        mc.setName("readFrom");
        mc.setReturnType(ClassHelper.getInternalName(this.cls.getCanonicalName()));
        mc.setScope("public");
        mc.addParameter("CodedInputStream", "input");
        mc.addException("IOException");
        this.getParseBytesMethodCode(mc);
        return mc;
    }

    private MethodCode getEncodeMethodCode() {
        MethodCode mc = new MethodCode();
        mc.setName("encode");
        mc.setScope("public");
        mc.setReturnType("byte[]");
        mc.addParameter(ClassHelper.getInternalName(this.cls.getCanonicalName()), "t");
        mc.addException("IOException");
        mc.appendLineCode1("int size = 0");
        HashSet orders = new HashSet();
        for (FieldInfo field : this.fields) {
            boolean isList = field.isList();
            if (!isList) {
                this.checkType(field.getFieldType(), field.getField());
            }
            if (orders.contains(field.getOrder())) {
                throw new IllegalArgumentException("Field order '" + field.getOrder() + "' on field" + field.getField().getName() + " already exsit.");
            }
            String checkParameterLine = CodedConstant.getMappedTypeDefined(field.getOrder(), field.getFieldType(), this.getAccessByField("t", field.getField(), this.cls), isList);
            mc.appendLineCode0(checkParameterLine);
            StringBuilder code = new StringBuilder();
            code.append("if (!CodedConstant.isNull(").append(this.getAccessByField("t", field.getField(), this.cls)).append("))").append("{");
            mc.appendLineCode0(code.toString());
            code.setLength(0);
            code.append("size += ");
            code.append(CodedConstant.getMappedTypeSize(field, field.getOrder(), field.getFieldType(), isList, this.debug, this.outputPath));
            mc.appendLineCode0(code.toString());
            mc.appendLineCode0("}");
            if (!field.isRequired()) continue;
            mc.appendLineCode0(CodedConstant.getRequiredCheck(field.getOrder(), field.getField()));
        }
        mc.appendLineCode1("final byte[] result = new byte[size]");
        mc.appendLineCode1("final CodedOutputStream output = CodedOutputStream.newInstance(result)");
        mc.appendLineCode1("writeTo(t, output)");
        mc.appendLineCode1("return result");
        return mc;
    }

    private MethodCode getWriteToMethodCode() {
        boolean isList;
        MethodCode mc = new MethodCode();
        mc.setName("writeTo");
        mc.setReturnType("void");
        mc.setScope("public");
        mc.addParameter(ClassHelper.getInternalName(this.cls.getCanonicalName()), "t");
        mc.addParameter("CodedOutputStream", "output");
        mc.addException("IOException");
        HashSet orders = new HashSet();
        for (FieldInfo field : this.fields) {
            isList = field.isList();
            if (!isList) {
                this.checkType(field.getFieldType(), field.getField());
            }
            if (orders.contains(field.getOrder())) {
                throw new IllegalArgumentException("Field order '" + field.getOrder() + "' on field" + field.getField().getName() + " already exsit.");
            }
            mc.appendLineCode0(CodedConstant.getMappedTypeDefined(field.getOrder(), field.getFieldType(), this.getAccessByField("t", field.getField(), this.cls), isList));
            if (!field.isRequired()) continue;
            mc.appendLineCode0(CodedConstant.getRequiredCheck(field.getOrder(), field.getField()));
        }
        for (FieldInfo field : this.fields) {
            isList = field.isList();
            mc.appendLineCode0(CodedConstant.getMappedWriteCode(field, "output", field.getOrder(), field.getFieldType(), isList));
        }
        mc.appendLineCode1("output.flush()");
        return mc;
    }

    private MethodCode getSizeMethodCode() {
        MethodCode mc = new MethodCode();
        mc.setName("size");
        mc.setScope("public");
        mc.setReturnType("int");
        mc.addParameter(ClassHelper.getInternalName(this.cls.getCanonicalName()), "t");
        mc.addException("IOException");
        mc.appendLineCode1("int size = 0");
        HashSet orders = new HashSet();
        for (FieldInfo field : this.fields) {
            boolean isList = field.isList();
            if (!isList) {
                this.checkType(field.getFieldType(), field.getField());
            }
            if (orders.contains(field.getOrder())) {
                throw new IllegalArgumentException("Field order '" + field.getOrder() + "' on field" + field.getField().getName() + " already exsit.");
            }
            mc.appendLineCode0(CodedConstant.getMappedTypeDefined(field.getOrder(), field.getFieldType(), this.getAccessByField("t", field.getField(), this.cls), isList));
            StringBuilder code = new StringBuilder();
            code.append("if (!CodedConstant.isNull(").append(this.getAccessByField("t", field.getField(), this.cls)).append("))").append("{");
            mc.appendLineCode0(code.toString());
            code.setLength(0);
            code.append("size += ");
            code.append(CodedConstant.getMappedTypeSize(field, field.getOrder(), field.getFieldType(), isList, this.debug, this.outputPath));
            code.append("}");
            mc.appendLineCode0(code.toString());
            if (!field.isRequired()) continue;
            mc.appendLineCode0(CodedConstant.getRequiredCheck(field.getOrder(), field.getField()));
        }
        mc.appendLineCode1("return size");
        return mc;
    }

    @Override
    protected String getAccessByField(String target, Field field, Class<?> cls) {
        if (field.getModifiers() == 1) {
            return target + "." + field.getName();
        }
        String getter = "boolean".equalsIgnoreCase(field.getType().getCanonicalName()) ? "is" + CodedConstant.capitalize(field.getName()) : "get" + CodedConstant.capitalize(field.getName());
        try {
            cls.getMethod(getter, new Class[0]);
            return target + "." + getter + "()";
        }
        catch (Exception e) {
            String type;
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug(e.getMessage(), (Throwable)e);
            }
            if ("[B".equals(type = field.getType().getCanonicalName()) || "[Ljava.lang.Byte;".equals(type) || "java.lang.Byte[]".equals(type)) {
                type = "byte[]";
            }
            String code = "(" + FieldUtils.toObjectType(type) + ") ";
            code = code + "FieldUtils.getField(" + target + ", \"" + field.getName() + "\")";
            return code;
        }
    }

    protected String getSetToField(String target, Field field, Class<?> cls, String express, boolean isList, boolean isMap) {
        StringBuilder ret = new StringBuilder();
        if (isList || isMap) {
            ret.append("if ((").append(this.getAccessByField(target, field, cls)).append(") == null) {").append("\n");
        }
        if (Modifier.isPublic(field.getModifiers())) {
            if (isList) {
                ret.append(target).append(".").append(field.getName()).append("= new ArrayList()").append(";\n").append("}").append("\n");
                if (express != null) {
                    ret.append(target).append(".").append(field.getName()).append(".add(").append(express).append(")");
                }
                return ret.toString();
            }
            if (isMap) {
                ret.append(target).append(".").append(field.getName()).append("= new HashMap()").append(";\n").append("}").append("\n");
                return ret.append(express).toString();
            }
            return target + "." + field.getName() + "=" + express + "\n";
        }
        String setter = "set" + CodedConstant.capitalize(field.getName());
        try {
            cls.getMethod(setter, field.getType());
            if (isList) {
                ret.append("List __list = new ArrayList()").append(";\n");
                ret.append(target).append(".").append(setter).append("(__list)").append(";\n").append("}").append("\n");
                if (express != null) {
                    ret.append("(").append(this.getAccessByField(target, field, cls)).append(").add(").append(express).append(")");
                }
                return ret.toString();
            }
            if (isMap) {
                ret.append("Map __map = new HashMap()").append(";\n");
                ret.append(target).append(".").append(setter).append("(__map)").append(";\n").append("}").append("\n");
                return ret + express;
            }
            return target + "." + setter + "(" + express + ")\n";
        }
        catch (Exception e) {
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug(e.getMessage(), (Throwable)e);
            }
            if (isList) {
                ret.append("List __list = new ArrayList()").append(";\n");
                ret.append("FieldUtils.setField(").append(target).append(", \"").append(field.getName()).append("\", __list)").append(";\n").append("}").append("\n");
                if (express != null) {
                    ret.append("(").append(this.getAccessByField(target, field, cls)).append(").add(").append(express).append(")");
                }
                return ret.toString();
            }
            if (isMap) {
                ret.append("Map __map = new HashMap()").append(";\n");
                ret.append("FieldUtils.setField(").append(target).append(", \"").append(field.getName()).append("\", __map)").append(";\n").append("}").append("\n");
                return ret + express;
            }
            String code = "";
            if (express != null) {
                code = "FieldUtils.setField(" + target + ", \"" + field.getName() + "\", " + express + ")" + "\n";
            }
            return code;
        }
    }
}

