/*
 * Decompiled with CFR 0.152.
 */
package com.baidu.bjf.remoting.protobuf.utils;

import com.baidu.bjf.remoting.protobuf.utils.MiniTemplator;
import java.io.IOException;
import java.util.HashMap;

public class MiniTemplatorCache {
    private HashMap<String, MiniTemplator> cache = new HashMap();

    public synchronized MiniTemplator get(MiniTemplator.TemplateSpecification templateSpec) throws IOException, MiniTemplator.TemplateSyntaxException {
        String key = MiniTemplatorCache.generateCacheKey(templateSpec);
        MiniTemplator mt = this.cache.get(key);
        if (mt == null) {
            mt = new MiniTemplator(templateSpec);
            this.cache.put(key, mt);
        }
        return mt.cloneReset();
    }

    private static String generateCacheKey(MiniTemplator.TemplateSpecification templateSpec) {
        StringBuilder key = new StringBuilder(128);
        if (templateSpec.templateText != null) {
            key.append(templateSpec.templateText);
        } else if (templateSpec.templateFileName != null) {
            key.append(templateSpec.templateFileName);
        } else {
            throw new IllegalArgumentException("No templateFileName or templateText specified.");
        }
        if (templateSpec.conditionFlags != null) {
            for (String flag : templateSpec.conditionFlags) {
                key.append('|');
                key.append(flag.toUpperCase());
            }
        }
        return key.toString();
    }

    public synchronized void clear() {
        this.cache.clear();
    }
}

