/*
 * Decompiled with CFR 0.152.
 */
package mybatis.mate.provider;

import com.zaxxer.hikari.HikariConfig;
import com.zaxxer.hikari.HikariDataSource;
import java.sql.SQLException;
import javax.sql.DataSource;
import mybatis.mate.config.DataSourceProperty;
import mybatis.mate.provider.IDataSourceProvider;

public class HikariDataSourceProvider
implements IDataSourceProvider {
    @Override
    public DataSource createDataSource(String string, DataSourceProperty dataSourceProperty) throws SQLException {
        HikariConfig hikariConfig = dataSourceProperty.getHikari();
        if (null == hikariConfig) {
            hikariConfig = new HikariConfig();
            hikariConfig.setConnectionTimeout(60000L);
            hikariConfig.setIdleTimeout(60000L);
            hikariConfig.setValidationTimeout(3000L);
            hikariConfig.setMaxLifetime(60000L);
            hikariConfig.setMaximumPoolSize(100);
            hikariConfig.setMinimumIdle(10);
        }
        hikariConfig.setDriverClassName(dataSourceProperty.getDriverClassName());
        hikariConfig.setJdbcUrl(dataSourceProperty.getUrl());
        hikariConfig.setUsername(dataSourceProperty.getUsername());
        hikariConfig.setPassword(dataSourceProperty.getPassword());
        hikariConfig.setDataSourceJNDI(dataSourceProperty.getJndiName());
        hikariConfig.setSchema(dataSourceProperty.getSchema());
        hikariConfig.setConnectionTestQuery(dataSourceProperty.getTestQuery());
        return new HikariDataSource(hikariConfig);
    }
}

