/*
 * Decompiled with CFR 0.152.
 */
package mybatis.mate.sharding;

import java.sql.Connection;
import java.sql.SQLException;
import java.util.Collections;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Function;
import javax.sql.DataSource;
import mybatis.mate.config.DataSourceProperty;
import mybatis.mate.config.ShardingProperties;
import mybatis.mate.provider.IDataSourceProvider;
import mybatis.mate.sharding.O00000o0;
import mybatis.mate.sharding.ShardingKey;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.jdbc.datasource.AbstractDataSource;
import org.springframework.util.Assert;

public class ShardingDatasource
extends AbstractDataSource {
    private static final Logger log = LoggerFactory.getLogger(ShardingDatasource.class);
    private IDataSourceProvider dataSourceProvider;
    private Map<String, DataSource> dataSources;
    private Map<String, DataSourceProperty> dataSourceProperties;

    public ShardingDatasource(IDataSourceProvider iDataSourceProvider, Map<String, DataSource> map, Map<String, DataSourceProperty> map2, ShardingProperties shardingProperties) {
        this.dataSourceProvider = iDataSourceProvider;
        this.dataSources = map;
        this.dataSourceProperties = map2;
        O00000o0.O000000o(shardingProperties);
    }

    public DataSourceProperty getDataSourcePropertyByKey(String string) {
        return this.dataSourceProperties.get(string);
    }

    public Connection getConnection() throws SQLException {
        return this.determineDataSource().getConnection();
    }

    public Connection getConnection(String string, String string2) throws SQLException {
        return this.determineDataSource().getConnection(string, string2);
    }

    public <T> T unwrap(Class<T> clazz) throws SQLException {
        if (clazz.isInstance((Object)this)) {
            return (T)((Object)this);
        }
        return this.determineDataSource().unwrap(clazz);
    }

    public boolean isWrapperFor(Class<?> clazz) throws SQLException {
        return clazz.isInstance((Object)this) || this.determineDataSource().isWrapperFor(clazz);
    }

    public Map<String, DataSource> getDataSources() {
        Assert.state((this.dataSources != null ? 1 : 0) != 0, (String)"DataSources not resolved yet - call afterPropertiesSet");
        return Collections.unmodifiableMap(this.dataSources);
    }

    public DataSource determineDataSource() {
        Assert.notNull(this.dataSources, (String)"DataSource router not initialized");
        String string = O00000o0.getDatabaseKeyOrElsePrimaryKey();
        log.debug("determineCurrentLookupKey: {}", (Object)string);
        DataSource dataSource = this.dataSources.get(string);
        if (dataSource == null) {
            throw new IllegalStateException("Cannot determine target DataSource for lookup key [" + string + "]");
        }
        return dataSource;
    }

    public void change(String string, Function<String, DataSourceProperty> function) throws SQLException {
        DataSource dataSource = this.getDataSource(string);
        if (null == dataSource) {
            this.addDataSource(string, this.dataSourceProvider.createDataSource(string, function.apply(string)));
        }
        ShardingKey.change(string);
    }

    public DataSource getDataSource(String string) {
        return null == this.dataSources ? null : this.dataSources.get(string);
    }

    public ShardingDatasource addDataSource(String string, DataSource dataSource) {
        if (null == this.dataSources && this.dataSources.isEmpty()) {
            this.dataSources = new ConcurrentHashMap<String, DataSource>();
        }
        this.dataSources.put(string, dataSource);
        return this;
    }

    public ShardingDatasource removeDataSource(String string) {
        if (null != this.dataSources && null != this.dataSources.get(string)) {
            this.dataSources.remove(string);
        }
        return this;
    }
}

