/*
 * Decompiled with CFR 0.152.
 */
package com.blazebit.persistence;

import com.blazebit.persistence.DefaultKeyset;
import com.blazebit.persistence.Keyset;
import com.blazebit.persistence.KeysetPage;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class DefaultKeysetPage
implements KeysetPage {
    private static final long serialVersionUID = 1L;
    private final int firstResult;
    private final int maxResults;
    private final Keyset lowest;
    private final Keyset highest;
    private final List<Keyset> keysets;

    public DefaultKeysetPage(int firstResult, int maxResults, Serializable[] lowest, Serializable[] highest, Serializable[][] keysets) {
        this(firstResult, maxResults, new DefaultKeyset(lowest), new DefaultKeyset(highest), DefaultKeysetPage.keysets(keysets));
    }

    public DefaultKeysetPage(int firstResult, int maxResults, Keyset lowest, Keyset highest) {
        this.firstResult = firstResult;
        this.maxResults = maxResults;
        this.lowest = lowest;
        this.highest = highest;
        ArrayList<Keyset> keysets = new ArrayList<Keyset>(2);
        if (lowest != null) {
            keysets.add(lowest);
        }
        if (highest != null) {
            keysets.add(highest);
        }
        this.keysets = keysets;
    }

    public DefaultKeysetPage(int firstResult, int maxResults, Keyset lowest, Keyset highest, List<Keyset> keysets) {
        this.firstResult = firstResult;
        this.maxResults = maxResults;
        this.lowest = lowest;
        this.highest = highest;
        this.keysets = keysets;
    }

    private static List<Keyset> keysets(Serializable[][] keysets) {
        if (keysets == null || keysets.length == 0) {
            return Collections.emptyList();
        }
        ArrayList<Keyset> list = new ArrayList<Keyset>(keysets.length);
        for (Serializable[] keyset : keysets) {
            list.add(new DefaultKeyset(keyset));
        }
        return list;
    }

    @Override
    public int getFirstResult() {
        return this.firstResult;
    }

    @Override
    public int getMaxResults() {
        return this.maxResults;
    }

    @Override
    public Keyset getLowest() {
        return this.lowest;
    }

    @Override
    public Keyset getHighest() {
        return this.highest;
    }

    @Override
    public List<Keyset> getKeysets() {
        return this.keysets;
    }
}

