/*
 * Decompiled with CFR 0.152.
 */
package com.blazebit.persistence.impl;

import com.blazebit.persistence.parser.expression.AbortableVisitorAdapter;
import com.blazebit.persistence.parser.expression.Expression;
import com.blazebit.persistence.parser.expression.FunctionExpression;
import com.blazebit.persistence.parser.expression.PathExpression;
import com.blazebit.persistence.parser.predicate.CompoundPredicate;
import com.blazebit.persistence.parser.predicate.IsNullPredicate;

public class ConjunctionPathExpressionFindingVisitor
extends AbortableVisitorAdapter {
    private PathExpression pathExpression;
    private boolean disjunction;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isInConjunction(CompoundPredicate predicate, PathExpression pathExpression) {
        this.pathExpression = pathExpression;
        this.disjunction = false;
        try {
            predicate.accept((Expression.ResultVisitor)this);
            boolean bl = !this.disjunction;
            return bl;
        }
        finally {
            this.pathExpression = null;
        }
    }

    public Boolean visit(PathExpression expression) {
        if (this.pathExpression == expression) {
            return true;
        }
        return super.visit(expression);
    }

    public Boolean visit(IsNullPredicate predicate) {
        if (super.visit(predicate).booleanValue()) {
            this.disjunction = true;
            return true;
        }
        return false;
    }

    public Boolean visit(FunctionExpression expression) {
        if (super.visit(expression).booleanValue()) {
            if ("COALESCE".equalsIgnoreCase(expression.getFunctionName()) || "NULLIF".equalsIgnoreCase(expression.getFunctionName())) {
                this.disjunction = true;
            }
            return true;
        }
        return false;
    }

    public Boolean visit(CompoundPredicate predicate) {
        if (super.visit(predicate).booleanValue()) {
            this.disjunction = this.disjunction || predicate.getOperator() == CompoundPredicate.BooleanOperator.OR ^ predicate.isNegated();
            return true;
        }
        return false;
    }
}

