/*
 * Decompiled with CFR 0.152.
 */
package com.blazebit.persistence.impl;

import com.blazebit.persistence.impl.AliasManager;
import com.blazebit.persistence.impl.ClauseType;
import com.blazebit.persistence.impl.ExpressionUtils;
import com.blazebit.persistence.impl.ParameterManager;
import com.blazebit.persistence.impl.SelectInfo;
import com.blazebit.persistence.impl.SubqueryInternalBuilder;
import com.blazebit.persistence.parser.expression.AbortableVisitorAdapter;
import com.blazebit.persistence.parser.expression.AggregateExpression;
import com.blazebit.persistence.parser.expression.ArithmeticExpression;
import com.blazebit.persistence.parser.expression.ArithmeticFactor;
import com.blazebit.persistence.parser.expression.ArrayExpression;
import com.blazebit.persistence.parser.expression.DateLiteral;
import com.blazebit.persistence.parser.expression.EntityLiteral;
import com.blazebit.persistence.parser.expression.EnumLiteral;
import com.blazebit.persistence.parser.expression.Expression;
import com.blazebit.persistence.parser.expression.FunctionExpression;
import com.blazebit.persistence.parser.expression.GeneralCaseExpression;
import com.blazebit.persistence.parser.expression.ListIndexExpression;
import com.blazebit.persistence.parser.expression.LiteralExpression;
import com.blazebit.persistence.parser.expression.MapEntryExpression;
import com.blazebit.persistence.parser.expression.MapKeyExpression;
import com.blazebit.persistence.parser.expression.MapValueExpression;
import com.blazebit.persistence.parser.expression.NullExpression;
import com.blazebit.persistence.parser.expression.NumericLiteral;
import com.blazebit.persistence.parser.expression.ParameterExpression;
import com.blazebit.persistence.parser.expression.PathExpression;
import com.blazebit.persistence.parser.expression.PropertyExpression;
import com.blazebit.persistence.parser.expression.SimpleCaseExpression;
import com.blazebit.persistence.parser.expression.StringLiteral;
import com.blazebit.persistence.parser.expression.SubqueryExpression;
import com.blazebit.persistence.parser.expression.TimeLiteral;
import com.blazebit.persistence.parser.expression.TimestampLiteral;
import com.blazebit.persistence.parser.expression.TreatExpression;
import com.blazebit.persistence.parser.expression.TrimExpression;
import com.blazebit.persistence.parser.expression.VisitorAdapter;
import com.blazebit.persistence.parser.expression.WhenClauseExpression;
import com.blazebit.persistence.parser.predicate.BetweenPredicate;
import com.blazebit.persistence.parser.predicate.BinaryExpressionPredicate;
import com.blazebit.persistence.parser.predicate.BooleanLiteral;
import com.blazebit.persistence.parser.predicate.CompoundPredicate;
import com.blazebit.persistence.parser.predicate.InPredicate;
import com.blazebit.persistence.parser.predicate.IsEmptyPredicate;
import com.blazebit.persistence.parser.predicate.IsNullPredicate;
import com.blazebit.persistence.parser.predicate.Predicate;
import com.blazebit.persistence.spi.DbmsDialect;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;

class GroupByExpressionGatheringVisitor
extends AbortableVisitorAdapter {
    private final boolean treatSizeAsAggregate;
    private final AliasManager aliasManager;
    private final ParameterManager parameterManager;
    private final DbmsDialect dbmsDialect;
    private final Set<Expression> expressions = new LinkedHashSet<Expression>();
    private boolean collect;

    public GroupByExpressionGatheringVisitor(boolean treatSizeAsAggregate, AliasManager aliasManager, ParameterManager parameterManager, DbmsDialect dbmsDialect) {
        this.treatSizeAsAggregate = treatSizeAsAggregate;
        this.aliasManager = aliasManager;
        this.parameterManager = parameterManager;
        this.dbmsDialect = dbmsDialect;
    }

    public void clear() {
        this.expressions.clear();
        this.collect = false;
    }

    private boolean setCollect(boolean collect) {
        boolean oldCollect = this.collect;
        this.collect = collect;
        return oldCollect;
    }

    public Set<Expression> extractGroupByExpressions(Expression expression, ClauseType clauseType) {
        if (expression instanceof LiteralExpression || expression instanceof ParameterExpression) {
            return Collections.emptySet();
        }
        this.clear();
        try {
            this.collect = expression instanceof Predicate;
            boolean expressionWasSplit = (Boolean)expression.accept((Expression.ResultVisitor)this);
            if (clauseType == ClauseType.HAVING && !this.dbmsDialect.supportsGroupByExpressionInHavingMatching()) {
                expression.accept((Expression.Visitor)new VisitorAdapter(){

                    public void visit(FunctionExpression expression) {
                        if (expression instanceof AggregateExpression || GroupByExpressionGatheringVisitor.this.treatSizeAsAggregate && com.blazebit.persistence.parser.util.ExpressionUtils.isSizeFunction((FunctionExpression)expression)) {
                            return;
                        }
                        super.visit(expression);
                    }

                    public void visit(SubqueryExpression expression) {
                        GroupByExpressionGatheringVisitor.this.visit(expression);
                    }

                    public void visit(PathExpression expression) {
                        if (expression.getBaseNode() == null) {
                            ((SelectInfo)GroupByExpressionGatheringVisitor.this.aliasManager.getAliasInfo(expression.toString())).getExpression().accept((Expression.Visitor)this);
                        } else {
                            GroupByExpressionGatheringVisitor.this.expressions.add(expression);
                        }
                    }

                    public void visit(TreatExpression expression) {
                        GroupByExpressionGatheringVisitor.this.expressions.add(expression);
                    }

                    public void visit(PropertyExpression expression) {
                        GroupByExpressionGatheringVisitor.this.expressions.add(expression);
                    }

                    public void visit(ListIndexExpression expression) {
                        GroupByExpressionGatheringVisitor.this.expressions.add(expression);
                    }

                    public void visit(MapEntryExpression expression) {
                        GroupByExpressionGatheringVisitor.this.expressions.add(expression);
                    }

                    public void visit(MapKeyExpression expression) {
                        GroupByExpressionGatheringVisitor.this.expressions.add(expression);
                    }

                    public void visit(MapValueExpression expression) {
                        GroupByExpressionGatheringVisitor.this.expressions.add(expression);
                    }
                });
                return this.expressions;
            }
            if (expressionWasSplit) {
                return this.expressions;
            }
        }
        catch (IllegalParameterException ex) {
            throw new IllegalArgumentException("Can't use the expression '" + expression + "' as an implicit group by clause, because the parameter '" + ex.parameterExpression + "' with the value '" + ex.value + "' can't be rendered as literal which is required!", ex);
        }
        return Collections.singleton(expression);
    }

    private Boolean baseExpression(Expression expression) {
        if (this.collect) {
            this.expressions.add(expression);
        }
        return false;
    }

    public Boolean visit(PathExpression expression) {
        if (expression.getBaseNode() == null) {
            return (Boolean)((SelectInfo)this.aliasManager.getAliasInfo(expression.toString())).getExpression().accept((Expression.ResultVisitor)this);
        }
        return this.baseExpression((Expression)expression);
    }

    public Boolean visit(ArrayExpression expression) {
        throw new IllegalArgumentException("At this point array expressions are not allowed anymore!");
    }

    public Boolean visit(TreatExpression expression) {
        return this.baseExpression((Expression)expression);
    }

    public Boolean visit(PropertyExpression expression) {
        return this.baseExpression((Expression)expression);
    }

    public Boolean visit(ListIndexExpression expression) {
        return this.baseExpression((Expression)expression);
    }

    public Boolean visit(MapEntryExpression expression) {
        return this.baseExpression((Expression)expression);
    }

    public Boolean visit(MapKeyExpression expression) {
        return this.baseExpression((Expression)expression);
    }

    public Boolean visit(MapValueExpression expression) {
        return this.baseExpression((Expression)expression);
    }

    public Boolean visit(ParameterExpression expression) {
        if (this.collect) {
            return false;
        }
        String literalParameterValue = this.parameterManager.getLiteralParameterValue(expression, true);
        if (literalParameterValue == null) {
            throw new IllegalParameterException(expression, this.parameterManager.getParameterValue(expression.getName()));
        }
        this.parameterManager.getParameter(expression.getName()).setUsedInImplicitGroupBy(true);
        return false;
    }

    public Boolean visit(SubqueryExpression expression) {
        if (!(expression.getSubquery() instanceof SubqueryInternalBuilder)) {
            throw new IllegalArgumentException("Unexpected subquery subtype: " + expression.getSubquery());
        }
        SubqueryInternalBuilder builder = (SubqueryInternalBuilder)expression.getSubquery();
        this.expressions.addAll(builder.getCorrelatedExpressions(this.aliasManager));
        return true;
    }

    public Boolean visit(ArithmeticFactor expression) {
        boolean oldCollect = this.setCollect(false);
        if (((Boolean)expression.getExpression().accept((Expression.ResultVisitor)this)).booleanValue()) {
            this.setCollect(oldCollect);
            return true;
        }
        this.setCollect(oldCollect);
        if (oldCollect) {
            this.expressions.add((Expression)expression);
        }
        return false;
    }

    public Boolean visit(FunctionExpression expression) {
        if (expression instanceof AggregateExpression || this.treatSizeAsAggregate && com.blazebit.persistence.parser.util.ExpressionUtils.isSizeFunction((FunctionExpression)expression)) {
            return true;
        }
        if (this.collect) {
            String functionName = ExpressionUtils.isFunctionFunctionExpression(expression) ? ((StringLiteral)expression.getExpressions().get(0)).getValue() : expression.getFunctionName();
            switch (functionName.toUpperCase()) {
                case "CURRENT_DATE": 
                case "CURRENT_TIME": 
                case "CURRENT_TIMESTAMP": {
                    return true;
                }
            }
        }
        boolean oldCollect = this.setCollect(false);
        List expressions = expression.getExpressions();
        int size = expressions.size();
        for (int i = 0; i < size; ++i) {
            if (!((Boolean)((Expression)expressions.get(i)).accept((Expression.ResultVisitor)this)).booleanValue()) continue;
            this.collectExpressions(expressions, 0, i);
            this.collectExpressions(expressions, i + 1, size);
            this.setCollect(oldCollect);
            return true;
        }
        this.setCollect(oldCollect);
        if (expression.getResolvedWindowDefinition() != null) {
            return true;
        }
        if (oldCollect) {
            this.expressions.add((Expression)expression);
        }
        return false;
    }

    public Boolean visit(GeneralCaseExpression expression) {
        List expressions = expression.getWhenClauses();
        int size = expressions.size();
        boolean oldCollect = this.setCollect(false);
        for (int i = 0; i < size; ++i) {
            if (!((Boolean)((WhenClauseExpression)expressions.get(i)).accept((Expression.ResultVisitor)this)).booleanValue()) continue;
            this.setCollect(true);
            this.collectExpressions(expressions, 0, i);
            this.collectExpressions(expressions, i + 1, size);
            if (expression.getDefaultExpr() != null) {
                expression.getDefaultExpr().accept((Expression.ResultVisitor)this);
            }
            this.setCollect(oldCollect);
            return true;
        }
        if (expression.getDefaultExpr() != null && ((Boolean)expression.getDefaultExpr().accept((Expression.ResultVisitor)this)).booleanValue()) {
            this.collectExpressions(expressions, 0, size);
            this.setCollect(oldCollect);
            return true;
        }
        this.setCollect(oldCollect);
        if (oldCollect) {
            this.expressions.add((Expression)expression);
        }
        return false;
    }

    public Boolean visit(SimpleCaseExpression expression) {
        List expressions = expression.getWhenClauses();
        int size = expressions.size();
        boolean oldCollect = this.setCollect(false);
        if (((Boolean)expression.getCaseOperand().accept((Expression.ResultVisitor)this)).booleanValue()) {
            this.setCollect(true);
            this.collectExpressions(expressions, 0, size);
            if (expression.getDefaultExpr() != null) {
                expression.getDefaultExpr().accept((Expression.ResultVisitor)this);
            }
            this.setCollect(oldCollect);
            return true;
        }
        for (int i = 0; i < size; ++i) {
            if (!((Boolean)((WhenClauseExpression)expressions.get(i)).accept((Expression.ResultVisitor)this)).booleanValue()) continue;
            this.setCollect(true);
            expression.getCaseOperand().accept((Expression.ResultVisitor)this);
            this.collectExpressions(expressions, 0, i);
            this.collectExpressions(expressions, i + 1, size);
            if (expression.getDefaultExpr() != null) {
                expression.getDefaultExpr().accept((Expression.ResultVisitor)this);
            }
            this.setCollect(oldCollect);
            return true;
        }
        if (expression.getDefaultExpr() != null && ((Boolean)expression.getDefaultExpr().accept((Expression.ResultVisitor)this)).booleanValue()) {
            this.setCollect(true);
            expression.getCaseOperand().accept((Expression.ResultVisitor)this);
            this.collectExpressions(expressions, 0, size);
            this.setCollect(oldCollect);
            return true;
        }
        this.setCollect(oldCollect);
        if (oldCollect) {
            this.expressions.add((Expression)expression);
        }
        return false;
    }

    public Boolean visit(WhenClauseExpression expression) {
        boolean oldCollect = this.setCollect(false);
        if (((Boolean)expression.getCondition().accept((Expression.ResultVisitor)this)).booleanValue()) {
            this.collectExpressions(expression.getResult());
            this.setCollect(oldCollect);
            return true;
        }
        if (((Boolean)expression.getResult().accept((Expression.ResultVisitor)this)).booleanValue()) {
            this.collectExpressions(expression.getCondition());
            this.setCollect(oldCollect);
            return true;
        }
        this.setCollect(oldCollect);
        if (oldCollect) {
            expression.getCondition().accept((Expression.ResultVisitor)this);
            expression.getResult().accept((Expression.ResultVisitor)this);
        }
        return false;
    }

    public Boolean visit(TrimExpression expression) {
        boolean oldCollect = this.setCollect(false);
        if (expression.getTrimCharacter() != null && ((Boolean)expression.getTrimCharacter().accept((Expression.ResultVisitor)this)).booleanValue()) {
            this.collectExpressions(expression.getTrimSource());
            this.setCollect(oldCollect);
            return true;
        }
        if (((Boolean)expression.getTrimSource().accept((Expression.ResultVisitor)this)).booleanValue()) {
            if (expression.getTrimCharacter() != null) {
                this.collectExpressions(expression.getTrimCharacter());
            }
            this.setCollect(oldCollect);
            return true;
        }
        this.setCollect(oldCollect);
        if (oldCollect) {
            this.expressions.add((Expression)expression);
        }
        return false;
    }

    public Boolean visit(ArithmeticExpression expression) {
        boolean oldCollect = this.setCollect(false);
        if (((Boolean)expression.getLeft().accept((Expression.ResultVisitor)this)).booleanValue()) {
            this.collectExpressions(expression.getRight());
            this.setCollect(oldCollect);
            return true;
        }
        if (((Boolean)expression.getRight().accept((Expression.ResultVisitor)this)).booleanValue()) {
            this.collectExpressions(expression.getLeft());
            this.setCollect(oldCollect);
            return true;
        }
        this.setCollect(oldCollect);
        if (oldCollect) {
            this.expressions.add((Expression)expression);
        }
        return false;
    }

    public Boolean visit(IsNullPredicate predicate) {
        if (this.collect) {
            predicate.getExpression().accept((Expression.ResultVisitor)this);
            return true;
        }
        return (Boolean)predicate.getExpression().accept((Expression.ResultVisitor)this);
    }

    public Boolean visit(IsEmptyPredicate predicate) {
        if (this.collect) {
            predicate.getExpression().accept((Expression.ResultVisitor)this);
            return true;
        }
        return (Boolean)predicate.getExpression().accept((Expression.ResultVisitor)this);
    }

    public Boolean visit(BetweenPredicate predicate) {
        if (this.collect) {
            predicate.getLeft().accept((Expression.ResultVisitor)this);
            predicate.getStart().accept((Expression.ResultVisitor)this);
            predicate.getEnd().accept((Expression.ResultVisitor)this);
            return true;
        }
        if (((Boolean)predicate.getLeft().accept((Expression.ResultVisitor)this)).booleanValue()) {
            this.collectExpressions(predicate.getStart());
            this.collectExpressions(predicate.getEnd());
            return true;
        }
        if (((Boolean)predicate.getStart().accept((Expression.ResultVisitor)this)).booleanValue()) {
            this.collectExpressions(predicate.getLeft());
            this.collectExpressions(predicate.getEnd());
            return true;
        }
        if (((Boolean)predicate.getEnd().accept((Expression.ResultVisitor)this)).booleanValue()) {
            this.collectExpressions(predicate.getLeft());
            this.collectExpressions(predicate.getStart());
            return true;
        }
        return false;
    }

    public Boolean visit(InPredicate predicate) {
        List expressions = predicate.getRight();
        int size = expressions.size();
        if (this.collect) {
            predicate.getLeft().accept((Expression.ResultVisitor)this);
            for (int i = 0; i < size; ++i) {
                ((Expression)expressions.get(i)).accept((Expression.ResultVisitor)this);
            }
            return true;
        }
        if (((Boolean)predicate.getLeft().accept((Expression.ResultVisitor)this)).booleanValue()) {
            this.collectExpressions(expressions);
            return true;
        }
        for (int i = 0; i < size; ++i) {
            if (!((Boolean)((Expression)expressions.get(i)).accept((Expression.ResultVisitor)this)).booleanValue()) continue;
            this.collectExpressions(predicate.getLeft());
            this.collectExpressions(expressions, 0, i);
            this.collectExpressions(expressions, i + 1, size);
            return true;
        }
        return false;
    }

    protected Boolean visit(BinaryExpressionPredicate predicate) {
        if (this.collect) {
            predicate.getLeft().accept((Expression.ResultVisitor)this);
            predicate.getRight().accept((Expression.ResultVisitor)this);
            return true;
        }
        if (((Boolean)predicate.getLeft().accept((Expression.ResultVisitor)this)).booleanValue()) {
            this.collectExpressions(predicate.getRight());
            return true;
        }
        if (((Boolean)predicate.getRight().accept((Expression.ResultVisitor)this)).booleanValue()) {
            this.collectExpressions(predicate.getLeft());
            return true;
        }
        return false;
    }

    public Boolean visit(CompoundPredicate predicate) {
        List children = predicate.getChildren();
        int size = children.size();
        if (this.collect) {
            for (int i = 0; i < size; ++i) {
                ((Predicate)children.get(i)).accept((Expression.ResultVisitor)this);
            }
            return true;
        }
        for (int i = 0; i < size; ++i) {
            if (!((Boolean)((Predicate)children.get(i)).accept((Expression.ResultVisitor)this)).booleanValue()) continue;
            this.collectExpressions(children, 0, i);
            this.collectExpressions(children, i + 1, size);
            return true;
        }
        return false;
    }

    public Boolean visit(NullExpression expression) {
        return false;
    }

    public Boolean visit(NumericLiteral expression) {
        return false;
    }

    public Boolean visit(BooleanLiteral expression) {
        return false;
    }

    public Boolean visit(StringLiteral expression) {
        return false;
    }

    public Boolean visit(DateLiteral expression) {
        return false;
    }

    public Boolean visit(TimeLiteral expression) {
        return false;
    }

    public Boolean visit(TimestampLiteral expression) {
        return false;
    }

    public Boolean visit(EnumLiteral expression) {
        return false;
    }

    public Boolean visit(EntityLiteral expression) {
        return false;
    }

    private void collectExpressions(Expression expression) {
        boolean oldCollect = this.setCollect(true);
        expression.accept((Expression.ResultVisitor)this);
        this.setCollect(oldCollect);
    }

    private void collectExpressions(List<? extends Expression> expressions) {
        this.collectExpressions(expressions, 0, expressions.size());
    }

    private void collectExpressions(List<? extends Expression> expressions, int start, int end) {
        if (start >= end) {
            return;
        }
        boolean oldCollect = this.setCollect(true);
        for (int i = start; i < end; ++i) {
            expressions.get(i).accept((Expression.ResultVisitor)this);
        }
        this.setCollect(oldCollect);
    }

    private static class IllegalParameterException
    extends RuntimeException {
        private final ParameterExpression parameterExpression;
        private final Object value;

        public IllegalParameterException(ParameterExpression parameterExpression, Object value) {
            this.parameterExpression = parameterExpression;
            this.value = value;
        }
    }
}

