/*
 * Decompiled with CFR 0.152.
 */
package com.blazebit.persistence.impl;

import com.blazebit.persistence.impl.ImplicitJoinNotAllowedException;
import com.blazebit.persistence.parser.expression.Expression;
import com.blazebit.persistence.parser.expression.ExpressionCopyContext;
import com.blazebit.persistence.parser.expression.InplaceModificationResultVisitorAdapter;
import com.blazebit.persistence.parser.expression.PathElementExpression;
import com.blazebit.persistence.parser.expression.PathExpression;
import com.blazebit.persistence.parser.expression.PropertyExpression;
import com.blazebit.persistence.parser.expression.TreatExpression;
import com.blazebit.persistence.parser.predicate.EqPredicate;
import com.blazebit.persistence.parser.predicate.Predicate;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.ListIterator;
import java.util.Map;

public class ImplicitJoinCorrelationPathReplacementVisitor
extends InplaceModificationResultVisitorAdapter {
    private final Map<PathExpression, CorrelationTransformEntry> pathIdentitiesToCorrelate = new IdentityHashMap<PathExpression, CorrelationTransformEntry>();
    private final Map<String, CorrelationTransformEntry> pathsToCorrelate = new HashMap<String, CorrelationTransformEntry>();
    private final Map<String, RootCorrelationEntry> rootsToCorrelate = new HashMap<String, RootCorrelationEntry>();

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void addPathExpression(PathExpression pathExpression, ImplicitJoinNotAllowedException ex, boolean isInConjunction) {
        String correlationExpression;
        CorrelationTransformEntry existingEntry;
        if (this.pathIdentitiesToCorrelate.containsKey(pathExpression)) return;
        StringBuilder sb = new StringBuilder();
        if (ex.getTreatType() != null) {
            sb.append("TREAT(");
        }
        if (isInConjunction) {
            ex.getBaseNode().appendAlias(sb, true, false);
        } else {
            String syntheticAlias = "_synthetic_" + ex.getBaseNode().getAlias();
            ArrayList<PropertyExpression> list1 = new ArrayList<PropertyExpression>(1);
            list1.add(new PropertyExpression(syntheticAlias));
            ArrayList<PropertyExpression> list2 = new ArrayList<PropertyExpression>(1);
            list2.add(new PropertyExpression(ex.getBaseNode().getAlias()));
            EqPredicate predicate = new EqPredicate((Expression)new PathExpression(list1), (Expression)new PathExpression(list2));
            this.rootsToCorrelate.put(syntheticAlias, new RootCorrelationEntry(syntheticAlias, ex.getBaseNode().getNodeType().getJavaType(), (Predicate)predicate));
            sb.append(syntheticAlias);
        }
        sb.append('.');
        sb.append(ex.getJoinRelationName());
        if (ex.getTreatType() != null) {
            sb.append(" AS ").append(ex.getTreatType()).append(')');
        }
        String alias = (existingEntry = this.pathsToCorrelate.get(correlationExpression = sb.toString())) != null ? existingEntry.alias : "_synth_subquery_" + this.pathIdentitiesToCorrelate.size();
        PathExpression transformedExpression = (PathExpression)pathExpression.copy(ExpressionCopyContext.EMPTY);
        if (transformedExpression.getExpressions().get(0) instanceof TreatExpression) {
            TreatExpression treatExpression = (TreatExpression)transformedExpression.getExpressions().get(0);
            if (treatExpression.getType().equals(ex.getTreatType())) {
                PathExpression pathExpressionToModify = (PathExpression)treatExpression.getExpression();
                this.removeMatchingJoinAttributePathElements(ex, pathExpressionToModify);
                if (!pathExpressionToModify.getExpressions().isEmpty()) throw new IllegalArgumentException("Can't transform nested TREAT expression: " + pathExpression);
                transformedExpression.getExpressions().set(0, new PropertyExpression(alias));
            } else {
                PathExpression pathExpressionToModify = (PathExpression)treatExpression.getExpression();
                if ((ex.getBaseNode().getTreatType() == null && ex.getBaseNode().getEntityType().getName().equals(treatExpression.getType()) || ex.getBaseNode().getTreatType() != null && ex.getBaseNode().getTreatType().getName().equals(treatExpression.getType())) && pathExpressionToModify.getExpressions().size() == 1 && ex.getBaseNode().getAlias().equals(((PathElementExpression)pathExpressionToModify.getExpressions().get(0)).toString())) {
                    this.removeMatchingJoinAttributePathElements(ex, transformedExpression);
                    transformedExpression.getExpressions().add(0, new PropertyExpression(alias));
                } else {
                    this.removeMatchingJoinAttributePathElements(ex, pathExpressionToModify);
                    pathExpressionToModify.getExpressions().add(0, new PropertyExpression(alias));
                }
            }
        } else {
            this.removeMatchingJoinAttributePathElements(ex, transformedExpression);
            transformedExpression.getExpressions().add(0, new PropertyExpression(alias));
        }
        CorrelationTransformEntry correlationTransformEntry = new CorrelationTransformEntry(alias, correlationExpression, transformedExpression, isInConjunction);
        this.pathIdentitiesToCorrelate.put(pathExpression, correlationTransformEntry);
        if (existingEntry != null) return;
        this.pathsToCorrelate.put(correlationExpression, correlationTransformEntry);
    }

    private void removeMatchingJoinAttributePathElements(ImplicitJoinNotAllowedException ex, PathExpression pathExpressionToModify) {
        ListIterator pathElementExpressionListIterator = pathExpressionToModify.getExpressions().listIterator();
        Iterator<String> joinRelationAttributesIterator = ex.getJoinRelationAttributes().iterator();
        String joinRelationAttribute = joinRelationAttributesIterator.next();
        while (pathElementExpressionListIterator.hasNext() && joinRelationAttribute != null) {
            PathElementExpression elementExpression = (PathElementExpression)pathElementExpressionListIterator.next();
            pathElementExpressionListIterator.remove();
            if (!joinRelationAttribute.equals(elementExpression.toString())) continue;
            joinRelationAttribute = joinRelationAttributesIterator.hasNext() ? joinRelationAttributesIterator.next() : null;
        }
    }

    public Collection<CorrelationTransformEntry> getPathsToCorrelate() {
        return this.pathsToCorrelate.values();
    }

    public Collection<RootCorrelationEntry> getRootsToCorrelate() {
        return this.rootsToCorrelate.values();
    }

    public Predicate rewritePredicate(Predicate predicate) {
        Predicate newPredicate = (Predicate)predicate.accept((Expression.ResultVisitor)this);
        this.pathIdentitiesToCorrelate.clear();
        this.pathsToCorrelate.clear();
        this.rootsToCorrelate.clear();
        return newPredicate;
    }

    public Expression visit(PathExpression expression) {
        CorrelationTransformEntry entry = this.pathIdentitiesToCorrelate.get(expression);
        if (entry == null) {
            return super.visit(expression);
        }
        return entry.transformedExpression;
    }

    public static class RootCorrelationEntry {
        private final String alias;
        private final Class<?> entityClass;
        private final Predicate additionalPredicate;

        public RootCorrelationEntry(String alias, Class<?> entityClass, Predicate additionalPredicate) {
            this.alias = alias;
            this.entityClass = entityClass;
            this.additionalPredicate = additionalPredicate;
        }

        public String getAlias() {
            return this.alias;
        }

        public Class<?> getEntityClass() {
            return this.entityClass;
        }

        public Predicate getAdditionalPredicate() {
            return this.additionalPredicate;
        }
    }

    public static class CorrelationTransformEntry {
        private final String alias;
        private final String correlationExpression;
        private final PathExpression transformedExpression;
        private final boolean isInConjunction;

        public CorrelationTransformEntry(String alias, String correlationExpression, PathExpression transformedExpression, boolean isInConjunction) {
            this.alias = alias;
            this.correlationExpression = correlationExpression;
            this.transformedExpression = transformedExpression;
            this.isInConjunction = isInConjunction;
        }

        public String getAlias() {
            return this.alias;
        }

        public String getCorrelationExpression() {
            return this.correlationExpression;
        }

        public PathExpression getTransformedExpression() {
            return this.transformedExpression;
        }

        public boolean isInConjunction() {
            return this.isInConjunction;
        }
    }
}

