/*
 * Decompiled with CFR 0.152.
 */
package com.blazebit.persistence.impl;

import com.blazebit.persistence.DefaultKeysetPage;
import com.blazebit.persistence.KeysetPage;
import com.blazebit.persistence.ObjectBuilder;
import com.blazebit.persistence.PagedArrayList;
import com.blazebit.persistence.PagedList;
import com.blazebit.persistence.PaginatedTypedQuery;
import com.blazebit.persistence.impl.ParameterManager;
import com.blazebit.persistence.impl.builder.object.CountExtractionObjectBuilder;
import com.blazebit.persistence.impl.builder.object.KeysetExtractionObjectBuilder;
import com.blazebit.persistence.impl.keyset.KeysetMode;
import com.blazebit.persistence.impl.keyset.KeysetPaginationHelper;
import com.blazebit.persistence.impl.util.SetView;
import jakarta.persistence.FlushModeType;
import jakarta.persistence.LockModeType;
import jakarta.persistence.NoResultException;
import jakarta.persistence.NonUniqueResultException;
import jakarta.persistence.Parameter;
import jakarta.persistence.PersistenceException;
import jakarta.persistence.Query;
import jakarta.persistence.TemporalType;
import jakarta.persistence.TypedQuery;
import jakarta.persistence.criteria.ParameterExpression;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class PaginatedTypedQueryImpl<X>
implements PaginatedTypedQuery<X> {
    private final boolean withExtractAllKeysets;
    private final boolean withCount;
    private final boolean boundedCount;
    private final int highestOffset;
    private final TypedQuery<?> countQuery;
    private final Query idQuery;
    private final TypedQuery<X> objectQuery;
    private final ObjectBuilder<X> objectBuilder;
    private final Map<String, Parameter<?>> parameters;
    private final Map<String, ParameterLocation> parameterToQuery;
    private final Map<ParameterExpression<?>, String> criteriaNameMapping;
    private final Object entityId;
    private int firstResult;
    private int pageSize;
    private final int identifierCount;
    private final boolean needsNewIdList;
    private final int[] keysetToSelectIndexMapping;
    private final int keysetSuffix;
    private final KeysetMode keysetMode;
    private final KeysetPage keysetPage;
    private final boolean forceFirstResult;
    private final boolean inlinedIdQuery;
    private final boolean inlinedCountQuery;

    /*
     * WARNING - void declaration
     */
    public PaginatedTypedQueryImpl(boolean withExtractAllKeysets, boolean withCount, boolean boundedCount, int highestOffset, TypedQuery<?> countQuery, Query idQuery, TypedQuery<X> objectQuery, ObjectBuilder<X> objectBuilder, Collection<ParameterManager.ParameterImpl<?>> parameters, Map<ParameterExpression<?>, String> criteriaNameMapping, Object entityId, int firstResult, int pageSize, int identifierCount, boolean needsNewIdList, int[] keysetToSelectIndexMapping, KeysetMode keysetMode, KeysetPage keysetPage, boolean forceFirstResult, boolean inlinedIdQuery, boolean inlinedCountQuery) {
        ParameterLocation parameterLocation;
        String name;
        this.withExtractAllKeysets = withExtractAllKeysets;
        this.withCount = withCount;
        this.boundedCount = boundedCount;
        this.highestOffset = highestOffset;
        this.countQuery = countQuery;
        this.idQuery = idQuery;
        this.objectQuery = objectQuery;
        this.objectBuilder = objectBuilder;
        this.parameterToQuery = new HashMap<String, ParameterLocation>(parameters.size());
        this.entityId = entityId;
        this.firstResult = firstResult;
        this.pageSize = pageSize;
        this.identifierCount = identifierCount;
        this.needsNewIdList = needsNewIdList;
        this.keysetToSelectIndexMapping = keysetToSelectIndexMapping;
        this.keysetMode = keysetMode;
        this.keysetPage = keysetPage;
        this.forceFirstResult = forceFirstResult;
        this.inlinedIdQuery = inlinedIdQuery;
        this.inlinedCountQuery = inlinedCountQuery;
        this.criteriaNameMapping = criteriaNameMapping;
        HashMap params = new HashMap(parameters.size());
        for (ParameterManager.ParameterImpl<?> parameterImpl : parameters) {
            name = parameterImpl.getName();
            if (name == null) {
                name = parameterImpl.getPosition().toString();
            }
            if (parameterImpl.getCriteriaParameter() == null) {
                params.put(name, parameterImpl);
                continue;
            }
            params.put(name, (ParameterManager.ParameterImpl<?>)parameterImpl.getCriteriaParameter());
        }
        this.parameters = Collections.unmodifiableMap(params);
        for (Parameter parameter : countQuery.getParameters()) {
            this.parameterToQuery.put(this.getParameterName(parameter), ParameterLocation.COUNT);
        }
        if (idQuery != null) {
            for (Parameter parameter : idQuery.getParameters()) {
                name = this.getParameterName(parameter);
                parameterLocation = this.parameterToQuery.get(name);
                parameterLocation = parameterLocation == null ? ParameterLocation.ID : parameterLocation.andId();
                this.parameterToQuery.put(name, parameterLocation);
            }
        }
        if (objectQuery != null) {
            for (Parameter parameter : objectQuery.getParameters()) {
                name = this.getParameterName(parameter);
                parameterLocation = this.parameterToQuery.get(name);
                parameterLocation = parameterLocation == null ? ParameterLocation.OBJECT : parameterLocation.andObject();
                this.parameterToQuery.put(name, parameterLocation);
            }
        }
        int suffix = 0;
        if (inlinedCountQuery) {
            ++suffix;
        }
        if (keysetToSelectIndexMapping != null) {
            void var24_33;
            boolean bl = false;
            while (var24_33 < keysetToSelectIndexMapping.length) {
                if (keysetToSelectIndexMapping[var24_33] == -1) {
                    ++suffix;
                }
                ++var24_33;
            }
        }
        this.keysetSuffix = suffix;
    }

    private String getParameterName(Parameter<?> parameter) {
        if (this.criteriaNameMapping != null && parameter.getName() == null && parameter instanceof ParameterExpression) {
            return this.criteriaNameMapping.get(parameter);
        }
        String name = parameter.getName();
        if (name == null) {
            return parameter.getPosition().toString();
        }
        return name;
    }

    public long getTotalCount() {
        return ((Number)this.countQuery.getSingleResult()).longValue();
    }

    public List<X> getPageResultList() {
        int queryFirstResult = this.firstResult;
        int firstRow = this.firstResult;
        return this.getResultList(queryFirstResult, firstRow, -1L);
    }

    public PagedList<X> getResultList() {
        int queryFirstResult = this.firstResult;
        int firstRow = this.firstResult;
        long totalSize = -1L;
        if (this.withCount && !this.inlinedCountQuery) {
            if (this.entityId == null) {
                totalSize = ((Number)this.countQuery.getSingleResult()).longValue();
            } else {
                Object[] result = (Object[])this.countQuery.getSingleResult();
                totalSize = ((Number)result[0]).longValue();
                if (result[1] == null) {
                    queryFirstResult = -1;
                    firstRow = 0;
                } else {
                    int position = ((Number)result[1]).intValue() - 1;
                    firstRow = position == 0 ? 0 : position - position % this.pageSize;
                    queryFirstResult = firstRow;
                }
            }
        }
        if (totalSize == 0L) {
            return new PagedArrayList(null, totalSize, queryFirstResult, this.pageSize);
        }
        return this.getResultList(queryFirstResult, firstRow, totalSize);
    }

    private PagedList<X> getResultList(int queryFirstResult, int firstRow, long totalSize) {
        ArrayList<Object> result;
        if (this.idQuery != null) {
            this.idQuery.setMaxResults(this.pageSize);
            if (this.forceFirstResult || this.keysetMode == KeysetMode.NONE) {
                this.idQuery.setFirstResult(firstRow);
            } else {
                this.idQuery.setFirstResult(0);
            }
            ArrayList<Object> ids = this.idQuery.getResultList();
            if (ids.isEmpty()) {
                KeysetPage newKeysetPage = null;
                if (this.keysetMode == KeysetMode.NEXT) {
                    newKeysetPage = this.keysetPage;
                }
                long size = this.withCount && totalSize == -1L ? this.getTotalCount() : totalSize;
                if (this.boundedCount) {
                    if (this.keysetMode == KeysetMode.NEXT) {
                        size = Math.max(size, (long)(this.keysetPage.getFirstResult() + this.keysetPage.getMaxResults()));
                    } else if (this.forceFirstResult || this.keysetMode == KeysetMode.NONE) {
                        size = Math.max(size, (long)firstRow);
                    }
                }
                return new PagedArrayList(newKeysetPage, size, queryFirstResult, this.pageSize);
            }
            Serializable[] lowest = null;
            Serializable[] highest = null;
            Serializable[][] keysets = null;
            if (this.needsNewIdList) {
                int i;
                if (this.keysetToSelectIndexMapping != null) {
                    int i2;
                    int highestIndex;
                    int lowestIndex;
                    int keysetPageSize = this.pageSize - this.highestOffset;
                    int size = Math.min(ids.size(), keysetPageSize);
                    if (this.keysetMode == KeysetMode.PREVIOUS) {
                        lowestIndex = size - 1;
                        highestIndex = 0;
                    } else {
                        lowestIndex = 0;
                        highestIndex = size - 1;
                    }
                    if (ids.get(0) instanceof Object[]) {
                        if (this.withExtractAllKeysets) {
                            keysets = new Serializable[size][];
                            for (i2 = 0; i2 < size; ++i2) {
                                keysets[i2] = KeysetPaginationHelper.extractKey((Object[])ids.get(i2), this.keysetToSelectIndexMapping, this.keysetSuffix);
                            }
                            lowest = keysets[lowestIndex];
                            highest = keysets[highestIndex];
                        } else {
                            lowest = KeysetPaginationHelper.extractKey((Object[])ids.get(lowestIndex), this.keysetToSelectIndexMapping, this.keysetSuffix);
                            highest = KeysetPaginationHelper.extractKey((Object[])ids.get(highestIndex), this.keysetToSelectIndexMapping, this.keysetSuffix);
                        }
                    } else if (this.withExtractAllKeysets) {
                        keysets = new Serializable[size][];
                        for (i2 = 0; i2 < size; ++i2) {
                            keysets[i2] = new Serializable[]{(Serializable)ids.get(i2)};
                        }
                        lowest = keysets[lowestIndex];
                        highest = keysets[highestIndex];
                    } else {
                        lowest = new Serializable[]{(Serializable)ids.get(lowestIndex)};
                        highest = new Serializable[]{(Serializable)ids.get(highestIndex)};
                    }
                    if (this.keysetMode == KeysetMode.PREVIOUS && this.withExtractAllKeysets) {
                        int i3 = 0;
                        int mid = size >> 1;
                        int j = size - 1;
                        while (i3 < mid) {
                            Serializable[] tmp = keysets[i3];
                            keysets[i3] = keysets[j];
                            keysets[j] = tmp;
                            ++i3;
                            --j;
                        }
                    }
                }
                if (this.inlinedCountQuery) {
                    Object[] first = (Object[])ids.get(0);
                    totalSize = (Long)first[first.length - 1];
                }
                ArrayList<Object> newIds = new ArrayList<Object>(ids.size());
                if (this.identifierCount > 1) {
                    for (i = 0; i < ids.size(); ++i) {
                        Object[] tuple = (Object[])ids.get(i);
                        Object[] newId = new Object[this.identifierCount];
                        System.arraycopy(tuple, 0, newId, 0, this.identifierCount);
                        newIds.add(newId);
                    }
                } else {
                    for (i = 0; i < ids.size(); ++i) {
                        Object o = ids.get(i);
                        if (o instanceof Object[]) {
                            newIds.add(((Object[])o)[0]);
                            continue;
                        }
                        newIds.add(o);
                    }
                }
                ids = newIds;
            } else if (this.inlinedCountQuery) {
                int i;
                Object[] first = (Object[])ids.get(0);
                int newSize = first.length - 1;
                totalSize = (Long)first[first.length - 1];
                ArrayList<Object> newIds = new ArrayList<Object>(ids.size());
                if (newSize == 1) {
                    for (i = 0; i < ids.size(); ++i) {
                        newIds.add(((Object[])ids.get(i))[0]);
                    }
                } else {
                    for (i = 0; i < ids.size(); ++i) {
                        Object[] tuple = (Object[])ids.get(i);
                        Object[] newId = new Object[newSize];
                        System.arraycopy(tuple, 0, newId, 0, newSize);
                        newIds.add(newId);
                    }
                }
                ids = newIds;
            }
            if (this.identifierCount > 1) {
                StringBuilder parameterNameBuilder = new StringBuilder("ids".length() + 10);
                parameterNameBuilder.append("ids").append('_');
                int start = parameterNameBuilder.length();
                Object[] empty = ids.size() < this.pageSize ? new Object[this.identifierCount] : null;
                for (int i = 0; i < this.pageSize; ++i) {
                    Object[] tuple = ids.size() > i ? (Object[])ids.get(i) : empty;
                    for (int j = 0; j < this.identifierCount; ++j) {
                        parameterNameBuilder.setLength(start);
                        parameterNameBuilder.append(j).append('_').append(i);
                        this.objectQuery.setParameter(parameterNameBuilder.toString(), tuple[j]);
                    }
                }
            } else {
                this.objectQuery.setParameter("ids", (Object)ids);
            }
            DefaultKeysetPage newKeyset = null;
            if (this.keysetToSelectIndexMapping != null) {
                newKeyset = new DefaultKeysetPage(firstRow, this.pageSize, lowest, highest, keysets);
            }
            totalSize = Math.max(totalSize, (long)(firstRow + ids.size()));
            List queryResultList = this.objectQuery.getResultList();
            PagedArrayList pagedResultList = new PagedArrayList((Collection)queryResultList, (KeysetPage)newKeyset, totalSize, queryFirstResult, this.pageSize);
            return pagedResultList;
        }
        if (!this.inlinedIdQuery) {
            this.objectQuery.setMaxResults(this.pageSize);
            if (this.forceFirstResult || this.keysetMode == KeysetMode.NONE) {
                this.objectQuery.setFirstResult(firstRow);
            } else {
                this.objectQuery.setFirstResult(0);
            }
        }
        if ((result = this.objectQuery.getResultList()).isEmpty()) {
            KeysetPage newKeysetPage = null;
            if (this.keysetMode == KeysetMode.NEXT) {
                newKeysetPage = this.keysetPage;
            }
            if (totalSize == -1L) {
                if (this.inlinedCountQuery && firstRow == 0) {
                    totalSize = 0L;
                } else if (this.withCount) {
                    totalSize = this.getTotalCount();
                }
            }
            if (this.boundedCount) {
                if (this.keysetMode == KeysetMode.NEXT) {
                    totalSize = Math.max(totalSize, (long)(this.keysetPage.getFirstResult() + this.keysetPage.getMaxResults()));
                } else if (this.forceFirstResult || this.keysetMode == KeysetMode.NONE) {
                    totalSize = Math.max(totalSize, (long)firstRow);
                }
            }
            return new PagedArrayList(newKeysetPage, totalSize, queryFirstResult, this.pageSize);
        }
        if (this.keysetMode == KeysetMode.PREVIOUS) {
            Collections.reverse(result);
        }
        DefaultKeysetPage newKeyset = null;
        if (this.keysetToSelectIndexMapping != null) {
            if (this.objectBuilder == null) {
                if (this.inlinedCountQuery) {
                    Object[] first = (Object[])result.get(0);
                    totalSize = (Long)first[first.length - 1];
                    if (first.length == 2) {
                        ArrayList<Object> newResult = new ArrayList<Object>(result.size());
                        for (int i = 0; i < result.size(); ++i) {
                            newResult.add(((Object[])result.get(i))[0]);
                        }
                        result = newResult;
                    }
                }
            } else if (this.objectBuilder instanceof KeysetExtractionObjectBuilder) {
                KeysetExtractionObjectBuilder keysetExtractionObjectBuilder = (KeysetExtractionObjectBuilder)this.objectBuilder;
                Serializable[] lowest = keysetExtractionObjectBuilder.getLowest();
                Serializable[] highest = keysetExtractionObjectBuilder.getHighest();
                Serializable[][] keysets = keysetExtractionObjectBuilder.getKeysets();
                if (this.inlinedCountQuery) {
                    totalSize = keysetExtractionObjectBuilder.getCount();
                }
                newKeyset = new DefaultKeysetPage(firstRow, this.pageSize, lowest, highest, keysets);
            } else if (this.objectBuilder instanceof CountExtractionObjectBuilder) {
                totalSize = ((CountExtractionObjectBuilder)this.objectBuilder).getCount();
            }
        }
        totalSize = Math.max(totalSize, (long)(firstRow + result.size()));
        PagedArrayList pagedResultList = new PagedArrayList((Collection)result, newKeyset, totalSize, queryFirstResult, this.pageSize);
        return pagedResultList;
    }

    public X getSingleResult() {
        PagedList<X> result = this.getResultList();
        if (result.size() == 0) {
            throw new NoResultException("No entity found for query");
        }
        if (result.size() > 1) {
            HashSet<X> uniqueResult = new HashSet<X>(result);
            if (uniqueResult.size() > 1) {
                throw new NonUniqueResultException("result returns more than one element");
            }
            return (X)uniqueResult.iterator().next();
        }
        return (X)result.get(0);
    }

    public int executeUpdate() {
        throw new IllegalArgumentException("Can not call executeUpdate on a select query!");
    }

    public TypedQuery<X> setMaxResults(int maxResult) {
        throw new IllegalArgumentException("Updating max results is not supported on paginated query!");
    }

    public int getMaxResults() {
        return this.pageSize;
    }

    public TypedQuery<X> setFirstResult(int startPosition) {
        throw new IllegalArgumentException("Updating first result is not supported on paginated query!");
    }

    public int getFirstResult() {
        return this.firstResult;
    }

    public TypedQuery<X> setHint(String hintName, Object value) {
        throw new UnsupportedOperationException("Not yet implemented!");
    }

    public Map<String, Object> getHints() {
        throw new UnsupportedOperationException("Not yet implemented!");
    }

    public <T> TypedQuery<X> setParameter(Parameter<T> param, T value) {
        String name = this.getParameterName(param);
        if (name == null) {
            List<Query> queries = this.parameterToQuery.get(Integer.toString(param.getPosition())).getQueries((Query)this.countQuery, this.idQuery, (Query)this.objectQuery);
            for (Query query : queries) {
                query.setParameter(param.getPosition().intValue(), value);
            }
        } else if (Character.isDigit(name.charAt(0))) {
            List<Query> queries = this.parameterToQuery.get(name).getQueries((Query)this.countQuery, this.idQuery, (Query)this.objectQuery);
            for (Query query : queries) {
                query.setParameter(Integer.parseInt(name), value);
            }
        } else {
            List<Query> queries = this.parameterToQuery.get(name).getQueries((Query)this.countQuery, this.idQuery, (Query)this.objectQuery);
            for (Query query : queries) {
                query.setParameter(name, value);
            }
        }
        return this;
    }

    public TypedQuery<X> setParameter(Parameter<Calendar> param, Calendar value, TemporalType temporalType) {
        String name = this.getParameterName(param);
        if (name == null) {
            List<Query> queries = this.parameterToQuery.get(Integer.toString(param.getPosition())).getQueries((Query)this.countQuery, this.idQuery, (Query)this.objectQuery);
            for (Query query : queries) {
                query.setParameter(param.getPosition().intValue(), value, temporalType);
            }
        } else if (Character.isDigit(name.charAt(0))) {
            List<Query> queries = this.parameterToQuery.get(name).getQueries((Query)this.countQuery, this.idQuery, (Query)this.objectQuery);
            for (Query query : queries) {
                query.setParameter(Integer.parseInt(name), value, temporalType);
            }
        } else {
            List<Query> queries = this.parameterToQuery.get(name).getQueries((Query)this.countQuery, this.idQuery, (Query)this.objectQuery);
            for (Query query : queries) {
                query.setParameter(name, value, temporalType);
            }
        }
        return this;
    }

    public TypedQuery<X> setParameter(Parameter<Date> param, Date value, TemporalType temporalType) {
        String name = this.getParameterName(param);
        if (name == null) {
            List<Query> queries = this.parameterToQuery.get(Integer.toString(param.getPosition())).getQueries((Query)this.countQuery, this.idQuery, (Query)this.objectQuery);
            for (Query query : queries) {
                query.setParameter(param.getPosition().intValue(), value, temporalType);
            }
        } else if (Character.isDigit(name.charAt(0))) {
            List<Query> queries = this.parameterToQuery.get(name).getQueries((Query)this.countQuery, this.idQuery, (Query)this.objectQuery);
            for (Query query : queries) {
                query.setParameter(Integer.parseInt(name), value, temporalType);
            }
        } else {
            List<Query> queries = this.parameterToQuery.get(name).getQueries((Query)this.countQuery, this.idQuery, (Query)this.objectQuery);
            for (Query query : queries) {
                query.setParameter(name, value, temporalType);
            }
        }
        return this;
    }

    public TypedQuery<X> setParameter(String name, Object value) {
        return this.setParameter((Parameter<T>)((Parameter)this.getParameter(name)), (T)value);
    }

    public TypedQuery<X> setParameter(String name, Calendar value, TemporalType temporalType) {
        return this.setParameter(this.getParameter(name, Calendar.class), value, temporalType);
    }

    public TypedQuery<X> setParameter(String name, Date value, TemporalType temporalType) {
        return this.setParameter(this.getParameter(name, Date.class), value, temporalType);
    }

    public TypedQuery<X> setParameter(int position, Object value) {
        return this.setParameter((Parameter<T>)((Parameter)this.getParameter(position)), (T)value);
    }

    public TypedQuery<X> setParameter(int position, Calendar value, TemporalType temporalType) {
        return this.setParameter(this.getParameter(position, Calendar.class), value, temporalType);
    }

    public TypedQuery<X> setParameter(int position, Date value, TemporalType temporalType) {
        return this.setParameter(this.getParameter(position, Date.class), value, temporalType);
    }

    public Set<Parameter<?>> getParameters() {
        return new SetView(this.parameters.values());
    }

    public Parameter<?> getParameter(String name) {
        Parameter<?> param = this.parameters.get(name);
        if (param == null) {
            throw new IllegalArgumentException("Couldn't find parameter with name '" + name + "'!");
        }
        return param;
    }

    public <T> Parameter<T> getParameter(String name, Class<T> type) {
        Parameter<?> param = this.getParameter(name);
        if (!param.getParameterType().isAssignableFrom(type)) {
            throw new IllegalArgumentException("The parameter with the name '" + name + "' has the type '" + param.getParameterType().getName() + "' which is not assignable to requested type '" + type.getName() + "'");
        }
        return param;
    }

    public boolean isBound(Parameter<?> param) {
        if (this.objectQuery.isBound(param)) {
            return true;
        }
        if (this.idQuery != null && this.idQuery.isBound(param)) {
            return true;
        }
        return this.countQuery.isBound(param);
    }

    public <T> T getParameterValue(Parameter<T> param) {
        if (param.getName() == null) {
            Query query = this.parameterToQuery.get(Integer.toString(param.getPosition())).getQuery((Query)this.countQuery, this.idQuery, (Query)this.objectQuery);
            return (T)query.getParameterValue(param.getPosition().intValue());
        }
        if (Character.isDigit(param.getName().charAt(0))) {
            Query query = this.parameterToQuery.get(param.getName()).getQuery((Query)this.countQuery, this.idQuery, (Query)this.objectQuery);
            return (T)query.getParameterValue(Integer.parseInt(param.getName()));
        }
        Query query = this.parameterToQuery.get(param.getName()).getQuery((Query)this.countQuery, this.idQuery, (Query)this.objectQuery);
        return (T)query.getParameterValue(param.getName());
    }

    public Object getParameterValue(String name) {
        Query query = this.parameterToQuery.get(name).getQuery((Query)this.countQuery, this.idQuery, (Query)this.objectQuery);
        return query.getParameterValue(name);
    }

    public Object getParameterValue(int position) {
        Query query = this.parameterToQuery.get(Integer.toString(position)).getQuery((Query)this.countQuery, this.idQuery, (Query)this.objectQuery);
        return query.getParameterValue(position);
    }

    public Parameter<?> getParameter(int position) {
        String string = Integer.toString(position);
        Parameter<?> param = this.parameters.get(string);
        if (param == null) {
            throw new IllegalArgumentException("Couldn't find parameter with position '" + position + "'!");
        }
        return param;
    }

    public <T> Parameter<T> getParameter(int position, Class<T> type) {
        Parameter<?> param = this.getParameter(position);
        if (!param.getParameterType().isAssignableFrom(type)) {
            throw new IllegalArgumentException("The parameter at position '" + position + "' has the type '" + param.getParameterType().getName() + "' which is not assignable to requested type '" + type.getName() + "'");
        }
        return param;
    }

    public TypedQuery<X> setFlushMode(FlushModeType flushMode) {
        this.objectQuery.setFlushMode(flushMode);
        return this;
    }

    public FlushModeType getFlushMode() {
        return this.objectQuery.getFlushMode();
    }

    public TypedQuery<X> setLockMode(LockModeType lockMode) {
        this.objectQuery.setLockMode(lockMode);
        return this;
    }

    public LockModeType getLockMode() {
        return this.objectQuery.getLockMode();
    }

    public <T> T unwrap(Class<T> cls) {
        throw new PersistenceException("Unsupported unwrap: " + cls.getName());
    }

    private static enum ParameterLocation {
        COUNT{

            @Override
            public ParameterLocation andId() {
                return COUNT_ID;
            }

            @Override
            public ParameterLocation andObject() {
                return COUNT_OBJECT;
            }

            @Override
            public Query getQuery(Query countQuery, Query idQuery, Query objectQuery) {
                return countQuery;
            }

            @Override
            public List<Query> getQueries(Query countQuery, Query idQuery, Query objectQuery) {
                return Collections.singletonList(countQuery);
            }
        }
        ,
        COUNT_ID{

            @Override
            public ParameterLocation andId() {
                return this;
            }

            @Override
            public ParameterLocation andObject() {
                return COUNT_ID_OBJECT;
            }

            @Override
            public Query getQuery(Query countQuery, Query idQuery, Query objectQuery) {
                return countQuery;
            }

            @Override
            public List<Query> getQueries(Query countQuery, Query idQuery, Query objectQuery) {
                return Arrays.asList(countQuery, idQuery);
            }
        }
        ,
        COUNT_ID_OBJECT{

            @Override
            public ParameterLocation andId() {
                return this;
            }

            @Override
            public ParameterLocation andObject() {
                return this;
            }

            @Override
            public Query getQuery(Query countQuery, Query idQuery, Query objectQuery) {
                return countQuery;
            }

            @Override
            public List<Query> getQueries(Query countQuery, Query idQuery, Query objectQuery) {
                return Arrays.asList(countQuery, idQuery, objectQuery);
            }
        }
        ,
        COUNT_OBJECT{

            @Override
            public ParameterLocation andId() {
                return COUNT_ID_OBJECT;
            }

            @Override
            public ParameterLocation andObject() {
                return this;
            }

            @Override
            public Query getQuery(Query countQuery, Query idQuery, Query objectQuery) {
                return countQuery;
            }

            @Override
            public List<Query> getQueries(Query countQuery, Query idQuery, Query objectQuery) {
                return Arrays.asList(countQuery, objectQuery);
            }
        }
        ,
        ID{

            @Override
            public ParameterLocation andId() {
                return this;
            }

            @Override
            public ParameterLocation andObject() {
                return ID_OBJECT;
            }

            @Override
            public Query getQuery(Query countQuery, Query idQuery, Query objectQuery) {
                return idQuery;
            }

            @Override
            public List<Query> getQueries(Query countQuery, Query idQuery, Query objectQuery) {
                return Collections.singletonList(idQuery);
            }
        }
        ,
        ID_OBJECT{

            @Override
            public ParameterLocation andId() {
                return this;
            }

            @Override
            public ParameterLocation andObject() {
                return this;
            }

            @Override
            public Query getQuery(Query countQuery, Query idQuery, Query objectQuery) {
                return idQuery;
            }

            @Override
            public List<Query> getQueries(Query countQuery, Query idQuery, Query objectQuery) {
                return Arrays.asList(idQuery, objectQuery);
            }
        }
        ,
        OBJECT{

            @Override
            public ParameterLocation andId() {
                return ID_OBJECT;
            }

            @Override
            public ParameterLocation andObject() {
                return this;
            }

            @Override
            public Query getQuery(Query countQuery, Query idQuery, Query objectQuery) {
                return objectQuery;
            }

            @Override
            public List<Query> getQueries(Query countQuery, Query idQuery, Query objectQuery) {
                return Collections.singletonList(objectQuery);
            }
        };


        public abstract ParameterLocation andId();

        public abstract ParameterLocation andObject();

        public abstract Query getQuery(Query var1, Query var2, Query var3);

        public abstract List<Query> getQueries(Query var1, Query var2, Query var3);
    }
}

