/*
 * Decompiled with CFR 0.152.
 */
package com.blazebit.persistence.impl;

import com.blazebit.persistence.impl.AbstractCommonQueryBuilder;
import com.blazebit.persistence.impl.ClauseType;
import com.blazebit.persistence.impl.ParameterManager;
import com.blazebit.persistence.parser.expression.ArrayExpression;
import com.blazebit.persistence.parser.expression.Expression;
import com.blazebit.persistence.parser.expression.ParameterExpression;
import com.blazebit.persistence.parser.expression.VisitorAdapter;

public class ParameterRegistrationVisitor
extends VisitorAdapter {
    private final ParameterManager parameterManager;
    private ClauseType clauseType;
    private ClauseType secondClauseType;
    private AbstractCommonQueryBuilder<?, ?, ?, ?, ?> queryBuilder;

    public ParameterRegistrationVisitor(ParameterManager parameterManager) {
        this.parameterManager = parameterManager;
    }

    public void visit(ParameterExpression expression) {
        if ("ids".equals(expression.getName())) {
            throw new IllegalArgumentException("The parameter name '" + expression.getName() + "' is reserved - use a different name");
        }
        this.parameterManager.registerParameterName(expression.getName(), expression.isCollectionValued(), this.clauseType, this.queryBuilder);
        if (this.secondClauseType != null) {
            this.parameterManager.registerParameterName(expression.getName(), expression.isCollectionValued(), this.secondClauseType, this.queryBuilder);
        }
        if (expression.getValue() != null) {
            this.parameterManager.satisfyParameter(expression.getName(), expression.getValue());
        }
    }

    public void visit(ArrayExpression expression) {
        expression.getBase().accept((Expression.Visitor)this);
        ClauseType oldClauseType = this.secondClauseType;
        this.secondClauseType = ClauseType.JOIN;
        expression.getIndex().accept((Expression.Visitor)this);
        this.secondClauseType = oldClauseType;
    }

    public ClauseType getClauseType() {
        return this.clauseType;
    }

    public void setClauseType(ClauseType clauseType) {
        this.clauseType = clauseType;
    }

    public AbstractCommonQueryBuilder<?, ?, ?, ?, ?> getQueryBuilder() {
        return this.queryBuilder;
    }

    public void setQueryBuilder(AbstractCommonQueryBuilder<?, ?, ?, ?, ?> queryBuilder) {
        this.queryBuilder = queryBuilder;
    }
}

