/*
 * Decompiled with CFR 0.152.
 */
package com.blazebit.persistence.impl;

import com.blazebit.persistence.FullQueryBuilder;
import com.blazebit.persistence.impl.AbstractCommonQueryBuilder;
import com.blazebit.persistence.impl.AliasManager;
import com.blazebit.persistence.impl.ClauseType;
import com.blazebit.persistence.impl.JoinManager;
import com.blazebit.persistence.impl.MainQuery;
import com.blazebit.persistence.impl.QueryContext;
import com.blazebit.persistence.impl.SelectInfo;
import com.blazebit.persistence.impl.SubqueryBuilderImpl;
import com.blazebit.persistence.impl.SubqueryBuilderListener;
import com.blazebit.persistence.impl.SubqueryInitiatorImpl;
import com.blazebit.persistence.parser.expression.Expression;
import com.blazebit.persistence.parser.expression.ExpressionCopyContext;
import com.blazebit.persistence.parser.expression.InplaceModificationResultVisitorAdapter;
import com.blazebit.persistence.parser.expression.Subquery;
import com.blazebit.persistence.parser.expression.SubqueryExpression;
import com.blazebit.persistence.parser.predicate.ExistsPredicate;
import java.util.Collections;
import java.util.IdentityHashMap;

public class SubqueryInitiatorFactory {
    private final MainQuery mainQuery;
    private final AbstractCommonQueryBuilder<?, ?, ?, ?, ?> queryBuilder;
    private final AliasManager aliasManager;
    private final JoinManager parentJoinManager;
    private final SubqueryReattachingTransformationVisitor subqueryTransformationVisitor;

    public SubqueryInitiatorFactory(MainQuery mainQuery, AbstractCommonQueryBuilder<?, ?, ?, ?, ?> queryBuilder, AliasManager aliasManager, JoinManager parentJoinManager) {
        this.mainQuery = mainQuery;
        this.queryBuilder = queryBuilder;
        this.aliasManager = aliasManager;
        this.parentJoinManager = parentJoinManager;
        this.subqueryTransformationVisitor = new SubqueryReattachingTransformationVisitor();
    }

    public AbstractCommonQueryBuilder<?, ?, ?, ?, ?> getQueryBuilder() {
        return this.queryBuilder;
    }

    public <T> SubqueryInitiatorImpl<T> createSubqueryInitiator(T result, SubqueryBuilderListener<T> listener, boolean inExists, ClauseType clause) {
        return new SubqueryInitiatorImpl<T>(this.mainQuery, new QueryContext(this.queryBuilder, clause), this.aliasManager, this.parentJoinManager, result, listener, inExists);
    }

    public <T> SubqueryBuilderImpl<T> createSubqueryBuilder(T result, SubqueryBuilderListener<T> listener, boolean inExists, FullQueryBuilder<?, ?> criteriaBuilder, ClauseType clause) {
        return this.createSubqueryBuilder(result, listener, inExists, (AbstractCommonQueryBuilder)criteriaBuilder, clause);
    }

    public <T> SubqueryBuilderImpl<T> createSubqueryBuilder(T result, SubqueryBuilderListener<T> listener, boolean inExists, SubqueryBuilderImpl<?> subqueryBuilder, ClauseType clause) {
        return this.createSubqueryBuilder(result, listener, inExists, (AbstractCommonQueryBuilder<?, ?, ?, ?, ?>)subqueryBuilder, clause);
    }

    private <T> SubqueryBuilderImpl<T> createSubqueryBuilder(T result, SubqueryBuilderListener<T> listener, boolean inExists, AbstractCommonQueryBuilder<?, ?, ?, ?, ?> builder, ClauseType clause) {
        SubqueryBuilderImpl<T> subqueryBuilder = new SubqueryBuilderImpl<T>(this.mainQuery, new QueryContext(this.queryBuilder, clause), this.aliasManager, this.parentJoinManager, this.mainQuery.subqueryExpressionFactory, result, false, listener);
        ExpressionCopyContext copyContext = subqueryBuilder.applyFrom(builder, builder.isMainQuery, !inExists, false, true, Collections.emptySet(), Collections.emptySet(), new IdentityHashMap<JoinManager, JoinManager>(), ExpressionCopyContext.EMPTY);
        if (inExists) {
            subqueryBuilder.selectManager.setDefaultSelect(null, Collections.singletonList(new SelectInfo(this.mainQuery.expressionFactory.createSimpleExpression("1"))), copyContext);
        }
        subqueryBuilder.collectParameters();
        if (listener != null) {
            listener.onBuilderStarted(subqueryBuilder);
        }
        return subqueryBuilder;
    }

    public <T extends Expression> T reattachSubqueries(T expression, ClauseType clauseType) {
        this.subqueryTransformationVisitor.clauseType = clauseType;
        return (T)((Expression)expression.accept((Expression.ResultVisitor)this.subqueryTransformationVisitor));
    }

    class SubqueryReattachingTransformationVisitor
    extends InplaceModificationResultVisitorAdapter {
        private boolean inExists;
        private ClauseType clauseType;

        SubqueryReattachingTransformationVisitor() {
        }

        public Expression visit(ExistsPredicate predicate) {
            this.inExists = true;
            try {
                Expression expression = super.visit(predicate);
                return expression;
            }
            finally {
                this.inExists = false;
            }
        }

        public Expression visit(SubqueryExpression expression) {
            AbstractCommonQueryBuilder subqueryBuilder = (AbstractCommonQueryBuilder)expression.getSubquery();
            SubqueryBuilderImpl builder = SubqueryInitiatorFactory.this.createSubqueryBuilder(null, null, this.inExists, subqueryBuilder, this.clauseType);
            return new SubqueryExpression((Subquery)builder);
        }
    }
}

