/*
 * Decompiled with CFR 0.152.
 */
package com.blazebit.persistence.impl;

import com.blazebit.persistence.impl.JoinAliasInfo;
import com.blazebit.persistence.impl.JoinNode;
import jakarta.persistence.metamodel.EntityType;

public class TreatedJoinAliasInfo
extends JoinAliasInfo {
    private final JoinNode treatedJoinNode;
    private final EntityType<?> treatType;

    public TreatedJoinAliasInfo(JoinNode treatedJoinNode, EntityType<?> treatType, String alias) {
        super(alias, "TREAT(" + treatedJoinNode.getAliasInfo().getAbsolutePath() + " AS " + treatType.getName() + ")", treatedJoinNode.getAliasInfo().isImplicit(), treatedJoinNode.getAliasInfo().isRootNode(), treatedJoinNode.getAliasInfo().getAliasOwner());
        this.treatedJoinNode = treatedJoinNode;
        this.treatType = treatType;
    }

    public JoinNode getTreatedJoinNode() {
        return this.treatedJoinNode;
    }

    public EntityType<?> getTreatType() {
        return this.treatType;
    }

    @Override
    public String getAbsolutePath() {
        return "TREAT(" + this.treatedJoinNode.getAliasInfo().getAbsolutePath() + " AS " + this.treatType.getName() + ")";
    }

    @Override
    public void render(StringBuilder sb) {
        sb.append("TREAT(").append(this.treatedJoinNode.getAliasInfo().getAlias()).append(" AS ").append(this.treatType.getName()).append(')');
    }
}

