/*
 * Decompiled with CFR 0.152.
 */
package com.blazebit.persistence.impl.function.datediff.minute;

import com.blazebit.persistence.impl.function.datediff.minute.MinuteDiffFunction;
import com.blazebit.persistence.spi.FunctionRenderContext;
import com.blazebit.persistence.spi.TemplateRenderer;

public class OracleMinuteDiffFunction
extends MinuteDiffFunction {
    private final TemplateRenderer bothParamRenderer = new TemplateRenderer("(select extract(day from t2 - t1) * 1440 + extract(hour from t2 - t1) * 60 + extract(minute from t2 - t1) from (select cast(?1 as timestamp) as t1, cast(?2 as timestamp) as t2 from dual))");
    private final TemplateRenderer firstParamRenderer = new TemplateRenderer("(select extract(day from cast(?2 as timestamp) - t1) * 1440 + extract(hour from cast(?2 as timestamp) - t1) * 60 + extract(minute from cast(?2 as timestamp) - t1) from (select cast(?1 as timestamp) as t1 from dual))");
    private final TemplateRenderer secondParamRenderer = new TemplateRenderer("(select extract(day from t2 - cast(?1 as timestamp)) * 1440 + extract(hour from t2 - cast(?1 as timestamp)) * 60 + extract(minute from t2 - cast(?1 as timestamp)) from (select cast(?2 as timestamp) as t2 from dual))");

    public OracleMinuteDiffFunction() {
        super("(extract(day from cast(?2 as timestamp) - cast(?1 as timestamp)) * 1440 + extract(hour from cast(?2 as timestamp) - cast(?1 as timestamp)) * 60 + extract(minute from cast(?2 as timestamp) - cast(?1 as timestamp)))");
    }

    @Override
    protected void renderDiff(FunctionRenderContext context) {
        boolean firstContains = context.getArgument(0).contains("?");
        boolean secondContains = context.getArgument(1).contains("?");
        if (firstContains && context.getArgument(0).length() != 1 || secondContains && context.getArgument(1).length() != 1) {
            throw new IllegalArgumentException("Only simple parameters or expressions are allowed because of a needed reordering in SQL which is otherwise not possible! Expressions ['" + context.getArgument(0) + "', '" + context.getArgument(1) + "'] do not comply!");
        }
        if (firstContains) {
            if (secondContains) {
                this.bothParamRenderer.start(context).addArgument(0).addArgument(1).build();
            } else {
                this.firstParamRenderer.start(context).addArgument(0).addArgument(1).build();
            }
        } else if (secondContains) {
            this.secondParamRenderer.start(context).addArgument(0).addArgument(1).build();
        } else {
            this.renderer.start(context).addArgument(0).addArgument(1).build();
        }
    }
}

