/*
 * Decompiled with CFR 0.152.
 */
package com.blazebit.persistence.impl.function.stringxmlagg;

import com.blazebit.persistence.impl.function.concat.ConcatFunction;
import com.blazebit.persistence.impl.function.groupconcat.AbstractGroupConcatFunction;
import com.blazebit.persistence.impl.function.replace.ReplaceFunction;
import com.blazebit.persistence.impl.function.stringxmlagg.AbstractStringXmlAggFunction;
import com.blazebit.persistence.spi.FunctionRenderContext;
import java.util.Collections;

public class GroupConcatBasedStringXmlAggFunction
extends AbstractStringXmlAggFunction {
    protected final ConcatFunction concatFunction;
    private final AbstractGroupConcatFunction groupConcatFunction;
    private final ReplaceFunction replaceFunction;

    public GroupConcatBasedStringXmlAggFunction(AbstractGroupConcatFunction groupConcatFunction, ReplaceFunction replaceFunction, ConcatFunction concatFunction) {
        this.groupConcatFunction = groupConcatFunction;
        this.concatFunction = concatFunction;
        this.replaceFunction = replaceFunction;
    }

    public void render(FunctionRenderContext context) {
        if ((context.getArgumentsSize() & 1) == 1) {
            throw new RuntimeException("The string_xml_agg function needs an even amount of arguments <key1>, <value1>, ..., <keyN>, <valueN>! args=" + context);
        }
        StringBuilder sb = new StringBuilder();
        sb.append(this.concatFunction.startConcat());
        sb.append("'<e>'");
        sb.append(this.concatFunction.concatSeparator());
        sb.append(this.coalesceStart());
        sb.append(this.concatFunction.startConcat());
        sb.append("'<'");
        sb.append(this.concatFunction.concatSeparator());
        sb.append(context.getArgument(0));
        for (int i = 1; i < context.getArgumentsSize(); ++i) {
            if ((i & 1) == 1) {
                sb.append(this.concatFunction.concatSeparator());
                sb.append("'>'");
                sb.append(this.concatFunction.concatSeparator());
                sb.append(this.escape(context.getArgument(i)));
                sb.append(this.concatFunction.concatSeparator());
                sb.append("'</'");
                sb.append(this.concatFunction.concatSeparator());
                sb.append(context.getArgument(i - 1));
                sb.append(this.concatFunction.concatSeparator());
                sb.append("'>'");
                sb.append(this.concatFunction.endConcat());
                sb.append(this.coalesceEnd(context.getArgument(i - 1)));
                continue;
            }
            sb.append(this.concatFunction.concatSeparator());
            sb.append(this.coalesceStart());
            sb.append(this.concatFunction.startConcat());
            sb.append("'<'");
            sb.append(this.concatFunction.concatSeparator());
            sb.append(context.getArgument(i));
        }
        sb.append(this.concatFunction.concatSeparator());
        sb.append("'</e>'");
        sb.append(this.concatFunction.endConcat());
        this.groupConcatFunction.render(context, new AbstractGroupConcatFunction.GroupConcat(false, sb.toString(), Collections.emptyList(), ","));
    }

    protected String coalesceStart() {
        return "coalesce(";
    }

    protected String coalesceEnd(String field) {
        return ",'')";
    }

    private String escape(String argument) {
        argument = this.replaceFunction.getReplaceString(argument, "'&'", "'&amp;'");
        argument = this.replaceFunction.getReplaceString(argument, "'<'", "'&lt;'");
        argument = this.replaceFunction.getReplaceString(argument, "'>'", "'&gt;'");
        return argument;
    }
}

