/*
 * Decompiled with CFR 0.152.
 */
package com.blazebit.persistence.impl.util;

import com.blazebit.persistence.spi.AttributeAccessor;
import com.blazebit.persistence.spi.ExtendedManagedType;
import java.util.ArrayList;

public class CompositeAttributeAccessor<X, Y>
implements AttributeAccessor<X, Y> {
    private final AttributeAccessor[] accessors;

    private CompositeAttributeAccessor(AttributeAccessor[] accessors) {
        this.accessors = accessors;
    }

    public static <X, Y> AttributeAccessor<X, Y> of(ExtendedManagedType<?> type, String path) {
        int index = path.indexOf(46);
        AttributeAccessor lastAccessor = type.getAttribute(path).getAccessor();
        if (index == -1) {
            return lastAccessor;
        }
        ArrayList<AttributeAccessor> accessors = new ArrayList<AttributeAccessor>();
        do {
            accessors.add(type.getAttribute(path.substring(0, index)).getAccessor());
        } while ((index = path.indexOf(46, index + 1)) != -1);
        accessors.add(lastAccessor);
        return new CompositeAttributeAccessor<X, Y>(accessors.toArray(new AttributeAccessor[accessors.size()]));
    }

    public Y get(X entity) {
        Object result = entity;
        for (int i = 0; i < this.accessors.length; ++i) {
            result = this.accessors[i].get(result);
        }
        return (Y)result;
    }

    public Y getNullSafe(X entity) {
        Object result = entity;
        for (int i = 0; i < this.accessors.length; ++i) {
            if (result == null) {
                return null;
            }
            result = this.accessors[i].get(result);
        }
        return (Y)result;
    }

    public void set(X entity, Y value) {
        Object result = entity;
        int endIndex = this.accessors.length - 1;
        for (int i = 0; i < endIndex; ++i) {
            result = this.accessors[i].get(result);
        }
        this.accessors[endIndex].set(result, value);
    }
}

