/*
 * Decompiled with CFR 0.152.
 */
package com.blazebit.persistence.parser.util;

import com.blazebit.persistence.parser.util.TypeConverter;
import com.blazebit.persistence.parser.util.TypeUtils;
import java.sql.Timestamp;
import java.time.ZoneId;
import java.time.ZoneOffset;
import java.time.ZonedDateTime;
import java.util.Calendar;
import java.util.Date;

public class ZonedDateTimeTypeConverter
extends TypeUtils.AbstractLiteralFunctionTypeConverter<ZonedDateTime> {
    public static final TypeConverter<?> INSTANCE = new ZonedDateTimeTypeConverter();
    private static final long serialVersionUID = 1L;

    private ZonedDateTimeTypeConverter() {
        super("literal_zoned_date_time");
    }

    @Override
    public ZonedDateTime convert(Object value) {
        if (value == null) {
            return null;
        }
        if (value instanceof Date) {
            Date date = (Date)value;
            return ZonedDateTime.ofInstant(date.toInstant(), ZoneId.systemDefault());
        }
        if (value instanceof Calendar) {
            Calendar calendar = (Calendar)value;
            return ZonedDateTime.ofInstant(calendar.toInstant(), calendar.getTimeZone().toZoneId());
        }
        if (value instanceof String) {
            return ZonedDateTime.ofInstant(Timestamp.valueOf((String)value).toInstant(), ZoneId.systemDefault());
        }
        throw ZonedDateTimeTypeConverter.unknownConversion(value, ZonedDateTime.class);
    }

    @Override
    public String toString(ZonedDateTime value) {
        value = value.withZoneSameInstant(ZoneOffset.UTC);
        return TypeUtils.jdbcTimestamp(value.getYear(), value.getMonthValue(), value.getDayOfMonth(), value.getHour(), value.getMinute(), value.getSecond(), value.getNano());
    }

    @Override
    public void appendTo(ZonedDateTime value, StringBuilder stringBuilder) {
        value = value.withZoneSameInstant(ZoneOffset.UTC);
        TypeUtils.appendJdbcTimestamp(stringBuilder, value.getYear(), value.getMonthValue(), value.getDayOfMonth(), value.getHour(), value.getMinute(), value.getSecond(), value.getNano());
    }
}

