/*
 * Decompiled with CFR 0.152.
 */
package com.blazebit.persistence.view.filter;

import java.io.Serializable;

public final class Range<T>
implements Serializable {
    private final T lowerBound;
    private final T upperBound;
    private final boolean inclusive;

    private Range(T lowerBound, T upperBound, boolean inclusive) {
        this.lowerBound = lowerBound;
        this.upperBound = upperBound;
        this.inclusive = inclusive;
    }

    public static <T> Range<T> lt(T upperBound) {
        return new Range<Object>(null, upperBound, false);
    }

    public static <T> Range<T> le(T upperBound) {
        return new Range<Object>(null, upperBound, true);
    }

    public static <T> Range<T> gt(T lowerBound) {
        return new Range<Object>(lowerBound, null, false);
    }

    public static <T> Range<T> ge(T lowerBound) {
        return new Range<Object>(lowerBound, null, true);
    }

    public static <T> Range<T> between(T lowerBound, T upperBound) {
        return new Range<T>(lowerBound, upperBound, true);
    }

    public static <T> Range<T> betweenExclusive(T lowerBound, T upperBound) {
        return new Range<T>(lowerBound, upperBound, false);
    }

    public T getLowerBound() {
        return this.lowerBound;
    }

    public T getUpperBound() {
        return this.upperBound;
    }

    public boolean isInclusive() {
        return this.inclusive;
    }
}

