/*
 * Decompiled with CFR 0.152.
 */
package com.deepoove.poi.config;

import com.deepoove.poi.config.ConfigureBuilder;
import com.deepoove.poi.config.GramerSymbol;
import com.deepoove.poi.exception.RenderException;
import com.deepoove.poi.policy.DocxRenderPolicy;
import com.deepoove.poi.policy.MiniTableRenderPolicy;
import com.deepoove.poi.policy.NumbericRenderPolicy;
import com.deepoove.poi.policy.PictureRenderPolicy;
import com.deepoove.poi.policy.RenderPolicy;
import com.deepoove.poi.policy.TextRenderPolicy;
import com.deepoove.poi.policy.reference.DefaultChartTemplateRenderPolicy;
import com.deepoove.poi.policy.reference.DefaultPictureTemplateRenderPolicy;
import com.deepoove.poi.policy.reference.MultiSeriesChartTemplateRenderPolicy;
import com.deepoove.poi.policy.reference.SingleSeriesChartTemplateRenderPolicy;
import com.deepoove.poi.render.RenderContext;
import com.deepoove.poi.render.compute.DefaultRenderDataComputeFactory;
import com.deepoove.poi.render.compute.RenderDataComputeFactory;
import com.deepoove.poi.resolver.DefaultElementTemplateFactory;
import com.deepoove.poi.resolver.ElementTemplateFactory;
import com.deepoove.poi.template.ChartTemplate;
import com.deepoove.poi.template.MetaTemplate;
import com.deepoove.poi.template.PictureTemplate;
import com.deepoove.poi.util.RegexUtils;
import java.lang.reflect.Method;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.poi.xddf.usermodel.chart.ChartTypes;

public class Configure
implements Cloneable {
    public static final String DEFAULT_GRAMER_REGEX = "((#)?[\\w\\u4e00-\\u9fa5]+(\\.[\\w\\u4e00-\\u9fa5]+)*)?";
    private final Map<String, RenderPolicy> CUSTOM_POLICYS = new HashMap<String, RenderPolicy>();
    private final Map<Character, RenderPolicy> DEFAULT_POLICYS = new HashMap<Character, RenderPolicy>();
    private final Map<ChartTypes, RenderPolicy> DEFAULT_CHART_POLICYS = new EnumMap<ChartTypes, RenderPolicy>(ChartTypes.class);
    private final Map<Class<? extends MetaTemplate>, RenderPolicy> DEFAULT_TEMPLATE_POLICYS = new HashMap<Class<? extends MetaTemplate>, RenderPolicy>();
    Pair<Character, Character> iterable = Pair.of((Object)Character.valueOf(GramerSymbol.ITERABLE_START.getSymbol()), (Object)Character.valueOf(GramerSymbol.BLOCK_END.getSymbol()));
    String gramerPrefix = "{{";
    String gramerSuffix = "}}";
    String grammerRegex = "((#)?[\\w\\u4e00-\\u9fa5]+(\\.[\\w\\u4e00-\\u9fa5]+)*)?";
    ELMode elMode = ELMode.POI_TL_STANDARD_MODE;
    RenderDataComputeFactory renderDataComputeFactory = new DefaultRenderDataComputeFactory(this);
    ElementTemplateFactory elementTemplateFactory = new DefaultElementTemplateFactory(this);
    ValidErrorHandler handler = new ClearHandler();
    Map<String, Method> spELFunction = new HashMap<String, Method>();

    Configure() {
        this.plugin(GramerSymbol.TEXT, (RenderPolicy)new TextRenderPolicy());
        this.plugin(GramerSymbol.TEXT_ALIAS, (RenderPolicy)new TextRenderPolicy());
        this.plugin(GramerSymbol.IMAGE, (RenderPolicy)new PictureRenderPolicy());
        this.plugin(GramerSymbol.TABLE, (RenderPolicy)new MiniTableRenderPolicy());
        this.plugin(GramerSymbol.NUMBERIC, (RenderPolicy)new NumbericRenderPolicy());
        this.plugin(GramerSymbol.DOCX_TEMPLATE, (RenderPolicy)new DocxRenderPolicy());
        MultiSeriesChartTemplateRenderPolicy multiSeriesRenderPolicy = new MultiSeriesChartTemplateRenderPolicy();
        this.plugin(ChartTypes.AREA, (RenderPolicy)multiSeriesRenderPolicy);
        this.plugin(ChartTypes.AREA3D, (RenderPolicy)multiSeriesRenderPolicy);
        this.plugin(ChartTypes.BAR, (RenderPolicy)multiSeriesRenderPolicy);
        this.plugin(ChartTypes.BAR3D, (RenderPolicy)multiSeriesRenderPolicy);
        this.plugin(ChartTypes.LINE, (RenderPolicy)multiSeriesRenderPolicy);
        this.plugin(ChartTypes.LINE3D, (RenderPolicy)multiSeriesRenderPolicy);
        this.plugin(ChartTypes.RADAR, (RenderPolicy)multiSeriesRenderPolicy);
        SingleSeriesChartTemplateRenderPolicy singleSeriesRenderPolicy = new SingleSeriesChartTemplateRenderPolicy();
        this.plugin(ChartTypes.PIE, (RenderPolicy)singleSeriesRenderPolicy);
        this.plugin(ChartTypes.PIE3D, (RenderPolicy)singleSeriesRenderPolicy);
        this.plugin(PictureTemplate.class, (RenderPolicy)new DefaultPictureTemplateRenderPolicy());
        this.plugin(ChartTemplate.class, (RenderPolicy)new DefaultChartTemplateRenderPolicy());
    }

    public static Configure createDefault() {
        return Configure.newBuilder().build();
    }

    public static ConfigureBuilder newBuilder() {
        return new ConfigureBuilder();
    }

    public Configure plugin(char c, RenderPolicy policy) {
        this.DEFAULT_POLICYS.put(Character.valueOf(c), policy);
        return this;
    }

    Configure plugin(GramerSymbol symbol, RenderPolicy policy) {
        this.DEFAULT_POLICYS.put(Character.valueOf(symbol.getSymbol()), policy);
        return this;
    }

    Configure plugin(Class<? extends MetaTemplate> clazz, RenderPolicy policy) {
        this.DEFAULT_TEMPLATE_POLICYS.put(clazz, policy);
        return this;
    }

    Configure plugin(ChartTypes chartType, RenderPolicy policy) {
        this.DEFAULT_CHART_POLICYS.put(chartType, policy);
        return this;
    }

    public void customPolicy(String tagName, RenderPolicy policy) {
        this.CUSTOM_POLICYS.put(tagName, policy);
    }

    public RenderPolicy getTemplatePolicy(Class<?> clazz) {
        return this.DEFAULT_TEMPLATE_POLICYS.get(clazz);
    }

    public RenderPolicy getCustomPolicy(String tagName) {
        return this.CUSTOM_POLICYS.get(tagName);
    }

    public RenderPolicy getDefaultPolicy(Character sign) {
        return this.DEFAULT_POLICYS.get(sign);
    }

    public RenderPolicy getChartPolicy(ChartTypes type) {
        return this.DEFAULT_CHART_POLICYS.get(type);
    }

    public Map<Character, RenderPolicy> getDefaultPolicys() {
        return this.DEFAULT_POLICYS;
    }

    public Map<String, RenderPolicy> getCustomPolicys() {
        return this.CUSTOM_POLICYS;
    }

    public Map<ChartTypes, RenderPolicy> getChartPolicys() {
        return this.DEFAULT_CHART_POLICYS;
    }

    public Set<Character> getGramerChars() {
        HashSet<Character> ret = new HashSet<Character>(this.DEFAULT_POLICYS.keySet());
        ret.add((Character)this.iterable.getKey());
        ret.add((Character)this.iterable.getValue());
        return ret;
    }

    public String getGramerPrefix() {
        return this.gramerPrefix;
    }

    public String getGramerSuffix() {
        return this.gramerSuffix;
    }

    public String getGrammerRegex() {
        return this.grammerRegex;
    }

    public ELMode getElMode() {
        return this.elMode;
    }

    public ValidErrorHandler getValidErrorHandler() {
        return this.handler;
    }

    public RenderDataComputeFactory getRenderDataComputeFactory() {
        return this.renderDataComputeFactory;
    }

    public ElementTemplateFactory getElementTemplateFactory() {
        return this.elementTemplateFactory;
    }

    public Pair<Character, Character> getIterable() {
        return this.iterable;
    }

    public Map<String, Method> getSpELFunction() {
        return this.spELFunction;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("Configure Info").append(":\n");
        sb.append("  Basic gramer: ").append(this.gramerPrefix).append(this.gramerSuffix).append("\n");
        sb.append("  If and foreach gramer: ").append(this.gramerPrefix).append(this.iterable.getLeft()).append(this.gramerSuffix);
        sb.append(this.gramerPrefix).append(this.iterable.getRight()).append(this.gramerSuffix).append("\n");
        sb.append("  EL Mode: ").append((Object)this.elMode).append("\n");
        sb.append("  Regex:").append(this.grammerRegex).append("\n");
        sb.append("  Valid Error Handler: ").append(this.handler.getClass().getSimpleName()).append("\n");
        sb.append("  Default Plugin: ").append("\n");
        this.DEFAULT_POLICYS.forEach((chara, policy) -> {
            sb.append("    ").append(this.gramerPrefix).append(chara.charValue()).append(this.gramerSuffix);
            sb.append("->").append(policy.getClass().getSimpleName()).append("\n");
        });
        sb.append("  Bind Plugin: ").append("\n");
        this.CUSTOM_POLICYS.forEach((str, policy) -> {
            sb.append("    ").append(this.gramerPrefix).append((String)str).append(this.gramerSuffix);
            sb.append("->").append(policy.getClass().getSimpleName()).append("\n");
        });
        sb.append("  Chart Plugin: ").append("\n");
        this.DEFAULT_CHART_POLICYS.forEach((type, policy) -> {
            sb.append("    ").append(type);
            sb.append("->").append(policy.getClass().getSimpleName()).append("\n");
        });
        sb.append("  Template Plugin: ").append("\n");
        this.DEFAULT_TEMPLATE_POLICYS.forEach((clazz, policy) -> {
            sb.append("    ").append(clazz.getSimpleName());
            sb.append("->").append(policy.getClass().getSimpleName()).append("\n");
        });
        sb.append("  SpELFunction: ").append("\n");
        this.spELFunction.forEach((str, method) -> {
            sb.append("    ").append((String)str);
            sb.append("->").append(method.toString()).append("\n");
        });
        return sb.toString();
    }

    protected Configure clone() throws CloneNotSupportedException {
        return (Configure)super.clone();
    }

    public Configure clone(String prefix, String suffix) throws CloneNotSupportedException {
        Configure clone = this.clone();
        clone.gramerPrefix = prefix;
        clone.gramerSuffix = suffix;
        if (clone.elMode == ELMode.SPEL_MODE) {
            clone.grammerRegex = RegexUtils.createGeneral(clone.gramerPrefix, clone.gramerSuffix);
        }
        return clone;
    }

    public static class AbortHandler
    implements ValidErrorHandler {
        @Override
        public void handler(RenderContext<?> context) {
            throw new RenderException("Non-existent variable and a variable with illegal value for " + context.getTagSource() + ", data: " + context.getData());
        }
    }

    public static class ClearHandler
    implements ValidErrorHandler {
        @Override
        public void handler(RenderContext<?> context) {
            context.getRun().setText("", 0);
        }
    }

    public static class DiscardHandler
    implements ValidErrorHandler {
        @Override
        public void handler(RenderContext<?> context) {
        }
    }

    public static interface ValidErrorHandler {
        public void handler(RenderContext<?> var1);
    }

    public static enum ELMode {
        POI_TL_STANDARD_MODE,
        POI_TL_STICT_MODE,
        SPEL_MODE;

    }
}

