/*
 * Decompiled with CFR 0.152.
 */
package com.deepoove.poi.policy.reference;

import com.deepoove.poi.XWPFTemplate;
import com.deepoove.poi.data.ChartMultiSeriesRenderData;
import com.deepoove.poi.data.SeriesRenderData;
import com.deepoove.poi.policy.reference.AbstractChartTemplateRenderPolicy;
import com.deepoove.poi.template.ChartTemplate;
import com.deepoove.poi.util.ReflectionUtils;
import java.lang.reflect.Field;
import java.util.List;
import org.apache.poi.xddf.usermodel.chart.XDDFCategoryDataSource;
import org.apache.poi.xddf.usermodel.chart.XDDFChart;
import org.apache.poi.xddf.usermodel.chart.XDDFChartData;
import org.apache.poi.xddf.usermodel.chart.XDDFDataSource;
import org.apache.poi.xddf.usermodel.chart.XDDFNumericalDataSource;
import org.apache.poi.xssf.usermodel.XSSFSheet;
import org.apache.poi.xwpf.usermodel.XWPFChart;

public class MultiSeriesChartTemplateRenderPolicy
extends AbstractChartTemplateRenderPolicy<ChartMultiSeriesRenderData> {
    @Override
    public void doRender(ChartTemplate eleTemplate, ChartMultiSeriesRenderData data, XWPFTemplate template) throws Exception {
        if (null == data) {
            return;
        }
        XWPFChart chart = eleTemplate.getChart();
        XDDFChartData chartData = (XDDFChartData)chart.getChartSeries().get(0);
        Field field = ReflectionUtils.findField(XDDFChart.class, "seriesCount");
        field.setAccessible(true);
        field.set(chart, chartData.getSeriesCount());
        int orignSize = chartData.getSeriesCount();
        List<SeriesRenderData> seriesDatas = data.getSeriesDatas();
        int seriesSize = seriesDatas.size();
        XDDFCategoryDataSource categoriesData = this.createCategoryDataSource(chart, data.getCategories());
        for (int i = 0; i < seriesSize; ++i) {
            XDDFNumericalDataSource valuesData = this.createValueDataSource(chart, seriesDatas.get(i).getValues(), i);
            XDDFChartData.Series currentSeries = null;
            if (i < orignSize) {
                currentSeries = chartData.getSeries(i);
                currentSeries.replaceData((XDDFDataSource)categoriesData, valuesData);
            } else {
                currentSeries = chartData.addSeries((XDDFDataSource)categoriesData, valuesData);
            }
            String name = seriesDatas.get(i).getName();
            currentSeries.setTitle(name, chart.setSheetTitle(name, i + 1));
        }
        XSSFSheet sheet = chart.getWorkbook().getSheetAt(0);
        this.updateCTTable(sheet, seriesDatas);
        this.removeExtraSeries(chartData, sheet, data.getCategories().length, orignSize, seriesSize);
        this.plot(chart, chartData);
        chart.setTitleText(data.getChartTitle());
        chart.setTitleOverlay(false);
    }
}

