/*
 * Decompiled with CFR 0.152.
 */
package me.chanjar.weixin.common.executor;

import java.io.IOException;
import java.io.InputStream;
import me.chanjar.weixin.common.bean.CommonUploadData;
import me.chanjar.weixin.common.bean.CommonUploadParam;
import me.chanjar.weixin.common.enums.WxType;
import me.chanjar.weixin.common.error.WxError;
import me.chanjar.weixin.common.error.WxErrorException;
import me.chanjar.weixin.common.executor.CommonUploadRequestExecutor;
import me.chanjar.weixin.common.util.http.RequestHttp;
import me.chanjar.weixin.common.util.http.okhttp.OkHttpProxyInfo;
import okhttp3.MediaType;
import okhttp3.MultipartBody;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.RequestBody;
import okhttp3.Response;
import okhttp3.ResponseBody;
import okio.BufferedSink;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CommonUploadRequestExecutorOkHttpImpl
extends CommonUploadRequestExecutor<OkHttpClient, OkHttpProxyInfo> {
    public CommonUploadRequestExecutorOkHttpImpl(RequestHttp<OkHttpClient, OkHttpProxyInfo> requestHttp) {
        super(requestHttp);
    }

    @Override
    public String execute(String uri, CommonUploadParam param, WxType wxType) throws WxErrorException, IOException {
        CommonUpdateDataToRequestBodyAdapter requestBody = new CommonUpdateDataToRequestBodyAdapter(param.getData());
        MultipartBody body = new MultipartBody.Builder().setType(MediaType.get((String)"multipart/form-data")).addFormDataPart(param.getName(), param.getData().getFileName(), (RequestBody)requestBody).build();
        Request request = new Request.Builder().url(uri).post((RequestBody)body).build();
        try (Response response = ((OkHttpClient)this.requestHttp.getRequestHttpClient()).newCall(request).execute();){
            String responseContent;
            ResponseBody responseBody = response.body();
            String string = responseContent = responseBody == null ? "" : responseBody.string();
            if (responseContent.isEmpty()) {
                throw new WxErrorException(String.format("\u4e0a\u4f20\u5931\u8d25\uff0c\u670d\u52a1\u5668\u54cd\u5e94\u7a7a url:%s param:%s", uri, param));
            }
            WxError error = WxError.fromJson(responseContent, wxType);
            if (error.getErrorCode() != 0) {
                throw new WxErrorException(error);
            }
            String string2 = responseContent;
            return string2;
        }
    }

    public static class CommonUpdateDataToRequestBodyAdapter
    extends RequestBody {
        private static final MediaType CONTENT_TYPE = MediaType.get((String)"application/octet-stream");
        private CommonUploadData data;

        public long contentLength() {
            return this.data.getLength();
        }

        @Nullable
        public MediaType contentType() {
            return CONTENT_TYPE;
        }

        public void writeTo(@NotNull BufferedSink bufferedSink) throws IOException {
            int count;
            InputStream inputStream = this.data.getInputStream();
            byte[] buffer = new byte[4096];
            while ((count = inputStream.read(buffer)) != -1) {
                bufferedSink.write(buffer, 0, count);
            }
            inputStream.close();
        }

        public boolean isOneShot() {
            return true;
        }

        public CommonUpdateDataToRequestBodyAdapter(CommonUploadData data) {
            this.data = data;
        }
    }
}

